/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.publisher;

import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MPublisherModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MBaseObject;
import com.ejie.r01m.objects.R01MPrintableInterface;
import com.ejie.r01m.objects.R01MValidateInterface;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01MPublishActionObject
extends R01MBaseObject
implements R01MPrintableInterface,
R01MValidateInterface,
Serializable {
    private static final long serialVersionUID = 5596179122266746456L;
    private int step = -1;
    private String actionClass;
    private String method;
    private String objectOid;
    private String param;

    public int getStep() {
        return this.step;
    }

    public void setStep(int newStep) {
        this.step = newStep;
    }

    public String getActionClass() {
        return this.actionClass;
    }

    public void setActionClass(String newActionClass) {
        this.actionClass = newActionClass;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String newMethod) {
        this.method = newMethod;
    }

    public String getObjectOid() {
        return this.objectOid;
    }

    public void setObjectOid(String newObjectOid) {
        this.objectOid = newObjectOid;
    }

    public String getParam() {
        return this.param;
    }

    public void setParam(String newParam) {
        this.param = newParam;
    }

    public String toString() {
        StringBuffer stringElement = new StringBuffer();
        stringElement.append(this.step).append("##").append(this.actionClass == null ? "" : this.actionClass).append("##").append(this.method == null ? "" : this.method).append("##").append(this.objectOid == null ? "" : this.objectOid).append("##").append(this.param == null ? "" : this.param);
        return stringElement.toString();
    }

    public void loadFromString(String stringElement) {
        String objectPattern = "(.+)(?=##)##(.+)(?=##)##(.+)(?=##)##(.+)(?=##)##(.*)";
        Pattern p = Pattern.compile(objectPattern);
        Matcher m = p.matcher(stringElement);
        if (m.matches()) {
            this.step = NumberUtils.isInteger((String)m.group(1)) ? Integer.parseInt(m.group(1)) : -1;
            this.actionClass = m.group(2);
            this.method = m.group(3);
            this.objectOid = m.group(4);
            this.param = m.group(5);
        }
    }

    @Override
    public void validateObject() throws R01MPublisherModelObjectsValidatorException {
        if (!NumberUtils.isInteger((String)("" + this.step)) && this.step != -1 && this.step != 0 && this.step != 1 && this.step != 2 && this.step != 3) {
            throw new R01MPublisherModelObjectsValidatorException("El paso de la publicaci\u00f3n no se reconoce o no es v\u00e1lido: " + this.step);
        }
        if (StringUtils.isEmptyString((String)this.actionClass)) {
            throw new R01MPublisherModelObjectsValidatorException("La clase implementadora es " + (this.actionClass == null ? "null" : ""));
        }
        if (StringUtils.isEmptyString((String)this.method)) {
            throw new R01MPublisherModelObjectsValidatorException("El m\u00e9todo a invocar es " + (this.method == null ? "null" : ""));
        }
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(95);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== R01MPublishActionObject ========\r\n");
        sb.append(prefix);
        sb.append("\tStep:");
        sb.append(this.getStep());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tActionClass:");
        sb.append(this.getActionClass() == null ? "null" : this.getActionClass());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tMethod:");
        sb.append(this.getMethod() == null ? "null" : this.getMethod());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tObjectOid:");
        sb.append(this.getObjectOid() == null ? "null" : this.getObjectOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tParam:");
        sb.append(this.getParam() == null ? "null" : this.getParam());
        sb.append("\r\n");
        return sb;
    }
}

