/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.portalmodel;

import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.objects.portalmodel.R01MBasePortalModelObject;
import com.ejie.r01m.objects.portalmodel.R01MParamInstance;
import com.ejie.r01m.objects.portalmodel.R01MParamsSet;
import com.ejie.r01m.objects.portalmodel.R01MResource;
import com.ejie.r01m.utils.R01MConstants;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class R01MVisualAreaInstance
extends R01MBasePortalModelObject {
    private static final long serialVersionUID = -612181458714262745L;
    private String oid;
    private String visualAreaOid;
    private List<String> languages;
    private Map<String, R01MParamsSet> params;
    private Map<String, R01MResource> instanceResources = new HashMap<String, R01MResource>();
    private Date lastDateRegeneration = null;

    public String getOid() {
        return this.oid;
    }

    public void setOid(String newOid) {
        this.oid = newOid;
    }

    public String getVisualAreaOid() {
        return this.visualAreaOid;
    }

    public void setVisualAreaOid(String newVisualAreaOid) {
        this.visualAreaOid = newVisualAreaOid;
    }

    public Map<String, R01MParamsSet> getParams() {
        return this.params;
    }

    public void setParams(Map<String, R01MParamsSet> newParams) {
        this.params = newParams;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<String> newLanguages) {
        this.languages = newLanguages;
    }

    public Map<String, R01MResource> getInstanceResources() {
        return this.instanceResources;
    }

    public void setInstanceResources(Map<String, R01MResource> newInstanceResources) {
        this.instanceResources = newInstanceResources;
    }

    public String getDescription() {
        String description = null;
        R01MParamsSet r01MParamsSet = this.params.get("all");
        R01MParamInstance r01MParamInstance = r01MParamsSet.getParams().get("description");
        description = r01MParamInstance.getValue();
        if (description == null) {
            description = "";
        }
        return description;
    }

    public void setDescription(String newDescription) {
        R01MParamsSet r01MParamsSet = this.params.get("all");
        R01MParamInstance paramInstanceName = new R01MParamInstance();
        paramInstanceName.setOid("description");
        paramInstanceName.setValue(newDescription);
        r01MParamsSet.getParams().put("description", paramInstanceName);
    }

    public String getName() {
        String name = null;
        R01MParamsSet r01MParamsSet = this.params.get("all");
        R01MParamInstance r01MParamInstance = r01MParamsSet.getParams().get("name");
        name = r01MParamInstance.getValue();
        if (name == null || name.equals("")) {
            name = "unknown";
        }
        return name;
    }

    public void setName(String newName) {
        R01MParamsSet r01MParamsSet = this.params.get("all");
        R01MParamInstance paramInstanceName = new R01MParamInstance();
        paramInstanceName.setOid("name");
        paramInstanceName.setValue(newName);
        r01MParamsSet.getParams().put("name", paramInstanceName);
    }

    public Date getLastDateRegeneration() {
        return this.lastDateRegeneration;
    }

    public void setLastDateRegeneration(Date newLastDateRegeneration) {
        this.lastDateRegeneration = newLastDateRegeneration;
    }

    public String getXML() throws XOMarshallerException {
        String xml = XOManager.getXML((String)R01MConstants.PORTALMODEL_MAPFILE, (Object)this);
        if (xml.startsWith("<?xml version='1.0' encoding='ISO-8859-1'?>")) {
            return xml;
        }
        return "<?xml version='1.0' encoding='ISO-8859-1'?>" + xml;
    }

    @Override
    public void validateObject() throws R01MPortalModelObjectsValidatorException {
        String name = this.getName();
        String description = this.getDescription();
        if (name == null || this.oid == null) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MVisualAreaInstance] Los atributos (oid,name) son obligatorios.");
        }
        if (this.oid.trim().equals("") || this.oid.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MVisualAreaInstance(" + this.oid + ")][Attribute oid] 0 < tama\u00f1o <= 50.");
        }
        if ("".equals(name) || name.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MVisualAreaInstance(" + this.oid + ")][Attribute name] 0 < tama\u00f1o <= 50.");
        }
        if (description != null && description.length() > 500) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MVisualAreaInstance(" + this.oid + ")][Attribute description] 0 < tama\u00f1o <= 500.");
        }
        if (!R01MVisualAreaInstance.isValidName(name)) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MVisualAreaInstance(" + this.oid + ")][Attribute name] Debe ser caracteres en min\u00fasculas, n\u00fameros y gui\u00f3n bajo. Ej: inst_2_ad.");
        }
    }

    public static boolean isValidName(String name) {
        if (name.indexOf(13) > 0 || name.indexOf(10) > 0) {
            return false;
        }
        char[] cName = new char[50];
        name.getChars(0, name.length(), cName, 0);
        for (int i = 0; i < name.length(); ++i) {
            if (Character.getNumericValue(cName[i]) >= 10 && Character.getNumericValue(cName[i]) <= 35 || Character.getNumericValue(cName[i]) >= 0 && Character.getNumericValue(cName[i]) <= 9 || String.valueOf(cName[i]).equals("_")) continue;
            return false;
        }
        return true;
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        String tabPrefix = prefix + "\t";
        StringBuffer sb = new StringBuffer(161);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== Visual Area ========\r\n");
        sb.append(prefix);
        sb.append("\tOid:");
        sb.append(this.getOid() == null ? "null" : this.getOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tName:");
        sb.append(this.getName() == null ? "null" : this.getName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tDescription:");
        sb.append(this.getDescription() == null ? "null" : this.getDescription());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tVisualAreaOid:");
        sb.append(this.getVisualAreaOid() == null ? "null" : this.getVisualAreaOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tLanguages:\r\n");
        if (this.getLanguages() != null && this.getLanguages().size() > 0) {
            for (String string : this.getLanguages()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(string);
                sb.append(',');
            }
            sb.append(prefix);
            sb.append("\r\n");
        }
        sb.append(prefix);
        sb.append("\tinstanceResources:\r\n");
        if (this.getInstanceResources() != null && this.getInstanceResources().size() > 0) {
            for (Map.Entry entry : this.getInstanceResources().entrySet()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(((R01MResource)entry.getValue()).debugInfo(tabPrefix));
                sb.append(',');
            }
            sb.append(prefix);
            sb.append("\r\n");
        }
        sb.append(prefix);
        sb.append("\tParams:\r\n");
        if (this.getParams() != null && this.getParams().size() > 0) {
            for (Map.Entry entry : this.getParams().entrySet()) {
                R01MParamsSet param = (R01MParamsSet)entry.getValue();
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(param.debugInfo(tabPrefix));
                sb.append("\r\n");
            }
        }
        return sb;
    }
}

