/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.portalmodel;

import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.objects.portalmodel.R01MBasePortalModelObject;
import java.util.Map;

public class R01MResource
extends R01MBasePortalModelObject {
    private static final long serialVersionUID = 4614578599823272018L;
    public static final String RESOURCE_HTML = "html";
    public static final String RESOURCE_TEMPLATE = "shtml";
    public static final String RESOURCE_SCRIPT = "js";
    public static final String RESOURCE_SCRIPT_SSI = "sjs";
    public static final String RESOURCE_STYLESHEET = "css";
    public static final String RESOURCE_STYLESHEET_SSI = "scss";
    public static final String RESOURCE_STYLESHEETTEMPLATE = "csst";
    public static final String RESOURCE_INDEX = "idx";
    public static final int RESOURCE_TYPE_UNKNOWN = 0;
    public static final int RESOURCE_TYPE_TEMPLATE = 1;
    public static final int RESOURCE_TYPE_IMAGE = 2;
    public static final int RESOURCE_TYPE_SCRIPT = 3;
    public static final int RESOURCE_TYPE_STYLESHEET = 4;
    public static final int RESOURCE_TYPE_STYLESHEETTEMPLATE = 5;
    public static final int RESOURCE_TYPE_XMLDEFINITION = 6;
    public static final int RESOURCE_TYPE_HTML = 7;
    public static final int RESOURCE_TYPE_INDEX = 8;
    public static final int RESOURCE_TYPE_RESOURCE_PAGE = 9;
    public static final int RESOURCE_TYPE_PARTIAL_INDEX = 10;
    public static final int RESOURCE_TYPE_XSL = 11;
    public static final int RESOURCE_TYPE_PORTAL_PAGE_ALIAS = 12;
    public static final int MAX_RESOURCE_TYPE = 12;
    public static final int RESOURCE_TYPE_STYLESHEET_SSI = 13;
    public static final String RESOURCE_FOR_RENDER_ALL = "all";
    public static final String RESOURCE_FOR_RENDER_HTML4 = "html4";
    public static final String RESOURCE_FOR_RENDER_HTML5 = "html5";
    public static String[] typeNames = new String[]{"unknown", "template", "image", "script", "styleSheet", "styleSheetTemplate", "xmlDefinition", "html", "index", "pageIndex", "partialIndex", "xsl", "pageAlias"};
    private int type = 0;
    private int priorityLevel = 9;
    private String typeName = typeNames[0];
    private String fileName;
    private boolean ieOnly = false;
    private Map description;
    private String forRender = "all";
    private boolean sass = false;

    public R01MResource() {
    }

    public R01MResource(int newType) {
        this();
        this.type = newType;
    }

    public R01MResource(int newType, String newName) {
        this(newType);
        this.fileName = newName;
    }

    public Map getDescription() {
        return this.description;
    }

    public void setDescription(Map newDescription) {
        this.description = newDescription;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String newFileName) {
        this.fileName = newFileName;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int newType) {
        this.type = newType == 3 || newType == 4 || newType == 2 || newType == 1 || newType == 7 || newType == 8 || newType == 11 ? newType : 0;
        this.typeName = typeNames[newType];
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String newTypeName) {
        this.typeName = newTypeName;
        boolean existsType = false;
        for (int i = 0; i < typeNames.length; ++i) {
            if (!typeNames[i].equals(newTypeName)) continue;
            this.type = i;
            existsType = true;
        }
        if (!existsType) {
            this.type = 0;
        }
    }

    public boolean isIeOnly() {
        return this.ieOnly;
    }

    public void setIeOnly(boolean isIeOnly) {
        this.ieOnly = isIeOnly;
    }

    public int getPriorityLevel() {
        return this.priorityLevel;
    }

    public void setPriorityLevel(int newPriorityLevel) {
        this.priorityLevel = newPriorityLevel;
    }

    public String getForRender() {
        return this.forRender;
    }

    public void setForRender(String forRender) {
        this.forRender = forRender;
    }

    public boolean isSass() {
        return this.sass;
    }

    public void setSass(boolean sass) {
        this.sass = sass;
    }

    @Override
    public void validateObject() throws R01MPortalModelObjectsValidatorException {
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== Template ========\r\n");
        sb.append(prefix);
        sb.append("\tType:");
        sb.append(this.getType());
        sb.append(" - ");
        sb.append(this.getTypeName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tFileName:");
        sb.append(this.getFileName() == null ? "null" : this.getFileName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tDescription:\r\n");
        if (this.getDescription() != null) {
            Map.Entry me2 = null;
            for (Map.Entry me2 : this.getDescription().entrySet()) {
                sb.append(prefix);
                sb.append("\t\tIdioma:");
                sb.append(me2.getKey());
                sb.append(".Descripci\u00f3n:");
                sb.append(me2.getValue().toString());
                sb.append("\r\n");
            }
        }
        return sb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        sb.append(this.fileName == null ? "" : this.fileName);
        sb.append(':');
        sb.append(this.type);
        if (this.description != null) {
            sb.append(":[");
            sb.append((Object)(this.description.get("es") == null ? "" : this.description.get("es")));
            sb.append(':');
            sb.append((Object)(this.description.get("eu") == null ? "" : this.description.get("eu")));
            sb.append(']');
        }
        return sb.toString();
    }
}

