/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.portalmodel;

import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.objects.portalmodel.R01MBasePortalModelObject;
import com.ejie.r01m.objects.portalmodel.R01MResource;
import com.ejie.r01m.objects.portalmodel.R01MTemplateVAInclude;
import java.util.List;
import java.util.Map;

public class R01MPortalTemplate
extends R01MBasePortalModelObject
implements Comparable {
    private static final long serialVersionUID = 5274475701489531080L;
    public static final String RESOURCE_HTML = "html";
    public static final String RESOURCE_SCRIPT_SSI = "sjs";
    public static final String RESOURCE_STYLESHEET_SSI = "scss";
    public static final String RESOURCE_STYLESHEETTEMPLATE = "csst";
    private String oid;
    private String group;
    private boolean subpage = false;
    private String nameES;
    private String descriptionES;
    private String nameEU;
    private String descriptionEU;
    private String fileName;
    private Map properties;
    private Map<String, R01MTemplateVAInclude> templateVisualAreas;
    private List errors;
    private List templateResources;

    public String getOid() {
        return this.oid;
    }

    public void setOid(String newOid) {
        this.oid = newOid;
    }

    public String getNameES() {
        return this.nameES;
    }

    public void setNameES(String newNameES) {
        this.nameES = newNameES;
    }

    public String getDescriptionES() {
        return this.descriptionES;
    }

    public void setDescriptionES(String newDescriptionES) {
        this.descriptionES = newDescriptionES;
    }

    public String getNameEU() {
        return this.nameEU;
    }

    public void setNameEU(String newNameEU) {
        this.nameEU = newNameEU;
    }

    public String getDescriptionEU() {
        return this.descriptionEU;
    }

    public void setDescriptionEU(String newDescriptionEU) {
        this.descriptionEU = newDescriptionEU;
    }

    public String getName(String lang) {
        return lang.equals("es") ? this.nameES : this.nameEU;
    }

    public String getDescription(String lang) {
        return lang.equals("es") ? this.descriptionES : this.descriptionEU;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String newFileName) {
        this.fileName = newFileName;
    }

    public Map<String, R01MTemplateVAInclude> getTemplateVisualAreas() {
        return this.templateVisualAreas;
    }

    public void setTemplateVisualAreas(Map<String, R01MTemplateVAInclude> newTemplateVisualAreas) {
        this.templateVisualAreas = newTemplateVisualAreas;
    }

    public List getErrors() {
        return this.errors;
    }

    public void setErrors(List newErrors) {
        this.errors = newErrors;
    }

    public List getTemplateResources() {
        return this.templateResources;
    }

    public void setTemplateResources(List newTemplateResources) {
        this.templateResources = newTemplateResources;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String newGroup) {
        this.group = newGroup;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map newProperties) {
        this.properties = newProperties;
    }

    public boolean isSubpage() {
        return this.subpage;
    }

    public void setSubpage(boolean subpage) {
        this.subpage = subpage;
    }

    @Override
    public void validateObject() throws R01MPortalModelObjectsValidatorException {
        if (this.oid == null || this.nameES == null || this.nameEU == null || this.descriptionES == null || this.descriptionEU == null || this.fileName == null) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalTemplate] Los atributos (oid,name,nameEU,description,descriptionEU,fileName) son obligatorios.");
        }
        if (this.oid.trim().equals("") || this.oid.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalTemplate(" + this.oid + ")][Attribute oid] 0 < tama\u00f1o <= 50.");
        }
        if (this.nameES.trim().equals("") || this.nameES.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalTemplate(" + this.oid + ")][Attribute name] tama\u00f1o <= 50.");
        }
        if (this.nameEU.trim().equals("") || this.nameEU.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalTemplate(" + this.oid + ")][Attribute nameEU] tama\u00f1o <= 50.");
        }
        if (this.descriptionES.trim().equals("") || this.descriptionES.length() > 255) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalTemplate(" + this.oid + ")][Attribute description] tama\u00f1o <= 255.");
        }
        if (this.descriptionEU.trim().equals("") || this.descriptionEU.length() > 255) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalTemplate(" + this.oid + ")][Attribute descriptionEU] tama\u00f1o <= 255.");
        }
        if (this.fileName != null && this.fileName.length() > 100) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalTemplate(" + this.oid + ")][Attribute path] tama\u00f1o <= 100.");
        }
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(227);
        sb.append("\r\n");
        String tabPrefix = prefix + "\t";
        sb.append(prefix);
        sb.append("======== Template ========\r\n");
        sb.append(prefix);
        sb.append("\tOid:");
        sb.append(this.getOid() == null ? "null" : this.getOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tGroup:");
        sb.append(this.getGroup() == null ? "null" : this.getGroup());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tName:");
        sb.append(this.getNameES() == null ? "null" : this.getNameES().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tDescription:");
        sb.append(this.getDescriptionES() == null ? "null" : this.getDescriptionES().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tNameEU:");
        sb.append(this.getNameEU() == null ? "null" : this.getNameEU().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tDescriptionEU:");
        sb.append(this.getDescriptionEU() == null ? "null" : this.getDescriptionEU().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tFileName:");
        sb.append(this.getFileName() == null ? "null" : this.getFileName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tProperties:\r\n");
        if (this.getProperties() != null && this.getProperties().size() > 0) {
            for (Map.Entry me : this.getProperties().entrySet()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(me.getKey());
                sb.append(" - ");
                sb.append(me.getValue());
                sb.append("\r\n");
            }
        }
        sb.append(prefix);
        sb.append("\tTemplateVAInclude:\r\n");
        if (this.getTemplateVisualAreas() != null && this.getTemplateVisualAreas().size() > 0) {
            Map.Entry<String, R01MTemplateVAInclude> me2 = null;
            for (Map.Entry<String, R01MTemplateVAInclude> me2 : this.getTemplateVisualAreas().entrySet()) {
                R01MTemplateVAInclude va = me2.getValue();
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(va.debugInfo(tabPrefix));
                sb.append("\r\n");
            }
        }
        sb.append(prefix);
        sb.append("\tTemplateResources:\r\n");
        if (this.getTemplateResources() != null && this.getTemplateResources().size() > 0) {
            for (R01MResource resource : this.getTemplateResources()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(resource.debugInfo(tabPrefix));
                sb.append("\r\n");
            }
        }
        sb.append(prefix);
        sb.append("\tErrors:\r\n");
        if (this.getErrors() != null && this.getErrors().size() > 0) {
            for (String error : this.getErrors()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(error);
                sb.append("\r\n");
            }
        }
        return sb;
    }

    public int compareTo(Object obj) {
        R01MPortalTemplate otherTemplate = (R01MPortalTemplate)obj;
        return this.getFileName().compareTo(otherTemplate.getFileName());
    }
}

