/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.portalmodel;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MBasePublicationTarget;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class R01MPortalPublicationTarget
extends R01MBasePublicationTarget {
    private static final long serialVersionUID = 6319160742734077689L;
    protected Map<String, String> mainAlias;

    public Map<String, String> getMainAlias() {
        return this.mainAlias;
    }

    public void setMainAlias(Map<String, String> mainAlias) {
        this.mainAlias = mainAlias;
    }

    public void setMainAliasJSONArray(JSONArray jArray) {
        this.mainAlias = new HashMap<String, String>();
        try {
            if (jArray != null && jArray.length() > 0) {
                for (int i = 0; i < jArray.length(); ++i) {
                    JSONObject jObject = (JSONObject)jArray.get(i);
                    String[] names = JSONObject.getNames((JSONObject)jObject);
                    if (names == null || names.length <= 0) continue;
                    for (int n = 0; n < names.length; ++n) {
                        String key = names[n];
                        this.mainAlias.put(key, jObject.getString(key));
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setMainAlias(String mainAlias) {
        if (!StringUtils.isEmptyString((String)mainAlias)) {
            try {
                JSONArray jArray = new JSONArray(mainAlias);
                this.setMainAliasJSONArray(jArray);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public String getMainAlias(String lang) {
        if (!StringUtils.isEmptyString((String)lang) && this.mainAlias != null && !this.mainAlias.isEmpty() && this.mainAlias.containsKey(lang)) {
            return this.mainAlias.get(lang).toString();
        }
        return null;
    }

    public String getMainAliasDBValue() {
        String mainAliasDBValue = "";
        if (this.mainAlias != null && !this.mainAlias.isEmpty()) {
            JSONArray jArray = new JSONArray();
            jArray.put(this.mainAlias);
            mainAliasDBValue = jArray.toString();
        }
        return mainAliasDBValue;
    }

    @Override
    public void validateObject() throws R01MPortalModelObjectsValidatorException {
        if (this.oid == null || this.url == null) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalPublicationTarget] Los atributos (oid,url) son obligatorios.");
        }
        if (this.oid.trim().equals("") || this.oid.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalPublicationTarget (" + this.oid + ")][Attribute oid] 0 < tama\u00f1o <= 50.");
        }
        if (this.url.trim().equals("") || this.url.length() > 2000) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalPublicationTarget (" + this.oid + ")][Attribute url] 0 < tama\u00f1o <= 2000.");
        }
    }
}

