/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.portalmodel;

import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.services.R01MClientFactory;

public class R01MPortalLocation
extends R01MBaseLocationObject {
    private static final long serialVersionUID = -835815107735461267L;

    public R01MPortalLocation() {
    }

    public R01MPortalLocation(String newServerOid, String newDataRepositoryOid, String newAreaOid, String newWorkAreaOid) {
        this.serverOid = newServerOid;
        this.dataRepositoryOid = newDataRepositoryOid;
        this.areaOid = newAreaOid;
        this.workAreaOid = newWorkAreaOid;
    }

    @Override
    public void validateObject() throws R01MPortalModelObjectsValidatorException {
        if (this.serverOid == null || this.dataRepositoryOid == null || this.areaOid == null || this.workAreaOid == null) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalLocation] Los atributos (serverOid,dataRepositoryOid,areaOid,workAreaOid) son obligatorios.");
        }
        if (this.serverOid.trim().equals("") || this.serverOid.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalLocation][Attribute serverOid] 0 < tama\u00f1o <= 50.");
        }
        if (this.dataRepositoryOid.trim().equals("") || this.dataRepositoryOid.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalLocation][Attribute dataRepositoryOid] 0 < tama\u00f1o <= 50.");
        }
        if (this.areaOid.trim().equals("") || this.areaOid.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalLocation][Attribute areaOid] 0 < tama\u00f1o <= 50.");
        }
        if (this.workAreaOid.trim().equals("") || this.workAreaOid.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalLocation][Attribute workAreaOid] 0 < tama\u00f1o <= 50.");
        }
        try {
            R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(this.serverOid, this.dataRepositoryOid, this.areaOid, this.workAreaOid);
        }
        catch (R01MConfigLoadException e) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalLocation] El storage especificado no existe, revisar los xml de configuraci\u00f3n del Storage.");
        }
    }
}

