/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.portalmodel;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.objects.portalmodel.R01MBasePortalModelObject;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;

public class R01MPortalCategory
extends R01MBasePortalModelObject
implements Comparable {
    private static final long serialVersionUID = 3253209137789500971L;
    private String oid;
    private Integer level;
    private String nameES;
    private String descriptionES;
    private String nameEU;
    private String descriptionEU;

    public R01MPortalCategory() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.PORTALMANAGER_APPCODE);
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.oid = "error-unknown";
        }
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String newOid) {
        this.oid = newOid;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer newLevel) {
        this.level = newLevel;
    }

    public String getNameES() {
        return this.nameES;
    }

    public void setNameES(String newNameES) {
        this.nameES = newNameES;
    }

    public String getDescriptionES() {
        return this.descriptionES;
    }

    public void setDescriptionES(String newDescriptionES) {
        this.descriptionES = newDescriptionES;
    }

    public String getNameEU() {
        return this.nameEU;
    }

    public void setNameEU(String newNameEU) {
        this.nameEU = newNameEU;
    }

    public String getDescriptionEU() {
        return this.descriptionEU;
    }

    public void setDescriptionEU(String newDescriptionEU) {
        this.descriptionEU = newDescriptionEU;
    }

    public String getName(String lang) {
        return lang.equals("es") ? this.nameES : this.nameEU;
    }

    public String getDescription(String lang) {
        return lang.equals("es") ? this.descriptionES : this.descriptionEU;
    }

    @Override
    public void validateObject() throws R01MPortalModelObjectsValidatorException {
        if (this.oid == null || this.level == null || this.nameES == null || this.nameEU == null || this.descriptionES == null || this.descriptionEU == null) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MCategory] Los atributos (oid,level,name,nameEU,description,descriptionEU) son obligatorios.");
        }
        if (this.oid.trim().equals("") || this.oid.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MCategory(" + this.oid + ")][Attribute oid] 0 < tama\u00f1o <= 50.");
        }
        if (this.nameES.trim().equals("") || this.nameES.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalTemplate(" + this.oid + ")][Attribute name] tama\u00f1o <= 50.");
        }
        if (this.nameEU.trim().equals("") || this.nameEU.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalTemplate(" + this.oid + ")][Attribute nameEU] tama\u00f1o <= 50.");
        }
        if (this.descriptionES.trim().equals("") || this.descriptionES.length() > 255) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalTemplate(" + this.oid + ")][Attribute description] tama\u00f1o <= 255.");
        }
        if (this.descriptionEU.trim().equals("") || this.descriptionEU.length() > 255) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPortalTemplate(" + this.oid + ")][Attribute descriptionEU] tama\u00f1o <= 255.");
        }
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(118);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== Category ========\r\n");
        sb.append(prefix);
        sb.append("\tOid:");
        sb.append(this.getOid() == null ? "null" : this.getOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tLevel:");
        sb.append(this.getLevel() == null ? "null" : this.getLevel().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tName:");
        sb.append(this.getNameES() == null ? "null" : this.getNameES().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tDescription:");
        sb.append(this.getDescriptionES() == null ? "null" : this.getDescriptionES().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tNameEU:");
        sb.append(this.getNameEU() == null ? "null" : this.getNameEU().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tDescriptionEU:");
        sb.append(this.getDescriptionEU() == null ? "null" : this.getDescriptionEU().toString());
        sb.append("\r\n");
        return sb;
    }

    public int compareTo(Object obj) {
        R01MPortalCategory otherCategory = (R01MPortalCategory)obj;
        return this.getLevel() - otherCategory.getLevel();
    }
}

