/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.portalmodel;

import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.objects.portalmodel.R01MBasePortalModelObject;
import com.ejie.r01m.objects.portalmodel.R01MMetaTag;
import com.ejie.r01m.objects.portalmodel.R01MPortalAnalytics;
import com.ejie.r01m.objects.portalmodel.R01MPortalLocation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class R01MPortal
extends R01MBasePortalModelObject
implements Comparable {
    private static final long serialVersionUID = 8636035625102945070L;
    private String oid;
    private Map<String, String> name;
    private Map<String, String> description;
    private R01MPortalLocation storeLocation;
    private String portalDomain;
    private String previewDomain;
    private boolean mainDomain;
    private boolean reuseCookie;
    private String redirectionType;
    private String portalPreHome;
    private Map<String, String> preHomeRedirect;
    private String pageContentPreview;
    private R01MPortalAnalytics analytics;
    private List metaTagsIndex;
    private String indexCanonicalHref;
    private List<R01MMetaTag> metaTags;
    private Map defaultNavigators;
    private String urlContentError;
    private String urlPageError;
    private String urlVAError;
    private String publicationRepository;
    private String htmlRenderVersion;

    public String getNameES() {
        return this.getName().get("es").toString();
    }

    public String getNameEU() {
        return this.getName().get("eu").toString();
    }

    public String getDescriptionES() {
        return this.getDescription().get("es").toString();
    }

    public String getDescriptionEU() {
        return this.getDescription().get("eu").toString();
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String newOid) {
        this.oid = newOid;
    }

    public R01MPortalLocation getStoreLocation() {
        return this.storeLocation;
    }

    public void setStoreLocation(R01MPortalLocation newStoreLocation) {
        this.storeLocation = newStoreLocation;
    }

    public Map getName() {
        return this.name;
    }

    public String getAllNames() {
        StringBuffer allNames = new StringBuffer();
        if (this.getName() != null && !this.getName().isEmpty()) {
            boolean i = false;
            Iterator itNames = this.getName().entrySet().iterator();
            while (itNames.hasNext()) {
                allNames.append((i ? "-" : "") + itNames.next().toString());
            }
        }
        return allNames.toString();
    }

    public void setName(Map newName) {
        this.name = newName;
    }

    public Map getDescription() {
        return this.description;
    }

    public void setDescription(Map newDescription) {
        this.description = newDescription;
    }

    public String getPortalDomain() {
        String domain = null;
        if (this.portalDomain.indexOf(";") != -1) {
            String[] portalDomains = this.portalDomain.split(";");
            domain = portalDomains[portalDomains.length - 1];
        } else {
            domain = this.portalDomain;
        }
        return domain;
    }

    public String getPreviewDomain() {
        return this.previewDomain;
    }

    public String getAllPortalDomain() {
        return this.portalDomain;
    }

    public void setPortalDomain(String newPortalDomain) {
        this.portalDomain = newPortalDomain.trim();
    }

    public void setPreviewDomain(String newDomain) {
        this.previewDomain = newDomain.trim();
    }

    public String getRedirectionType() {
        return this.redirectionType;
    }

    public String getPortalPreHome() {
        return this.portalPreHome;
    }

    public List getMetaTags() {
        return this.metaTags;
    }

    public List getMetaTagsIndex() {
        return this.metaTagsIndex;
    }

    public void setMetaTags(List newMetaTags) {
        this.metaTags = newMetaTags;
    }

    public void setMetaTagsIndex(List newMetaTagsIndex) {
        this.metaTagsIndex = newMetaTagsIndex;
    }

    public void setRedirectionType(String newRedirectionType) {
        this.redirectionType = newRedirectionType.trim();
    }

    public void setPortalPreHome(String newPortalPreHome) {
        this.portalPreHome = newPortalPreHome.trim();
    }

    public String getPageContentPreview() {
        return this.pageContentPreview;
    }

    public void setPageContentPreview(String newPageContentPreview) {
        this.pageContentPreview = newPageContentPreview.trim();
    }

    public Map getDefaultNavigators() {
        return this.defaultNavigators;
    }

    public void setDefaultNavigators(Map newDefaultNavigators) {
        this.defaultNavigators = newDefaultNavigators;
    }

    public String getUrlContentError() {
        return this.urlContentError;
    }

    public void setUrlContentError(String newUrlContentError) {
        this.urlContentError = newUrlContentError.trim();
    }

    public String getUrlPageError() {
        return this.urlPageError;
    }

    public void setUrlPageError(String newUrlPageError) {
        this.urlPageError = newUrlPageError.trim();
    }

    public String getUrlVAError() {
        return this.urlVAError;
    }

    public void setUrlVAError(String newUrlVAError) {
        this.urlVAError = newUrlVAError.trim();
    }

    public boolean isMainDomain() {
        return this.mainDomain;
    }

    public void setMainDomain(boolean newMainDomain) {
        this.mainDomain = newMainDomain;
    }

    public boolean isReuseCookie() {
        return this.reuseCookie;
    }

    public void setReuseCookie(boolean newReuseCookie) {
        this.reuseCookie = newReuseCookie;
    }

    public Map<String, String> getPreHomeRedirect() {
        return this.preHomeRedirect;
    }

    public void setPreHomeRedirect(Map<String, String> newPreHomeRedirect) {
        this.preHomeRedirect = newPreHomeRedirect;
    }

    public R01MPortalAnalytics getAnalytics() {
        return this.analytics;
    }

    public void setAnalytics(R01MPortalAnalytics newAnalytics) {
        this.analytics = newAnalytics;
    }

    public String getIndexCanonicalHref() {
        return this.indexCanonicalHref;
    }

    public void setIndexCanonicalHref(String theIndexCanonicalHref) {
        this.indexCanonicalHref = theIndexCanonicalHref;
    }

    public String getPublicationRepository() {
        return this.publicationRepository;
    }

    public void setPublicationRepository(String thePublicationRepository) {
        this.publicationRepository = thePublicationRepository;
    }

    public String getHtmlRenderVersion() {
        return this.htmlRenderVersion;
    }

    public void setHtmlRenderVersion(String htmlRenderVersion) {
        this.htmlRenderVersion = htmlRenderVersion;
    }

    @Override
    public void validateObject() throws R01MPortalModelObjectsValidatorException {
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        String tabPrefix = prefix + "\t";
        StringBuffer sb = new StringBuffer(389);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== Portal ========\r\n");
        sb.append(prefix);
        sb.append("\tOid:");
        sb.append(this.getOid() == null ? "null" : this.getOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tNameES:");
        sb.append(this.getNameES() == null ? "null" : this.getNameES());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tNameEU:");
        sb.append(this.getNameEU() == null ? "null" : this.getNameEU());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tDescriptionES:");
        sb.append(this.getDescriptionES() == null ? "null" : this.getDescriptionES());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tDescriptionEU:");
        sb.append(this.getDescriptionEU() == null ? "null" : this.getDescriptionEU());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tServer:");
        sb.append(this.getStoreLocation().getServerOid() == null ? "null" : this.getStoreLocation().getServerOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tRepository:");
        sb.append(this.getStoreLocation().getDataRepositoryOid() == null ? "null" : this.getStoreLocation().getDataRepositoryOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tArea:");
        sb.append(this.getStoreLocation().getAreaOid() == null ? "null" : this.getStoreLocation().getAreaOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tWorkarea:");
        sb.append(this.getStoreLocation().getWorkAreaOid() == null ? "null" : this.getStoreLocation().getWorkAreaOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tPortalDomain:");
        sb.append(this.getPortalDomain() == null ? "null" : this.getPortalDomain());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tMainDomain:");
        sb.append(this.isMainDomain());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tReuseCookie:");
        sb.append(this.isReuseCookie());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tPortalPreHome:");
        sb.append(this.getPortalPreHome() == null ? "null" : this.getPortalPreHome());
        sb.append("\r\n");
        if (this.getPreHomeRedirect() != null && !this.getPreHomeRedirect().isEmpty()) {
            sb.append(prefix);
            sb.append("\t======== Prehome redirections ========\r\n");
            for (String lang : this.getPreHomeRedirect().keySet()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(lang);
                sb.append('=');
                sb.append(this.getPreHomeRedirect().get(lang));
                sb.append("\r\n");
            }
        } else {
            sb.append(prefix);
            sb.append("\tPrehome redirections a null.\r\n");
        }
        sb.append(prefix);
        sb.append("\tPageContentPreview:");
        sb.append(this.getPageContentPreview() == null ? "null" : this.getPageContentPreview());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tAnal\u00edtica web:");
        sb.append(this.analytics.debugInfo(tabPrefix));
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tMetaTags:\r\n");
        if (this.getMetaTags() != null && !this.getMetaTags().isEmpty()) {
            for (R01MMetaTag metaTag : this.getMetaTags()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(metaTag.debugInfo(tabPrefix));
                sb.append("\r\n");
            }
        }
        sb.append(prefix);
        sb.append("\tMetaTagsIndex:\r\n");
        if (this.getMetaTagsIndex() != null && !this.getMetaTagsIndex().isEmpty()) {
            for (R01MMetaTag metaTag : this.getMetaTagsIndex()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(metaTag.debugInfo(tabPrefix));
                sb.append("\r\n");
            }
        }
        sb.append(prefix);
        sb.append("\tIndexCanonicalHref:\r\n");
        sb.append(this.getIndexCanonicalHref() == null ? "null" : this.getIndexCanonicalHref());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tPublicationRepository:\r\n");
        sb.append(this.getPublicationRepository() == null ? "null" : this.getPublicationRepository());
        sb.append("\r\n");
        return sb;
    }

    public int compareTo(Object obj) {
        R01MPortal portal = (R01MPortal)obj;
        return this.getOid().compareTo(portal.getOid());
    }
}

