/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.portalmodel;

import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.objects.portalmodel.R01MBasePortalModelObject;
import com.ejie.r01m.objects.portalmodel.R01MParamNode;
import java.util.List;

public class R01MParamInstance
extends R01MBasePortalModelObject {
    private static final long serialVersionUID = -8223803921754381126L;
    private String oid;
    private String value;
    private List nodes;

    public List getNodes() {
        return this.nodes;
    }

    public void setNodes(List newNodes) {
        this.nodes = newNodes;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String newOid) {
        this.oid = newOid;
    }

    public String getValue() {
        if (this.value != null && this.value.startsWith("<![CDATA[") && this.value.endsWith("]]>")) {
            return this.value.substring(9, this.value.length() - 3);
        }
        return this.value;
    }

    public void setCDATAValue(String newValue) {
        this.value = "<![CDATA[" + newValue + "]]>";
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    @Override
    public void validateObject() throws R01MPortalModelObjectsValidatorException {
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        String tabPrefix = prefix + "\t";
        StringBuffer sb = new StringBuffer(100);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== Param ========\r\n");
        sb.append(prefix);
        sb.append("\tOid:");
        sb.append(this.getOid() == null ? "null" : this.getOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tValue:");
        sb.append(this.getValue() == null ? "null" : this.getValue());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tNodes:\r\n");
        if (this.getNodes() != null && this.getNodes().size() > 0) {
            for (R01MParamNode node : this.getNodes()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(node.debugInfo(tabPrefix));
                sb.append("\r\n");
            }
        }
        return sb;
    }
}

