/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.portalmodel;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MURLAlias;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.cataloguing.picks.R01MGeoPick;
import com.ejie.r01m.objects.cataloguing.picks.R01MGeoPicks;
import com.ejie.r01m.objects.portalmodel.R01MBasePortalModelObject;
import com.ejie.r01m.objects.portalmodel.R01MMetaTag;
import com.ejie.r01m.objects.portalmodel.R01MPageTag;
import com.ejie.r01m.objects.portalmodel.R01MPageVAInclude;
import com.ejie.r01m.objects.portalmodel.R01MPortalPublicationRequested;
import com.ejie.r01m.objects.portalmodel.R01MPortalPublicationTarget;
import com.ejie.r01m.objects.portalmodel.R01MVisualAreaInstance;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MPortalManagerAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.portal.R01MPortalPathHelpper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01MPage
extends R01MBasePortalModelObject {
    private static final long serialVersionUID = 1496064525546708724L;
    private String oid;
    private String portalOid;
    private Map<String, R01MPageVAInclude> visualAreas;
    private String name;
    private String description;
    private String internalName;
    private String author;
    private Date createDate = Calendar.getInstance().getTime();
    private String templateOid;
    private String categoryOid;
    private List<R01MStructureCatalog> labels;
    private R01MGeoPicks geoLabels;
    private List<R01MPortalPublicationTarget> publicationInfo;
    private Map<String, R01MPortalPublicationRequested> requestedPublications;
    private List<R01MURLAlias> urlAliases;
    private List<R01MMetaTag> metaTags;
    private List<R01MPageTag> pageTags;
    private List<String> errors;
    private int indexPage;
    private String redirectUrl = null;
    private String rssTitle;
    private String rssLink = null;
    private boolean analyticsActive = true;
    private boolean indexActive = false;
    private boolean unpublishIndexFiles = false;
    private boolean subpage = false;

    public R01MPage() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.PORTALMANAGER_APPCODE);
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.oid = "error-unknown";
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String newAuthor) {
        this.author = newAuthor;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date newCreateDate) {
        this.createDate = newCreateDate;
    }

    public R01MGeoPicks getGeoLabels() {
        return this.geoLabels;
    }

    public void setGeoLabels(R01MGeoPicks newGeoLabels) {
        this.geoLabels = newGeoLabels;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String newInternalName) {
        this.internalName = newInternalName;
    }

    public List<R01MStructureCatalog> getLabels() {
        return this.labels;
    }

    public void setLabels(List<R01MStructureCatalog> newLabels) {
        this.labels = newLabels;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public String getOid() {
        return this.oid;
    }

    public String getPortalOid() {
        return this.portalOid;
    }

    public void setPortalOid(String newPortalOid) {
        this.portalOid = newPortalOid;
    }

    public String getTemplateOid() {
        return this.templateOid;
    }

    public void setTemplateOid(String newTemplateOid) {
        this.templateOid = newTemplateOid;
    }

    public Map<String, R01MPageVAInclude> getVisualAreas() {
        return this.visualAreas;
    }

    public Map<String, R01MPageVAInclude> getVisualAreasSortById() {
        LinkedHashMap<String, R01MPageVAInclude> orderedMap = null;
        if (this.visualAreas != null && !this.visualAreas.isEmpty()) {
            ArrayList<R01MPageVAInclude> mapValues = new ArrayList<R01MPageVAInclude>(this.visualAreas.values());
            TreeSet<R01MPageVAInclude> sortedSet = new TreeSet<R01MPageVAInclude>(mapValues);
            orderedMap = new LinkedHashMap<String, R01MPageVAInclude>();
            for (R01MPageVAInclude vaInclude : sortedSet) {
                orderedMap.put(vaInclude.getId(), vaInclude);
            }
        }
        return orderedMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Map<String, R01MPageVAInclude>> getVisualAreasGroupedByLanguage() throws R01MPortalModelObjectsValidatorException {
        HashMap<String, Map<String, R01MPageVAInclude>> outVAs = new HashMap<String, Map<String, R01MPageVAInclude>>();
        if (this.visualAreas == null || this.visualAreas.isEmpty()) return outVAs;
        String currVAOid = null;
        HashMap<String, R01MPageVAInclude> currLangVAs = null;
        try {
            R01MPortalManagerAPI portalModelAPI = R01MClientFactory.getPortalModelAPI(R01MAuthManager.createMasterSystemUserContext(), this.portalOid);
            R01MVisualAreaInstance vaInstance = null;
            for (R01MPageVAInclude currVA : this.visualAreas.values()) {
                currVAOid = currVA.getInstanceOid();
                try {
                    vaInstance = portalModelAPI.loadVAInstance(currVAOid);
                    if (vaInstance == null || vaInstance.getLanguages() == null || vaInstance.getLanguages().size() <= 0) continue;
                    for (String currVALang : vaInstance.getLanguages()) {
                        if (outVAs.get(currVALang) == null) {
                            currLangVAs = new HashMap<String, R01MPageVAInclude>();
                            currLangVAs.put(currVAOid, currVA);
                            outVAs.put(currVALang, currLangVAs);
                            continue;
                        }
                        ((Map)outVAs.get(currVALang)).put(currVAOid, currVA);
                    }
                }
                catch (R01MPortalModelException pmEx) {
                    pmEx.printStackTrace(System.out);
                    throw new R01MPortalModelObjectsValidatorException("Error al recoger las \u00e1reas visuales agrupadas por idioma: " + pmEx);
                    return outVAs;
                }
            }
        }
        catch (R01MSecurityException secEx) {
            secEx.printStackTrace(System.out);
            throw new R01MPortalModelObjectsValidatorException("Error al recoger las \u00e1reas visuales agrupadas por idioma: " + secEx);
        }
    }

    public void setVisualAreas(Map<String, R01MPageVAInclude> newVisualAreas) {
        this.visualAreas = newVisualAreas;
    }

    public String getCategoryOid() {
        return this.categoryOid;
    }

    public void setCategoryOid(String newCategoryOid) {
        this.categoryOid = newCategoryOid;
    }

    public void setOid(String newOid) {
        this.oid = newOid;
    }

    public List<R01MPortalPublicationTarget> getPublicationInfo() {
        return this.publicationInfo;
    }

    public void setPublicationInfo(List<R01MPortalPublicationTarget> newPublicationInfo) {
        this.publicationInfo = newPublicationInfo;
    }

    public Map<String, R01MPortalPublicationRequested> getRequestedPublications() {
        return this.requestedPublications;
    }

    public void setRequestedPublications(Map<String, R01MPortalPublicationRequested> newRequestedPublications) {
        this.requestedPublications = newRequestedPublications;
    }

    public List<R01MURLAlias> getUrlAliases() {
        return this.urlAliases;
    }

    public void setUrlAliases(List<R01MURLAlias> newUrlAliases) {
        this.urlAliases = newUrlAliases;
    }

    public List<R01MMetaTag> getMetaTags() {
        return this.metaTags;
    }

    public List<R01MMetaTag> getMetaTags(String languageOid) {
        ArrayList<R01MMetaTag> metaTagsLang = new ArrayList<R01MMetaTag>();
        if (this.metaTags != null && this.metaTags.size() > 0) {
            for (R01MMetaTag meta : this.metaTags) {
                if (!meta.getLanguage().equals(languageOid)) continue;
                metaTagsLang.add(meta);
            }
        }
        return !metaTagsLang.isEmpty() ? metaTagsLang : null;
    }

    public Set<String> getMetaTagsLanguages() {
        HashSet<String> langMetas = new HashSet<String>();
        if (this.metaTags != null && this.metaTags.size() > 0) {
            for (R01MMetaTag meta : this.metaTags) {
                langMetas.add(meta.getLanguage());
            }
        }
        return !langMetas.isEmpty() ? langMetas : null;
    }

    public void setMetaTags(List<R01MMetaTag> newMetaTags) {
        this.metaTags = newMetaTags;
    }

    public List<R01MPageTag> getPageTags() {
        return this.pageTags;
    }

    public void setPageTags(List<R01MPageTag> newPageTags) {
        this.pageTags = newPageTags;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> newErrors) {
        this.errors = newErrors;
    }

    public int getIndexPage() {
        return this.indexPage;
    }

    public void setIndexPage(int newIndexPage) {
        this.indexPage = newIndexPage;
    }

    public boolean isIndexPage() {
        return this.indexPage == 1;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String newRedirectUrl) {
        this.redirectUrl = newRedirectUrl;
    }

    public String getRssTitle() {
        return this.rssTitle;
    }

    public void setRssTitle(String newRssTitle) {
        this.rssTitle = newRssTitle;
    }

    public String getRssLink() {
        return this.rssLink;
    }

    public void setRssLink(String newRssLink) {
        this.rssLink = newRssLink;
    }

    public boolean isAnalyticsActive() {
        return this.analyticsActive;
    }

    public void setAnalyticsActive(boolean theAnalyticsActive) {
        this.analyticsActive = theAnalyticsActive;
    }

    public boolean isIndexActive() {
        return this.indexActive;
    }

    public void setIndexActive(boolean theIndexActive) {
        if (this.indexActive && !theIndexActive) {
            this.unpublishIndexFiles = true;
        }
        this.indexActive = theIndexActive;
    }

    public boolean isUnpublishIndexFiles() {
        return this.unpublishIndexFiles;
    }

    public void setUnpublishIndexFiles(boolean theUnpublishIndexFiles) {
        this.unpublishIndexFiles = theUnpublishIndexFiles;
    }

    public boolean isSubpage() {
        return this.subpage;
    }

    public void setSubpage(boolean subpage) {
        this.subpage = subpage;
    }

    public String getXML() throws XOMarshallerException {
        String xml = XOManager.getXML((String)R01MConstants.PORTALMODEL_MAPFILE, (Object)this);
        if (xml.startsWith("<?xml version='1.0' encoding='ISO-8859-1'?>")) {
            return xml;
        }
        return "<?xml version='1.0' encoding='ISO-8859-1'?>" + xml;
    }

    @Override
    public void validateObject() throws R01MPortalModelObjectsValidatorException {
        if (this.createDate == null || this.portalOid == null || this.categoryOid == null || this.templateOid == null) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPage] Los atributos (oid,internalName,name,author,createDate,portalOid,categoryOid,templateOid) son obligatorios.");
        }
        if (StringUtils.isEmptyString((String)this.oid) || this.oid.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPage(" + this.oid + ")][Attribute oid] 0 < tama\u00f1o <= 50.");
        }
        if (StringUtils.isEmptyString((String)this.internalName) || this.internalName.length() > 8) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPage(" + this.oid + ")][Attribute internalName] 0 < tama\u00f1o <= 8.");
        }
        if (StringUtils.isEmptyString((String)this.name) || this.name.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPage(" + this.oid + ")][Attribute name] 0 < tama\u00f1o <= 50.");
        }
        if (this.description != null && this.description.length() > 500) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPage(" + this.oid + ")][Attribute description] 0 < tama\u00f1o <= 500.");
        }
        if (StringUtils.isEmptyString((String)this.author) || this.author.length() > 50) {
            throw new R01MPortalModelObjectsValidatorException("[Object R01MPage(" + this.oid + ")][Attribute author] 0 < tama\u00f1o <= 50.");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            for (int i = 0; i < this.labels.size(); ++i) {
                R01MStructureCatalog label = this.labels.get(i);
                if (label != null) {
                    try {
                        label.validateObject();
                    }
                    catch (R01MContentModelObjectsValidatorException e) {
                        R01FLog.to((String)"r01m.portalAPI").warning("[Object R01MPage(" + this.oid + ")][Attribute label] La etiqueta de catalogaci\u00f3n en ejes " + label.getOid() + "es incorrecta.");
                    }
                    continue;
                }
                throw new R01MPortalModelObjectsValidatorException("[Object R01MPage(" + this.oid + ")][Attribute labels] Contiene valores NULL.");
            }
        }
        if (this.geoLabels != null && !this.geoLabels.getGeopicks().isEmpty()) {
            for (R01MGeoPick geoCatalog : this.geoLabels.getGeopicks()) {
                if (geoCatalog != null) {
                    try {
                        geoCatalog.getGeocode().validateObject();
                        continue;
                    }
                    catch (R01MContentModelObjectsValidatorException e) {
                        throw new R01MPortalModelObjectsValidatorException("[Object R01MPage(" + this.oid + ")][Attribute label] La etiqueta de catalogaci\u00f3n geogr\u00e1fica " + geoCatalog.getOid() + "es incorrecta.", (Exception)((Object)e));
                    }
                }
                throw new R01MPortalModelObjectsValidatorException("[Object R01MPage(" + this.oid + ")][Attribute geoLabels] Contiene valores NULL.");
            }
        }
        HashMap<String, Boolean> hasAliasBaseByLang = new HashMap<String, Boolean>();
        HashMap<String, Boolean> hasAliasByLang = new HashMap<String, Boolean>();
        if (this.urlAliases != null && !this.urlAliases.isEmpty()) {
            for (R01MURLAlias alias : this.urlAliases) {
                if (alias != null) {
                    Pattern p = Pattern.compile("/?[a-z][^-/]+-[a-zA-Z0-9_]+/([a-z]{2}).*");
                    Matcher m = p.matcher(alias.getUrl());
                    String currentLanguage = m.matches() ? m.group(1) : "";
                    hasAliasByLang.put(currentLanguage, Boolean.TRUE);
                    if (!StringUtils.isEmptyString((String)currentLanguage) && alias.isBaseAlias()) {
                        if (hasAliasBaseByLang.get(currentLanguage) != null && ((Boolean)hasAliasBaseByLang.get(currentLanguage)).booleanValue()) {
                            alias.setBaseAlias(false);
                            R01FLog.to((String)"r01m.portalAPI").info("[Object R01MPage(" + this.oid + ")][Attribute urlalias] El alias base para la p\u00e1gina debe ser \u00fanico: " + alias.getAlias() + " se establece como no base.");
                        }
                        hasAliasBaseByLang.put(currentLanguage, Boolean.TRUE);
                    }
                    try {
                        alias.validateObject();
                        continue;
                    }
                    catch (R01MModelObjectsValidatorException ex) {
                        throw new R01MPortalModelObjectsValidatorException((Exception)((Object)ex));
                    }
                }
                throw new R01MPortalModelObjectsValidatorException("[Object R01MPage(" + this.oid + ")][Attribute urlalias] Contiene valores NULL.");
            }
            for (String langWithAliasentry : hasAliasByLang.keySet()) {
                if (hasAliasBaseByLang.get(langWithAliasentry) != null) continue;
                throw new R01MPortalModelObjectsValidatorException("[Object R01MPage(" + this.oid + ")][Attribute urlalias] No existe un alias base para la p\u00e1gina.");
            }
        }
    }

    public boolean isValid() {
        return this.errors == null || this.errors.size() == 0;
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        String tabPrefix = prefix + "\t";
        StringBuffer sb = new StringBuffer(500);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== Page  ========\r\n");
        sb.append(prefix);
        sb.append("\tOid:");
        sb.append(this.getOid() == null ? "null" : this.getOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tPortalOid:");
        sb.append(this.getPortalOid() == null ? "null" : this.getPortalOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tIndexPage:");
        sb.append(this.isIndexPage() ? "true" : "false");
        sb.append("\r\n");
        if (this.getVisualAreas() != null && this.getVisualAreas().size() > 0) {
            sb.append(prefix);
            sb.append("\tVisual Areas Include:\r\n");
            for (Map.Entry<String, R01MPageVAInclude> entry : this.getVisualAreas().entrySet()) {
                R01MPageVAInclude va = entry.getValue();
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(va.debugInfo(tabPrefix));
                sb.append("\r\n");
            }
        }
        sb.append(prefix);
        sb.append("\tName:");
        sb.append(this.getName() == null ? "null" : this.getName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tDescription:");
        sb.append(this.getDescription() == null ? "null" : this.getDescription());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tInternalName:");
        sb.append(this.getInternalName() == null ? "null" : this.getInternalName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tAuthor:");
        sb.append(this.getAuthor() == null ? "null" : this.getAuthor());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tCreatedate:");
        sb.append(this.getCreateDate() == null ? "null" : this.getCreateDate().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tTemplateOid:");
        sb.append(this.getTemplateOid() == null ? "null" : this.getTemplateOid().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tCategoryOid:");
        sb.append(this.getCategoryOid() == null ? "null" : this.getCategoryOid().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tLabels:\r\n");
        if (this.getLabels() != null && !this.getLabels().isEmpty()) {
            for (R01MStructureCatalog r01MStructureCatalog : this.getLabels()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(r01MStructureCatalog.debugInfo(tabPrefix));
                sb.append("\r\n");
            }
        }
        sb.append(prefix);
        sb.append("\tGeolabels:\r\n");
        if (this.getGeoLabels() != null && !this.getGeoLabels().getGeopicks().isEmpty()) {
            for (R01MGeoPick r01MGeoPick : this.getGeoLabels().getGeopicks()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(r01MGeoPick.getGeocode().debugInfo(tabPrefix));
                sb.append("\r\n");
            }
        }
        sb.append(prefix);
        sb.append("\tPublicationInfo:\r\n");
        if (this.getPublicationInfo() != null && !this.getPublicationInfo().isEmpty()) {
            for (R01MPortalPublicationTarget r01MPortalPublicationTarget : this.getPublicationInfo()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(r01MPortalPublicationTarget.debugInfo(tabPrefix));
                sb.append("\r\n");
            }
        }
        sb.append(prefix);
        sb.append("\tPublicationsRequested:\r\n");
        if (this.getRequestedPublications() != null && !this.getRequestedPublications().isEmpty()) {
            for (Map.Entry entry : this.getRequestedPublications().entrySet()) {
                R01MPortalPublicationRequested publi = (R01MPortalPublicationRequested)entry.getValue();
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(publi.debugInfo(tabPrefix));
                sb.append("\r\n");
            }
        }
        sb.append(prefix);
        sb.append("\tTags:\r\n");
        if (this.getMetaTags() != null && !this.getMetaTags().isEmpty()) {
            for (R01MMetaTag r01MMetaTag : this.getMetaTags()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(r01MMetaTag.debugInfo(tabPrefix));
                sb.append("\r\n");
            }
        }
        sb.append(prefix);
        sb.append("\tProperties:\r\n");
        if (this.getPageTags() != null && !this.getPageTags().isEmpty()) {
            for (R01MPageTag r01MPageTag : this.getPageTags()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(r01MPageTag.debugInfo(tabPrefix));
                sb.append("\r\n");
            }
        }
        sb.append(prefix);
        sb.append("\tURLAliases:\r\n");
        if (this.getUrlAliases() != null && !this.getUrlAliases().isEmpty()) {
            for (R01MURLAlias r01MURLAlias : this.getUrlAliases()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(r01MURLAlias.debugInfo(tabPrefix));
                sb.append("\r\n");
            }
        }
        sb.append(prefix);
        sb.append("\tErrors:\r\n");
        if (this.getErrors() != null && !this.getErrors().isEmpty()) {
            for (String string : this.getErrors()) {
                sb.append(prefix);
                sb.append("\t\t");
                sb.append(string);
                sb.append("\r\n");
            }
        }
        sb.append(prefix);
        sb.append("%%%%%%%%%%%%%%%%% FIN PAGE Oid: ");
        sb.append(this.getOid() == null ? "null" : this.getOid());
        sb.append(" %%%%%%%%%%%%%%%%%%%%%\r\n");
        return sb;
    }

    public String getAdminUrl(String uiLang, String lang) {
        if (this.getPortalOid() != null && this.internalName != null) {
            return R01MPortalPathHelpper.obtainAdminPageURL(uiLang, this.getPortalOid(), this.getInternalName(), lang);
        }
        return null;
    }

    public String getEditUrl(String uiLang) {
        if (this.getOid() != null) {
            return R01MPortalPathHelpper.obtainEditPageURL(uiLang, this.getOid());
        }
        return null;
    }

    public String getPreviewUrl(String lang) {
        return this.getViewUrl(lang);
    }

    public String getViewUrl(String lang) {
        if (this.getPortalOid() != null && this.internalName != null) {
            return R01MPortalPathHelpper.obtainPortalPageURL(this.getPortalOid(), this.getInternalName(), lang);
        }
        return null;
    }

    public boolean isPublishedInRepository(String repOid) {
        if (repOid == null) {
            return false;
        }
        boolean isPublished = false;
        List<R01MPortalPublicationTarget> publications = this.getPublicationInfo();
        if (publications != null && !publications.isEmpty()) {
            ArrayList<R01MPortalPublicationTarget> targetPublications = new ArrayList<R01MPortalPublicationTarget>();
            for (R01MPortalPublicationTarget publicacion : publications) {
                if (!publicacion.getOid().equals(repOid)) continue;
                targetPublications.add(publicacion);
            }
            if (!targetPublications.isEmpty()) {
                for (R01MPortalPublicationTarget pub1 : targetPublications) {
                    if (pub1.getState() != 1) continue;
                    boolean isUnpublished = false;
                    for (R01MPortalPublicationTarget pub2 : targetPublications) {
                        if (!pub1.getOid().equals(pub2.getOid()) || pub2.getState() != 0) continue;
                        isUnpublished = true;
                        if (!pub1.getPublishDate().after(pub2.getPublishDate())) break;
                        isPublished = true;
                        break;
                    }
                    if (isUnpublished) continue;
                    isPublished = true;
                    break;
                }
            }
        }
        return isPublished;
    }

    public boolean isPublishedInAnyRepository() {
        String publishedRespository = this.getPublishedRepository();
        return !StringUtils.isEmptyString((String)publishedRespository);
    }

    public String getPublishedRepository() {
        List<R01MPortalPublicationTarget> publications = this.getPublicationInfo();
        if (publications != null && !publications.isEmpty()) {
            for (R01MPortalPublicationTarget publicacion : publications) {
                if (!this.isPublishedInRepository(publicacion.getOid())) continue;
                return publicacion.getOid();
            }
        }
        return null;
    }

    public Map<String, R01MURLAlias> getMainAliasByLang() {
        HashMap<String, R01MURLAlias> mainAlias = new HashMap<String, R01MURLAlias>();
        if (this.urlAliases != null && !this.urlAliases.isEmpty()) {
            for (int i = 0; i < this.urlAliases.size(); ++i) {
                R01MURLAlias currAlias = this.urlAliases.get(i);
                if (!currAlias.isBaseAlias()) continue;
                mainAlias.put(currAlias.getLang(), currAlias);
            }
        }
        return mainAlias;
    }

    public Map<String, String> getMainAliasURLByLang() {
        HashMap<String, String> mainAlias = new HashMap<String, String>();
        if (this.urlAliases != null && !this.urlAliases.isEmpty()) {
            for (int i = 0; i < this.urlAliases.size(); ++i) {
                R01MURLAlias currAlias = this.urlAliases.get(i);
                if (!currAlias.isBaseAlias()) continue;
                mainAlias.put(currAlias.getLang(), currAlias.getAlias());
            }
        }
        return mainAlias;
    }

    public Map<String, List<R01MURLAlias>> getAliasByLang() {
        HashMap<String, List<R01MURLAlias>> alias = new HashMap<String, List<R01MURLAlias>>();
        if (this.urlAliases != null && !this.urlAliases.isEmpty()) {
            for (int i = 0; i < this.urlAliases.size(); ++i) {
                R01MURLAlias currAlias = this.urlAliases.get(i);
                if (alias.containsKey(currAlias.getLang())) {
                    ((List)alias.get(currAlias.getLang())).add(currAlias);
                    continue;
                }
                ArrayList<R01MURLAlias> aliasList = new ArrayList<R01MURLAlias>();
                aliasList.add(currAlias);
                alias.put(currAlias.getLang(), aliasList);
            }
        }
        return alias;
    }

    public String getPublishedBaseAlias(String lang) {
        String baseAlias = "";
        String publishedRespository = this.getPublishedRepository();
        List<R01MPortalPublicationTarget> publications = this.getPublicationInfo();
        if (!StringUtils.isEmptyString((String)publishedRespository) && publications != null && !publications.isEmpty()) {
            for (R01MPortalPublicationTarget publicacion : publications) {
                if (!publicacion.getOid().equals(publishedRespository) || publicacion.getState() != 1) continue;
                baseAlias = publicacion.getMainAlias(lang);
                break;
            }
        }
        return baseAlias;
    }
}

