/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.opendata;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MMiscDataLoadException;
import com.ejie.r01m.objects.contentmodel.R01MBaseContentModelObject;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.opendata.R01MBaseOpendataPackageInterface;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.Serializable;
import java.util.Map;

public class R01MOpendataPackage
extends R01MBaseContentModelObject
implements Serializable,
R01MBaseOpendataPackageInterface {
    private static final long serialVersionUID = -9085596384694146317L;
    public static final String PERIODICITY_ONCE = "O";
    public static final String PERIODICITY_DAILY = "D";
    public static final String PERIODICITY_WEEKLY = "S";
    public static final String PERIODICITY_BIWEEKLY = "Q";
    public static final String PERIODICITY_MONTHLY = "M";
    public static final String PERIODICITY_QUARTERLY = "T";
    public static final String PERIODICITY_YEARLY = "A";
    public static final int ACTIVE = 1;
    public static final int NO_ACTIVE = 0;
    private String oid = null;
    private String namePackage = null;
    private R01MContentLocation storeData = null;
    private String workareaRelativePath = null;
    private String periodicityPackage = null;
    private String datePackage = null;
    private int statePackage;
    private String searchPackage = null;
    private int exportAttachments;
    private int langVersions;
    private String contentOidPackage;
    private long sizePackage;
    private String errMessagePackage;
    private long updateDatePackage;
    private int onProcessPackage;
    private String lang;

    public R01MOpendataPackage() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.CONTENTMANAGER_APPCODE, "content");
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.oid = "error-unknown";
        }
    }

    public R01MOpendataPackage(R01MContentLocation theStoreData, String theNamePackage, String theWorkareaRelativePath, String thePeriodicityPackage, String theDatePackage, int theStatePackage, String theSearchPackage, int theExportAttachments, int theLangVersions) {
        this(theStoreData, theNamePackage, theWorkareaRelativePath, thePeriodicityPackage, theDatePackage, theStatePackage, theSearchPackage, theExportAttachments, theLangVersions, "");
    }

    public R01MOpendataPackage(R01MContentLocation theStoreData, String theNamePackage, String theWorkareaRelativePath, String thePeriodicityPackage, String theDatePackage, int theStatePackage, String theSearchPackage, int theExportAttachments, int theLangVersions, String theLang) {
        this();
        this.storeData = theStoreData;
        this.namePackage = theNamePackage;
        this.workareaRelativePath = theWorkareaRelativePath;
        this.periodicityPackage = thePeriodicityPackage;
        this.datePackage = theDatePackage;
        this.statePackage = theStatePackage;
        this.searchPackage = theSearchPackage;
        this.exportAttachments = theExportAttachments;
        this.langVersions = theLangVersions;
        this.lang = theLang;
    }

    public R01MOpendataPackage(R01MContentLocation theStoreData, String theNamePackage, String theWorkareaRelativePath, String thePeriodicityPackage, String theDatePackage, int theStatePackage, String theSearchPackage, int theExportAttachments, String theContentOidPackage) {
        this(theStoreData, theNamePackage, theWorkareaRelativePath, thePeriodicityPackage, theDatePackage, theStatePackage, theSearchPackage, theExportAttachments, theContentOidPackage, "");
    }

    public R01MOpendataPackage(R01MContentLocation theStoreData, String theNamePackage, String theWorkareaRelativePath, String thePeriodicityPackage, String theDatePackage, int theStatePackage, String theSearchPackage, int theExportAttachments, String theContentOidPackage, String theLang) {
        this();
        this.storeData = theStoreData;
        this.namePackage = theNamePackage;
        this.workareaRelativePath = theWorkareaRelativePath;
        this.periodicityPackage = thePeriodicityPackage;
        this.datePackage = theDatePackage;
        this.statePackage = theStatePackage;
        this.searchPackage = theSearchPackage;
        this.exportAttachments = theExportAttachments;
        this.contentOidPackage = theContentOidPackage;
        this.lang = theLang;
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    public void setOid(String theOid) {
        this.oid = theOid;
    }

    public R01MContentLocation getStoreData() {
        return this.storeData;
    }

    public void setStoreData(R01MContentLocation theStoreData) {
        this.storeData = theStoreData;
    }

    @Override
    public String getNamePackage() {
        return this.namePackage;
    }

    public void setNamePackage(String theNamePackage) {
        this.namePackage = theNamePackage;
    }

    public String getPeriodicityPackage() {
        return this.periodicityPackage;
    }

    public void setPeriodicityPackage(String thePeriodicityPackage) {
        this.periodicityPackage = thePeriodicityPackage;
    }

    public String getDatePackage() {
        return this.datePackage;
    }

    public void setDatePackage(String theDatePackage) {
        this.datePackage = theDatePackage;
    }

    @Override
    public int getStatePackage() {
        return this.statePackage;
    }

    public void setStatePackage(int theExecutedPackage) {
        this.statePackage = theExecutedPackage;
    }

    public String getSearchPackage() {
        return this.searchPackage;
    }

    public void setSearchPackage(String theSearchPackage) {
        this.searchPackage = theSearchPackage;
    }

    public String getWorkareaRelativePath() {
        return this.workareaRelativePath;
    }

    public void setWorkareaRelativePath(String theWorkareaRelativePath) {
        this.workareaRelativePath = theWorkareaRelativePath;
    }

    public int getExportAttachments() {
        return this.exportAttachments;
    }

    public void setExportAttachments(int theExportAttachments) {
        this.exportAttachments = theExportAttachments;
    }

    public int getLangVersions() {
        return this.langVersions;
    }

    public void setLangVersions(int theLangVersions) {
        this.langVersions = theLangVersions;
    }

    @Override
    public String getContentOidPackage() {
        return this.contentOidPackage;
    }

    public void setContentOidPackage(String contentOidPackage) {
        this.contentOidPackage = contentOidPackage;
    }

    @Override
    public long getSizePackage() {
        return this.sizePackage;
    }

    public void setSizePackage(long sizePackage) {
        this.sizePackage = sizePackage;
    }

    @Override
    public String getErrMessagePackage() {
        return this.errMessagePackage;
    }

    public void setErrMessagePackage(String errMessagePackage) {
        this.errMessagePackage = errMessagePackage;
    }

    @Override
    public long getUpdateDatePackage() {
        return this.updateDatePackage;
    }

    public void setUpdateDatePackage(long updateDatePackage) {
        this.updateDatePackage = updateDatePackage;
    }

    @Override
    public int getOnProcessPackage() {
        return this.onProcessPackage;
    }

    public void setOnProcessPackage(int onProcessPackage) {
        this.onProcessPackage = onProcessPackage;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    @Override
    public void validateObject() throws R01MContentModelObjectsValidatorException {
        if (this.oid == null || this.namePackage == null || this.storeData == null || this.datePackage == null || this.periodicityPackage == null || this.searchPackage == null || this.workareaRelativePath == null) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MOpendataPackage] Los atributos (oid, name) son obligatorios.");
        }
        if (StringUtils.isEmptyString((String)this.oid) || this.oid.length() > 50) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MOpendataPackage(" + this.oid + ")][Attribute oid] 0 < tama\u00f1o <= 50.");
        }
        if (StringUtils.isEmptyString((String)this.namePackage) || this.namePackage.length() > 250) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MOpendataPackage(" + this.namePackage + ")][Attribute name] 0 < tama\u00f1o <= 250.");
        }
        if (StringUtils.isEmptyString((String)this.contentOidPackage) || this.contentOidPackage.length() > 50) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MOpendataPackage(" + this.contentOidPackage + ")][Attribute contentOid] 0 < tama\u00f1o <= 50.");
        }
        if (this.storeData != null) {
            try {
                this.storeData.validateObject();
            }
            catch (R01MContentModelObjectsValidatorException e) {
                R01FLog.to((String)"r01m.contentAPI").warning("[Object R01MOpendataPackage(" + this.oid + ")][Attribute storeData] es incorrecto.");
            }
        } else {
            throw new R01MContentModelObjectsValidatorException("[Object R01MOpendataPackage(" + this.oid + ")][Attribute storeData] Contiene valores NULL.");
        }
    }

    public String getPackageLangName(String userLang) {
        if (!StringUtils.isEmptyString((String)userLang) && !StringUtils.isEmptyString((String)this.lang)) {
            try {
                Map<String, String> langsNames = R01MClientFactory.getMiscellaneousAPI().getLanguages(userLang);
                if (langsNames != null && !langsNames.isEmpty() && langsNames.containsKey(this.lang) && !StringUtils.isEmptyString((String)langsNames.get(this.lang).toString())) {
                    return langsNames.get(this.lang).toString();
                }
            }
            catch (R01MMiscDataLoadException e) {
                R01FLog.to((String)"r01n.messagedispatcher").severe("Error al intentar obtener la descripci\u00f3n del lenguaje '" + this.lang + "' filtro de la b\u00fasqueda" + e.getDetailedMessage());
            }
        }
        return "----";
    }

    public StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(500);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== Package  ========\r\n");
        sb.append(prefix);
        sb.append("\t oid: ");
        sb.append(this.getOid() == null ? "null" : this.getOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\t name: ");
        sb.append(this.getNamePackage() == null ? "null" : this.getNamePackage());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\t workareaRelativePath: ");
        sb.append(this.getWorkareaRelativePath() == null ? "null" : this.getWorkareaRelativePath());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\t periodicity: ");
        sb.append(this.getPeriodicityPackage() == null ? "null" : this.getPeriodicityPackage());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\t contentOid: ");
        sb.append(this.getContentOidPackage() == null ? "null" : this.getContentOidPackage());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("%%%%%%%%%%%%%%%%% FIN PACKAGE Oid: ");
        sb.append(this.getOid() == null ? "null" : this.getOid());
        sb.append(" %%%%%%%%%%%%%%%%%%%%%\r\n");
        return sb;
    }
}

