/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.link;

import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.contentmodel.R01MDocumentResume;
import com.ejie.r01m.objects.contentmodel.R01MSearchedDocuments;
import com.ejie.r01m.objects.link.R01MLinkResume;
import com.ejie.r01m.objects.publisher.R01MPublish;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentAdminAPI;
import com.ejie.r01m.services.R01MContentModelAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MConstantsReferencerConfig;
import com.ejie.r01m.utils.R01MPathHelpper;
import com.ejie.r01m.utils.searchengine.R01MSearchResultsFormatterConstants;
import com.ejie.r01m.utils.url.R01MPortalURL;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class R01MLinkItem
implements Serializable {
    private static final long serialVersionUID = -8372750939666367175L;
    private String text = "";
    private String url = "";
    private String title = "";
    private String classes = "";
    private String accesskey = "";
    private Map data = new HashMap();

    public R01MLinkItem() {
    }

    public R01MLinkItem(String theText, String theUrl, String theTitle, String theClasses, Map theData) {
        this(theText, theUrl, theTitle, theClasses, theData, "");
    }

    public R01MLinkItem(String theText, String theUrl, String theTitle, String theClasses, Map theData, String theAccessKey) {
        this.text = theText;
        this.url = theUrl;
        this.title = theTitle;
        this.classes = theClasses;
        this.data = theData;
        this.accesskey = theAccessKey;
    }

    public static R01MLinkItem buildFromDocument(String contentOid, String documentOid) {
        R01MContent dstContent;
        R01MDocument dstDocument;
        R01MLinkItem lnk = new R01MLinkItem();
        try {
            R01MContentModelAPI conf = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext());
            try {
                dstDocument = conf.loadDocument(documentOid);
            }
            catch (R01MContentModelException ex) {
                return lnk;
            }
            try {
                dstContent = conf.loadContent(contentOid);
            }
            catch (R01MContentModelException ex) {
                return lnk;
            }
        }
        catch (R01MSecurityException ex) {
            return lnk;
        }
        HashMap<String, String> linkData = new HashMap<String, String>();
        linkData.put("contentOid", dstContent.getOid());
        linkData.put("documentOid", dstDocument.getOid());
        linkData.put("contentName", dstContent.getName());
        linkData.put("documentName", dstDocument.getName());
        linkData.put("documentInternalName", dstDocument.getInternalName());
        linkData.put("contentTypology", dstContent.getTypo().getClusterOid() + ":" + dstContent.getTypo().getFamilyOid() + ":" + dstContent.getTypo().getTypeOid());
        String publicationTargetUrl = "";
        String publishRepositoryOid = "";
        String friendlyUrl = "";
        if (dstDocument.getPublicationInfo() != null && !dstDocument.getPublicationInfo().isEmpty() && dstDocument.getPublicationInfo().get(0).getState() == 1) {
            R01MDocumentPublicationTarget currInfo = dstDocument.getPublicationInfo().get(0);
            publicationTargetUrl = currInfo.getUrl();
            publishRepositoryOid = currInfo.getOid();
            friendlyUrl = currInfo.getMainAlias();
        } else {
            StringBuffer url = new StringBuffer();
            publishRepositoryOid = R01MPublish.DEFAULT_LOGICAL_PUBLICATION;
            if (dstDocument.getDocumentInitialDataFile() != null && !StringUtils.isEmptyString((String)dstDocument.getDocumentInitialDataFile().getTemplateOid())) {
                url.append(R01MConstants.CONTENT_ALIAS);
                url.append('/');
                url.append(dstContent.getTypo().getTypeOid());
                url.append('/');
                url.append(dstContent.getName());
                url.append('/');
                url.append(dstDocument.getLanguage());
                url.append('_');
                url.append(dstDocument.getInternalName());
                url.append('/');
                url.append(R01MPathHelpper.getDefaultGeneratedDataFileDocumentRelativePath(dstContent.getTypo(), dstContent.getStoreLocation(), dstContent.getOid(), dstContent.getInternalName(), dstContent.getName(), dstDocument.getOid(), dstDocument.getLanguage(), dstDocument.getInternalName(), dstDocument.getDocumentInitialDataFile().getOid(), dstDocument.getDocumentInitialDataFile().getName(), dstDocument.getDocumentInitialDataFile().getName(), dstDocument.getDocumentInitialDataFile().getTemplateOid()));
            } else {
                url.append('#');
            }
            publicationTargetUrl = url.toString();
        }
        if (!StringUtils.isEmptyString((String)friendlyUrl)) {
            if (!friendlyUrl.startsWith("/")) {
                friendlyUrl = "/" + friendlyUrl;
            }
            linkData.put("urlFriendly", friendlyUrl);
        }
        linkData.put("url", publicationTargetUrl);
        linkData.put("documentPublishRepository", publishRepositoryOid);
        lnk.setText(dstDocument.getName());
        if (!StringUtils.isEmptyString((String)friendlyUrl)) {
            lnk.setUrl(friendlyUrl);
        } else {
            lnk.setUrl(linkData.get("url").toString());
        }
        lnk.setData(linkData);
        return lnk;
    }

    public static R01MLinkItem buildFromURL(String url) {
        R01MLinkItem lnk = new R01MLinkItem();
        HashMap<String, String> linkData = new HashMap<String, String>();
        if (!StringUtils.isEmptyString((String)url)) {
            R01MPortalURL portalUrl = new R01MPortalURL(url);
            lnk.setUrl(url);
            linkData.put("url", url);
            switch (portalUrl.getURLType()) {
                case 13: {
                    lnk = R01MLinkItem._buildFromNewsLetterURL(url, portalUrl);
                    break;
                }
                case 2: {
                    lnk = R01MLinkItem._buildFromContentURL(url, portalUrl);
                    break;
                }
                case 21: {
                    lnk = R01MLinkItem._buildFromAttachmentURL(url, portalUrl);
                    break;
                }
                case 10: {
                    lnk = R01MLinkItem._buildFromContentURL(url, portalUrl);
                    break;
                }
                case 14: {
                    lnk = R01MLinkItem._buildFromSearchURL(url);
                    break;
                }
                case 0: {
                    lnk = R01MLinkItem._buildFromExternalURL(url);
                    break;
                }
                case 1: {
                    lnk = R01MLinkItem._buildFromPageURL(url, portalUrl);
                }
            }
        }
        return lnk;
    }

    public void loadFromJson(JSONObject jLink) throws JSONException {
        if (jLink != null) {
            if (jLink.has("text")) {
                this.text = jLink.getString("text");
            }
            if (jLink.has("url")) {
                this.url = jLink.getString("url");
            }
            if (jLink.has("title")) {
                this.title = jLink.getString("title");
            }
            if (jLink.has("classes")) {
                this.classes = jLink.getString("classes");
            }
            if (jLink.has("data")) {
                this.data = this._loadData(jLink.getJSONArray("data"));
            }
            if (jLink.has("accesskey")) {
                this.accesskey = jLink.getString("accesskey");
            }
        }
    }

    public JSONObject loadToJson() throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.put("text", (Object)this.text);
        jObject.put("url", (Object)this.url);
        jObject.put("title", (Object)this.title);
        jObject.put("classes", (Object)this.classes);
        jObject.put("accesskey", (Object)this.accesskey);
        jObject.put("data", (Object)this._loadDataToJson());
        return jObject;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String theText) {
        this.text = theText;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String theUrl) {
        this.url = theUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String theTitle) {
        this.title = theTitle;
    }

    public String getClasses() {
        return this.classes;
    }

    public void setClasses(String theClasses) {
        this.classes = theClasses;
    }

    public Map getData() {
        return this.data;
    }

    public void setData(Map theData) {
        this.data = theData;
    }

    public String getAccesskey() {
        return this.accesskey;
    }

    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    public String getContentOid() {
        if (this.getData() != null && this.getData().containsKey("contentOid")) {
            return this.getData().get("contentOid").toString();
        }
        return "";
    }

    public String getDocumentOid() {
        if (this.getData() != null && this.getData().containsKey("documentOid")) {
            return this.getData().get("documentOid").toString();
        }
        return "";
    }

    public String getDocumentRepositoryOid() {
        if (this.getData() != null && this.getData().containsKey(R01MSearchResultsFormatterConstants.DOCUMENT_PUBLISH_REPOSITORY)) {
            return this.getData().get(R01MSearchResultsFormatterConstants.DOCUMENT_PUBLISH_REPOSITORY).toString();
        }
        return "";
    }

    public String getHtml() {
        if (this.getData() != null && this.getData().containsKey("resourceHTML")) {
            return (String)this.getData().get(StringEscapeUtils.unescapeHtml((String)"resourceHTML").toString());
        }
        return "";
    }

    public String getAttachmentSize() {
        if (this.getData() != null && this.getData().containsKey("attachmentSize")) {
            String size = (String)this.getData().get("attachmentSize");
            String formattedSize = FileUtils.formatedFileLength((long)Long.parseLong(size));
            return formattedSize;
        }
        return "";
    }

    public String getNotFriendlyUrl() {
        if (this.getData() != null && this.getData().containsKey("url") && !StringUtils.isEmptyString((String)this.getData().get("url").toString())) {
            return this.getData().get("url").toString();
        }
        return this.getUrl();
    }

    public String getUrlPhysical() {
        return this.getNotFriendlyUrl();
    }

    public String getNewsLetterPart(int partKey) {
        String[] newsLetterUrl;
        String newsLetterPart = null;
        if (!StringUtils.isEmptyString((String)this.getUrl()) && this.getUrl().indexOf("/") != -1 && (newsLetterUrl = this.getUrl().split("/")).length >= partKey) {
            newsLetterPart = partKey == R01MConstantsReferencerConfig.NEWSLETTER_NUMBERCODE_KEY ? (newsLetterUrl[R01MConstantsReferencerConfig.NEWSLETTER_NUMBERCODE_KEY].indexOf("a") != -1 ? newsLetterUrl[5].substring(2, newsLetterUrl[R01MConstantsReferencerConfig.NEWSLETTER_NUMBERCODE_KEY].indexOf("a")) : newsLetterUrl[5].substring(2, newsLetterUrl[R01MConstantsReferencerConfig.NEWSLETTER_NUMBERCODE_KEY].indexOf("e"))) : (partKey == R01MConstantsReferencerConfig.NEWSLETTER_LANG_KEY ? (newsLetterUrl[R01MConstantsReferencerConfig.NEWSLETTER_NUMBERCODE_KEY].indexOf("a") != -1 ? "a" : "e") : newsLetterUrl[partKey]);
        }
        return newsLetterPart;
    }

    public R01MLinkResume toR01MLinkResume() {
        R01MLinkResume linkComposerResume = new R01MLinkResume();
        linkComposerResume.setText(this.getText());
        linkComposerResume.setUrl(this.getUrl());
        linkComposerResume.setTitle(this.getTitle());
        if (this.getData() != null && !this.getData().isEmpty()) {
            if (this.getData().containsKey("resourceHTML")) {
                linkComposerResume.setHtml(this.getData().get("resourceHTML").toString());
            }
            if (this.getData().containsKey("attachmentSize")) {
                linkComposerResume.getData().put("attachmentSize", this.getData().get("attachmentSize").toString());
            }
        }
        linkComposerResume.setData(this.getData());
        return linkComposerResume;
    }

    private JSONArray _loadDataToJson() throws JSONException {
        JSONArray jArray = new JSONArray();
        if (this.data != null && !this.data.isEmpty()) {
            for (Map.Entry ent : this.data.entrySet()) {
                JSONObject jObject = new JSONObject();
                jObject.put("key", ent.getKey());
                jObject.put("value", ent.getValue());
                jArray.put((Object)jObject);
            }
        }
        return jArray;
    }

    private Map _loadData(JSONArray jArray) throws JSONException {
        HashMap<String, String> m = new HashMap<String, String>();
        if (jArray != null && jArray.length() > 0) {
            for (int i = 0; i < jArray.length(); ++i) {
                JSONObject jObject = (JSONObject)jArray.get(i);
                try {
                    m.put(jObject.getString("key"), jObject.getString("value"));
                    continue;
                }
                catch (JSONException ex) {
                    m.put(jObject.getString("key"), "");
                }
            }
        }
        return m;
    }

    private static R01MLinkItem _buildFromNewsLetterURL(String url, R01MPortalURL portalUrl) {
        R01MLinkItem lnk = new R01MLinkItem();
        lnk.setUrl(url);
        HashMap<String, String> linkData = new HashMap<String, String>();
        String lang = "e";
        Pattern p = Pattern.compile(XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"urlPatterns/bopv1Url", (String)"^(?:(http)://)?(?:([^/]+))?/cgi-bin_k54/bopv_20\\?([a-zA-Z])&[a-zA-Z]=([0-9]{4})([0-9]{2})([0-9]{2})&[a-zA-Z]=([0-9]+)$"));
        Matcher m = p.matcher(url);
        if (m.matches()) {
            if (m.group(3).equalsIgnoreCase("c")) {
                lang = "a";
            }
        } else {
            lang = R01MLinkItem.getBopvLang(url);
        }
        linkData.put("newsLetterLang", lang);
        linkData.put("url", url);
        lnk.setText(url);
        lnk.setUrl(url);
        lnk.setData(linkData);
        return lnk;
    }

    private static R01MLinkItem _buildFromContentURL(String url, R01MPortalURL portalUrl) {
        R01MLinkItem lnk = new R01MLinkItem();
        HashMap<String, String> linkData = new HashMap<String, String>();
        lnk.setUrl(url);
        try {
            R01MContentModelAPI conf = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext());
            R01MContentAdminAPI admin = R01MClientFactory.getContentAdminAPI(R01MAuthManager.createMasterSystemUserContext());
            try {
                R01MContent dstContent;
                String contentOid = conf.getContentOidFromContentTypeAndName(portalUrl.getURLPart("contentType"), portalUrl.getURLPart("contentName"));
                if (!conf.checkContentExistence(contentOid)) {
                    return lnk;
                }
                try {
                    dstContent = conf.loadContent(contentOid);
                }
                catch (R01MContentModelException ex) {
                    return lnk;
                }
                R01MSearchedDocuments srchDocsCriteria = new R01MSearchedDocuments();
                srchDocsCriteria.setContentOid(contentOid);
                srchDocsCriteria.setInternalName(portalUrl.getURLPart("documentInternalName"));
                srchDocsCriteria.setLanguage(portalUrl.getURLPart("documentLang"));
                linkData.put("contentOid", contentOid);
                linkData.put("url", url);
                linkData.put("contentName", dstContent.getName());
                linkData.put("contentTypology", dstContent.getTypo().getClusterOid() + ":" + dstContent.getTypo().getFamilyOid() + ":" + dstContent.getTypo().getTypeOid());
                List searchedDocuments = admin.searchDocuments(srchDocsCriteria);
                if (searchedDocuments != null && !searchedDocuments.isEmpty()) {
                    R01MDocument dstDocument = searchedDocuments.get(0) instanceof R01MDocumentResume ? conf.loadDocument(((R01MDocumentResume)admin.searchDocuments(srchDocsCriteria).get(0)).getOid()) : (R01MDocument)admin.searchDocuments(srchDocsCriteria).get(0);
                    linkData.put("documentOid", dstDocument.getOid());
                    linkData.put("documentName", dstDocument.getName());
                    linkData.put("documentInternalName", dstDocument.getInternalName());
                    String publishRepositoryOid = R01MPublish.DEFAULT_LOGICAL_PUBLICATION;
                    if (dstDocument.getPublicationInfo() != null && !dstDocument.getPublicationInfo().isEmpty()) {
                        publishRepositoryOid = dstDocument.getPublicationInfo().get(0).getPublicationOid();
                    }
                    linkData.put("documentPublishRepository", publishRepositoryOid);
                    lnk.setText(dstDocument.getName());
                }
                lnk.setData(linkData);
            }
            catch (R01MContentModelException ex) {
                return lnk;
            }
        }
        catch (R01MSecurityException ex) {
            return lnk;
        }
        return lnk;
    }

    private static R01MLinkItem _buildFromAttachmentURL(String url, R01MPortalURL portalUrl) {
        R01MLinkItem lnk = R01MLinkItem._buildFromContentURL(url, portalUrl);
        lnk.getData().put("attachmentName", portalUrl.getURLPart("documentFile"));
        lnk.setText(portalUrl.getURLPart("documentFile"));
        return lnk;
    }

    private static R01MLinkItem _buildFromSearchURL(String url) {
        R01MLinkItem lnk = new R01MLinkItem();
        HashMap<String, String> linkData = new HashMap<String, String>();
        lnk.setUrl(url);
        lnk.setText(url);
        linkData.put("url", url);
        lnk.setData(linkData);
        return lnk;
    }

    private static R01MLinkItem _buildFromExternalURL(String url) {
        R01MLinkItem lnk = new R01MLinkItem();
        HashMap<String, String> linkData = new HashMap<String, String>();
        linkData.put("url", url);
        lnk.setUrl(url);
        lnk.setText(url);
        lnk.setData(linkData);
        return lnk;
    }

    private static R01MLinkItem _buildFromPageURL(String url, R01MPortalURL portalUrl) {
        R01MLinkItem lnk = new R01MLinkItem();
        HashMap<String, String> linkData = new HashMap<String, String>();
        linkData.put("url", url);
        linkData.put("pageName", portalUrl.getPageCode());
        lnk.setUrl(url);
        lnk.setText(url);
        lnk.setData(linkData);
        return lnk;
    }

    private static String getBopvLang(String url) {
        String newsLetterPart = "a";
        if (!StringUtils.isEmptyString((String)url)) {
            R01MPortalURL bopvUrl = new R01MPortalURL(url);
            bopvUrl.getURLPart("bopvDisp");
            Pattern p = Pattern.compile(XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"urlPatterns/bopv2UrlDisp", (String)"^.*([a|e]{1})[.].*$"));
            Matcher m = p.matcher(url);
            if (m.matches()) {
                newsLetterPart = m.group(1);
            }
        }
        return newsLetterPart;
    }
}

