/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.link;

import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.datastore.R01MDataStoreItem;
import com.ejie.r01m.objects.link.R01MLinkItem;
import com.ejie.r01m.objects.link.R01MPresentationPage;
import com.ejie.r01m.objects.link.R01MWindowAppearance;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentModelAPI;
import com.ejie.r01m.utils.link.R01MLinkUtils;
import com.ejie.r01m.utils.url.R01MPortalURL;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class R01MLink
implements Serializable {
    private static final long serialVersionUID = 8811427185477634939L;
    private int type = -1;
    private List<R01MLinkItem> linkItems = new ArrayList<R01MLinkItem>();
    private R01MWindowAppearance windowAppearance = new R01MWindowAppearance();
    private R01MPresentationPage presentationPage = new R01MPresentationPage();
    private Map data = new HashMap();
    private Map js = new HashMap();
    private boolean urlFriendly = true;
    private boolean samePage = true;

    public R01MLink() {
    }

    public R01MLink(int theType, List<R01MLinkItem> theLinkItems, R01MWindowAppearance theWindowAppareance, R01MPresentationPage thePresentationPage, Map theData, Map theJs, boolean theUrlFriendly) {
        this(theType, theLinkItems, theWindowAppareance, thePresentationPage, theData, theJs, theUrlFriendly, true);
    }

    public R01MLink(int theType, List<R01MLinkItem> theLinkItems, R01MWindowAppearance theWindowAppareance, R01MPresentationPage thePresentationPage, Map theData, Map theJs, boolean theUrlFriendly, boolean theSamePage) {
        this.type = theType;
        this.linkItems = theLinkItems;
        this.windowAppearance = theWindowAppareance;
        this.presentationPage = thePresentationPage;
        this.data = theData;
        this.js = theJs;
        this.urlFriendly = theUrlFriendly;
        this.samePage = theSamePage;
    }

    public void loadFromJson(JSONObject jsonLinkComposer) throws JSONException {
        if (jsonLinkComposer != null) {
            JSONArray jLinks;
            this.type = jsonLinkComposer.has("type") ? jsonLinkComposer.getInt("type") : 0;
            if (jsonLinkComposer.has("links") && (jLinks = (JSONArray)jsonLinkComposer.get("links")) != null && jLinks.length() > 0) {
                for (int i = 0; i < jLinks.length(); ++i) {
                    R01MLinkItem link = new R01MLinkItem();
                    link.loadFromJson((JSONObject)jLinks.get(i));
                    this.linkItems.add(link);
                }
            }
            this.windowAppearance = new R01MWindowAppearance();
            if (jsonLinkComposer.has("windowAppearance")) {
                this.windowAppearance.loadFromJson((JSONObject)jsonLinkComposer.get("windowAppearance"));
            }
            this.presentationPage = new R01MPresentationPage();
            if (jsonLinkComposer.has("presentationPage")) {
                this.presentationPage.loadFromJson((JSONObject)jsonLinkComposer.get("presentationPage"));
            }
            if (jsonLinkComposer.has("data")) {
                this.data = this._loadData(jsonLinkComposer.getJSONArray("data"));
            }
            this.js = this._loadJs(jsonLinkComposer);
            if (jsonLinkComposer.has("urlFriendly")) {
                this.urlFriendly = jsonLinkComposer.getBoolean("urlFriendly");
            }
            if (jsonLinkComposer.has("samePage")) {
                this.samePage = jsonLinkComposer.getBoolean("samePage");
            }
        }
    }

    public void loadFromJson(String jsonLinkComposer) throws JSONException {
        try {
            this.loadFromJson(new JSONObject(jsonLinkComposer));
        }
        catch (JSONException ex) {
            this.loadFromJson(new JSONObject());
        }
    }

    public JSONObject loadToJson() throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.put("type", this.type);
        JSONArray jLinks = new JSONArray();
        if (this.linkItems != null && !this.linkItems.isEmpty()) {
            for (int i = 0; i < this.linkItems.size(); ++i) {
                jLinks.put((Object)this.linkItems.get(i).loadToJson());
            }
            jObject.put("links", (Object)jLinks);
        }
        jObject.put("windowAppearance", (Object)this.windowAppearance.loadToJson());
        jObject.put("presentationPage", (Object)this.presentationPage.loadToJson());
        jObject.put("js", (Object)this._loadJsToJson());
        jObject.put("data", (Object)this._loadDataToJson());
        jObject.put("urlFriendly", this.urlFriendly);
        jObject.put("samePage", this.samePage);
        return jObject;
    }

    public void addLinkItemDocument(String contentOid, String documentOid) {
        this._addLinkItem(R01MLinkItem.buildFromDocument(contentOid, documentOid));
    }

    public void addLinkItemFromURL(String url) {
        if (!StringUtils.isEmptyString((String)url)) {
            R01MPortalURL portalUrl = new R01MPortalURL(url);
            switch (portalUrl.getURLType()) {
                case 13: {
                    this.setType(5);
                    break;
                }
                case 2: {
                    this.setType(2);
                    break;
                }
                case 21: {
                    this.setType(6);
                    break;
                }
                case 10: {
                    this.setType(2);
                    break;
                }
                case 14: {
                    this.setType(3);
                    break;
                }
                case 0: {
                    this.setType(8);
                    break;
                }
                case 1: {
                    this.setType(1);
                    break;
                }
                default: {
                    this.setType(7);
                }
            }
        }
        this._addLinkItem(R01MLinkItem.buildFromURL(url));
    }

    public void loadAttachment(R01MDataStoreItem item, String documentOid) {
        this.type = 6;
        this.setPresentationPage(new R01MPresentationPage());
        try {
            String[] splitFileNameAndExtension;
            String sizeAndExtensionInfo;
            R01MContentModelAPI contentModelApi = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext());
            R01MDocument doc = contentModelApi.loadDocument(documentOid);
            String contentOid = contentModelApi.getDocumentParentContent(documentOid);
            R01MContent content = contentModelApi.loadContent(contentOid);
            String contentAlias = "contenidos";
            this.getFirstLinkItem().setUrl("/" + contentAlias + "/" + item.getWorkAreaRelativePath());
            if (StringUtils.isEmptyString((String)this.getFirstLinkItem().getText()) || this.getFirstLinkItem().getText().equals(this.getFirstLinkItem().getData().get("attachmentName"))) {
                this.getFirstLinkItem().setText(item.getItemName());
            }
            String extension = sizeAndExtensionInfo = (splitFileNameAndExtension = FileUtils.splitFileNameAndExtension((String)item.getItemName())) != null && splitFileNameAndExtension.length == 2 && !StringUtils.isEmptyString((String)splitFileNameAndExtension[1]) ? splitFileNameAndExtension[1].toUpperCase() : "";
            boolean includeSizeAndExtensionInfo = true;
            if (!StringUtils.isEmptyString((String)extension)) {
                includeSizeAndExtensionInfo = !extension.equalsIgnoreCase("html") && !extension.equalsIgnoreCase("shtml") && !extension.equalsIgnoreCase("xml");
            }
            String sizeTxt = "";
            if (!StringUtils.isEmptyString((String)sizeAndExtensionInfo) && item.getItemSize() != 0L) {
                sizeTxt = ", ";
            }
            sizeTxt = sizeTxt + FileUtils.formatedFileLength((long)item.getItemSize());
            if (!StringUtils.isEmptyString((String)(sizeAndExtensionInfo = sizeAndExtensionInfo + sizeTxt))) {
                sizeAndExtensionInfo = "(" + sizeAndExtensionInfo + ")";
            }
            HashMap<String, String> newData = new HashMap<String, String>();
            newData.put("contentOid", content.getOid());
            newData.put("documentOid", doc.getOid());
            newData.put("documentName", doc.getName());
            newData.put("contentName", content.getName());
            newData.put("attachmentName", item.getItemName());
            newData.put("resourceHTML", StringEscapeUtils.escapeHtml((String)R01MLinkUtils.composeAttachmentHTML(this)));
            newData.put("attachmentSizeAndExtension", sizeAndExtensionInfo);
            String strIncludeSizeAndExtensionInfo = includeSizeAndExtensionInfo ? "1" : "0";
            newData.put("useAttachmentSizeAndExtension", strIncludeSizeAndExtensionInfo);
            this.getFirstLinkItem().setData(newData);
        }
        catch (R01MSecurityException e) {
            System.out.println(e.getDetailedMessage());
        }
        catch (R01MContentModelException e) {
            System.out.println(e.getDetailedMessage());
        }
    }

    public void loadAttachment(R01MDataStoreItem item, String contentOid, String documentOid) {
        this.type = 6;
        this.setPresentationPage(new R01MPresentationPage());
        try {
            String sizeAndExtensionInfo;
            R01MContentModelAPI contentModelApi = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext());
            R01MDocument doc = null;
            R01MContent content = null;
            if (!StringUtils.isEmptyString((String)documentOid)) {
                doc = contentModelApi.loadDocument(documentOid);
            }
            if (!StringUtils.isEmptyString((String)contentOid)) {
                content = contentModelApi.loadContent(contentOid);
            }
            String contentAlias = "contenidos";
            this.getFirstLinkItem().setUrl("/" + contentAlias + "/" + item.getWorkAreaRelativePath());
            if (StringUtils.isEmptyString((String)this.getFirstLinkItem().getText()) || this.getFirstLinkItem().getText().equals(this.getFirstLinkItem().getData().get("attachmentName"))) {
                this.getFirstLinkItem().setText(item.getItemName());
            }
            HashMap<String, String> newData = new HashMap<String, String>();
            if (content != null) {
                newData.put("contentOid", content.getOid());
                newData.put("contentName", content.getName());
            }
            if (doc != null) {
                newData.put("documentOid", doc.getOid());
                newData.put("documentName", doc.getName());
            } else {
                newData.put("documentOid", "");
                newData.put("documentName", "");
            }
            newData.put("attachmentName", item.getItemName());
            newData.put("resourceHTML", StringEscapeUtils.escapeHtml((String)R01MLinkUtils.composeAttachmentHTML(this)));
            newData.put("attachmentSize", item.getItemSize() + "");
            String[] splitFileNameAndExtension = FileUtils.splitFileNameAndExtension((String)item.getItemName());
            String extension = sizeAndExtensionInfo = splitFileNameAndExtension != null && splitFileNameAndExtension.length == 2 && !StringUtils.isEmptyString((String)splitFileNameAndExtension[1]) ? splitFileNameAndExtension[1].toUpperCase() : "";
            boolean includeSizeAndExtensionInfo = true;
            if (!StringUtils.isEmptyString((String)extension)) {
                includeSizeAndExtensionInfo = !extension.equalsIgnoreCase("html") && !extension.equalsIgnoreCase("shtml") && !extension.equalsIgnoreCase("xml");
            }
            String sizeTxt = "";
            if (!StringUtils.isEmptyString((String)sizeAndExtensionInfo) && item.getItemSize() != 0L) {
                sizeTxt = ", ";
            }
            sizeTxt = sizeTxt + FileUtils.formatedFileLength((long)item.getItemSize());
            if (!StringUtils.isEmptyString((String)(sizeAndExtensionInfo = sizeAndExtensionInfo + sizeTxt))) {
                sizeAndExtensionInfo = "(" + sizeAndExtensionInfo + ")";
            }
            newData.put("attachmentSizeAndExtension", sizeAndExtensionInfo);
            String strIncludeSizeAndExtensionInfo = includeSizeAndExtensionInfo ? "1" : "0";
            newData.put("useAttachmentSizeAndExtension", strIncludeSizeAndExtensionInfo);
            this.getFirstLinkItem().setData(newData);
        }
        catch (R01MSecurityException e) {
            System.out.println(e.getDetailedMessage());
        }
        catch (R01MContentModelException e) {
            System.out.println(e.getDetailedMessage());
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int theType) {
        this.type = theType;
    }

    public Map getData() {
        return this.data;
    }

    public void setData(Map theData) {
        this.data = theData;
    }

    public boolean isNullOrEmptyData() {
        return this.data == null || this.data.isEmpty();
    }

    public R01MWindowAppearance getWindowAppareance() {
        return this.windowAppearance;
    }

    public void setWindowAppareance(R01MWindowAppearance theWindowAppearance) {
        this.windowAppearance = theWindowAppearance;
    }

    public R01MPresentationPage getPresentationPage() {
        return this.presentationPage;
    }

    public void setPresentationPage(R01MPresentationPage thePresentationPage) {
        this.presentationPage = thePresentationPage;
    }

    public void setJs(Map theJs) {
        this.js = theJs;
    }

    public Map getJs() {
        return this.js;
    }

    public boolean isUrlFriendly() {
        return this.urlFriendly;
    }

    public void setUrlFriendly(boolean theUrlFriendly) {
        this.urlFriendly = theUrlFriendly;
    }

    public void setSamePage(boolean samePage) {
        this.samePage = samePage;
    }

    public boolean isSamePage() {
        return this.samePage;
    }

    public List<R01MLinkItem> getLinkItems() {
        return this.linkItems;
    }

    public void setLinks(List<R01MLinkItem> theLinks) {
        this.linkItems = theLinks;
    }

    public R01MLinkItem getFirstLinkItem() {
        if (this.linkItems.isEmpty()) {
            this.linkItems.add(new R01MLinkItem());
        }
        return this.linkItems.get(0);
    }

    public String getUrlPhysical() {
        if (this.type == 2 || this.type == 6 || this.type == 3) {
            return this.getFirstLinkItem().getUrlPhysical();
        }
        return "";
    }

    public String getUrlPhysicalWithPage() {
        String url = this.getFirstLinkItem().getUrlPhysical();
        if (this.type != 1 && this.getPresentationPage() != null && !StringUtils.isEmptyString((String)this.getPresentationPage().getPortal()) && !StringUtils.isEmptyString((String)this.getPresentationPage().getPageInternalName())) {
            url = "/" + this.getPresentationPage().getPortal() + "-" + this.getPresentationPage().getPageInternalName() + "/" + this.getPresentationPage().getLang() + url;
        }
        return url;
    }

    public String getUrl() {
        return this.getFirstLinkItem().getUrl();
    }

    public String getText() {
        return this.getFirstLinkItem().getText();
    }

    public String getTitle() {
        return this.getFirstLinkItem().getTitle();
    }

    public String getContentOid() {
        return this.getFirstLinkItem().getContentOid();
    }

    public String getDocumentOid() {
        return this.getFirstLinkItem().getDocumentOid();
    }

    public String getDocumentRepositoryOid() {
        return this.getFirstLinkItem().getDocumentRepositoryOid();
    }

    public String getHtml() {
        return this.getFirstLinkItem().getHtml();
    }

    public String getAttachmentSize() {
        return this.getFirstLinkItem().getAttachmentSize();
    }

    public String getNotFriendlyUrl() {
        return this.getFirstLinkNotFriendlyUrl();
    }

    public String getFirstLinkNotFriendlyUrl() {
        if (this.type == 2 || this.type == 3) {
            String page = "";
            if (this.getPresentationPage() != null) {
                page = this.getPresentationPage().getPortal() + "-" + this.getPresentationPage().getPageInternalName() + "/" + this.getPresentationPage().getLang();
                page = this.type == 2 ? page + "/" : page + "?";
            }
            return page + this.getFirstLinkItem().getNotFriendlyUrl();
        }
        return this.getFirstLinkItem().getUrl();
    }

    public String getNewsLetterPart(int partKey) {
        String newsLetterPart = null;
        if (this.type == 5) {
            newsLetterPart = this.getFirstLinkItem().getNewsLetterPart(partKey);
        }
        return newsLetterPart;
    }

    public Map getFirstLinkData() {
        return this.getFirstLinkItem().getData();
    }

    public boolean isNullOrEmptyFirstLinkData() {
        return this.isNullOrEmptyLinkData(0);
    }

    public R01MLinkItem getLink(int pos) {
        if (!this.linkItems.isEmpty()) {
            return this.linkItems.get(pos);
        }
        return null;
    }

    public boolean isNullOrEmptyLinkData(int pos) {
        return this.getLinkItems() == null || this.getLinkItems().get(pos) == null || this.getLinkItems().get(pos).getData() == null || this.getLinkItems().get(pos).getData().isEmpty();
    }

    public Map getLinkData(int pos) {
        if (!this.isNullOrEmptyLinkData(pos)) {
            return this.getLinkItems().get(pos).getData();
        }
        return null;
    }

    public String getHtml(int pos) {
        if (!this.isNullOrEmptyFirstLinkData() && this.getLinkItems().get(pos).getData().containsKey("resourceHTML")) {
            return (String)this.getLinkItems().get(pos).getData().get(StringEscapeUtils.unescapeHtml((String)"resourceHTML").toString());
        }
        return "";
    }

    public String getNotFriendlyUrl(int pos) {
        if (this.type == 4) {
            String page = "";
            if (this.getPresentationPage() != null) {
                page = this.getPresentationPage().getPortal() + "-" + this.getPresentationPage().getPageInternalName() + "/" + this.getPresentationPage().getLang();
            }
            if (this.getLink(pos).getData().containsKey("url") && this.getLink(pos).getData().get("url") != null) {
                return page + "/" + this.getLink(pos).getData().get("url").toString();
            }
        }
        return this.getFirstLinkNotFriendlyUrl();
    }

    public String getQuery() {
        return this.getQueryUsedToBuildLinkUrl();
    }

    public String getQueryXml() {
        return this.getQueryUsedToBuildLinkXml();
    }

    public String getQueryDescription() {
        return this.getQueryUsedToBuildLinkDescription();
    }

    public String getLinkDescription() {
        return this.getUserUnderstableDescription();
    }

    public String getQueryUsedToBuildLinkUrl() {
        if (!this.isNullOrEmptyData() && this.data.containsKey("query")) {
            return this.data.get("query").toString();
        }
        return null;
    }

    public String getQueryUsedToBuildLinkXml() {
        if (!this.isNullOrEmptyData() && this.data.containsKey("queryXml")) {
            return this.data.get("queryXml").toString();
        }
        return null;
    }

    public String getQueryUsedToBuildLinkDescription() {
        if (!this.isNullOrEmptyData() && this.data.containsKey("queryDescription")) {
            return this.data.get(StringEscapeUtils.escapeHtml((String)"queryDescription").toString()).toString();
        }
        return null;
    }

    public String getUserUnderstableDescription() {
        if (!this.isNullOrEmptyData() && this.data.containsKey("linkDescription")) {
            return this.data.get("linkDescription").toString();
        }
        return null;
    }

    private Map _loadJs(JSONObject jsonLinkComposer) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (jsonLinkComposer.has("js")) {
            try {
                JSONArray jArray = jsonLinkComposer.getJSONArray("js");
                if (jArray != null && jArray.length() > 0) {
                    for (int i = 0; i < jArray.length(); ++i) {
                        JSONObject jObject = (JSONObject)jArray.get(i);
                        String[] names = JSONObject.getNames((JSONObject)jObject);
                        if (names == null || names.length <= 0) continue;
                        for (int n = 0; n < names.length; ++n) {
                            String key = names[n];
                            m.put(key, jObject.getString(key));
                        }
                    }
                }
            }
            catch (JSONException ex) {
                ex.printStackTrace();
            }
        }
        return m;
    }

    private Map _loadData(JSONArray jArray) throws JSONException {
        HashMap<String, String> m = new HashMap<String, String>();
        if (jArray != null && jArray.length() > 0) {
            for (int i = 0; i < jArray.length(); ++i) {
                JSONObject jObject = (JSONObject)jArray.get(i);
                if (jObject.getString("key").equals("queryXml")) {
                    m.put(jObject.getString("key"), StringEscapeUtils.unescapeXml((String)jObject.getString("value")));
                    continue;
                }
                m.put(jObject.getString("key"), jObject.getString("value"));
            }
        }
        return m;
    }

    private JSONArray _loadJsToJson() {
        JSONArray jArray = new JSONArray();
        if (this.js != null && !this.js.isEmpty()) {
            jArray.put(this.js);
        }
        return jArray;
    }

    private JSONArray _loadDataToJson() throws JSONException {
        JSONArray jArray = new JSONArray();
        if (this.data != null && !this.data.isEmpty()) {
            for (Map.Entry ent : this.data.entrySet()) {
                JSONObject jObject = new JSONObject();
                jObject.put("key", ent.getKey());
                jObject.put("value", ent.getValue());
                jArray.put((Object)jObject);
            }
        }
        return jArray;
    }

    private void _addLinkItem(R01MLinkItem link) {
        R01MPortalURL portalUrl;
        this.getLinkItems().add(link);
        R01MLinkUtils.composeHtmlLinks(this);
        if (!(StringUtils.isEmptyString((String)link.getUrl()) || StringUtils.isEmptyString((String)(portalUrl = new R01MPortalURL(link.getUrl())).getPortalCode()) || StringUtils.isEmptyString((String)portalUrl.getPageCode()) || StringUtils.isEmptyString((String)portalUrl.getPortalLang()))) {
            this.setPresentationPage(new R01MPresentationPage(portalUrl.getPortalCode(), portalUrl.getPageCode(), portalUrl.getPageCode(), portalUrl.getPortalLang()));
        }
    }
}

