/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.formComposer;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.config.objects.typology.R01MContentCluster;
import com.ejie.r01m.config.objects.typology.R01MContentFamily;
import com.ejie.r01m.config.objects.typology.R01MContentType;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.services.R01MClientFactory;
import java.io.Serializable;

public abstract class R01MFormComposerQueryParser
implements Serializable {
    private static final long serialVersionUID = 439442601565476563L;

    public static R01MQueryObject parseQueryStringToQueryObject(String theQueryString) {
        R01MQueryObject queryObj = new R01MQueryObject();
        String[] criteria = theQueryString.split("\\$\\$");
        for (int c = 0; c < criteria.length; ++c) {
            String queryStringPart = criteria[c];
            String queryStringPartCore = queryStringPart.substring(queryStringPart.indexOf("(") + 1, queryStringPart.length() - 1);
            String[] corePart = queryStringPartCore.split("#");
            if (corePart.length == 0) continue;
            if (corePart.length == 3 && queryStringPart.startsWith("ty")) {
                if (!corePart[0].equals("0") && NumberUtils.isInteger((String)corePart[0])) {
                    try {
                        R01MContentCluster cluster = R01MClientFactory.getTypologyConfigAPI().getClusterConfigFromNumericId(Integer.parseInt(corePart[0]));
                        if (cluster != null) {
                            queryObj.addContentCluster(cluster.getOid());
                        } else {
                            R01FLog.to((String)"r01m.miscAPI").warning("Error al obtener la configuraci\u00f3n del cluster de numericId " + Integer.parseInt(corePart[0]));
                        }
                    }
                    catch (R01MConfigLoadException ex) {
                        ex.printStackTrace(System.out);
                    }
                }
                if (!corePart[1].equals("0") && NumberUtils.isInteger((String)corePart[1])) {
                    try {
                        R01MContentFamily family = R01MClientFactory.getTypologyConfigAPI().getFamilyConfigFromNumericId(Integer.parseInt(corePart[1]));
                        if (family != null) {
                            queryObj.addContentFamily(family.getOid());
                        } else {
                            R01FLog.to((String)"r01m.miscAPI").warning("Error al obtener la configuraci\u00f3n de la  familia de numericId " + Integer.parseInt(corePart[1]));
                        }
                    }
                    catch (R01MConfigLoadException ex) {
                        ex.printStackTrace(System.out);
                    }
                }
                if (corePart[2].equals("0") || !NumberUtils.isInteger((String)corePart[2])) continue;
                try {
                    R01MContentType type = R01MClientFactory.getTypologyConfigAPI().getTypeConfigFromNumericId(Integer.parseInt(corePart[2]));
                    if (type != null) {
                        queryObj.addContentType(type.getOid());
                        continue;
                    }
                    R01FLog.to((String)"r01m.miscAPI").warning("Error al obtener la configuraci\u00f3n del tipo de numericId " + Integer.parseInt(corePart[2]));
                }
                catch (R01MConfigLoadException ex) {
                    ex.printStackTrace(System.out);
                }
                continue;
            }
            if (corePart.length == 3 && queryStringPart.startsWith("md")) {
                queryObj.addMetaData(corePart[0], corePart[1], corePart[2]);
                continue;
            }
            if (queryStringPart.startsWith("ax")) {
                for (int i = 0; i < corePart.length; ++i) {
                    String[] corePartSplitted = corePart[i].split(",");
                    if (corePartSplitted.length != 2) continue;
                    queryObj.addANDStructureCatalog(corePartSplitted[1]);
                }
                continue;
            }
            if (queryStringPart.startsWith("pr")) {
                for (int i = 0; i < corePart.length; ++i) {
                    queryObj.addPublishRepository(corePart[i]);
                }
                continue;
            }
            if (!queryStringPart.startsWith("st") || corePart.length <= 0) continue;
            if (!corePart[0].equals("0")) {
                queryObj.addServer(corePart[0]);
            }
            if (corePart.length <= 1) continue;
            if (!corePart[1].equals("0")) {
                queryObj.addDataRepository(corePart[0], corePart[1]);
            }
            if (corePart.length <= 2) continue;
            if (!corePart[2].equals("0")) {
                queryObj.addArea(corePart[0], corePart[1], corePart[2]);
            }
            if (corePart.length <= 3 || corePart[3].equals("0")) continue;
            queryObj.addWorkArea(corePart[0], corePart[1], corePart[2], corePart[3]);
        }
        return queryObj;
    }

    public static void main(String[] args) {
        String queryString = "st(serverOid#dataRepositoryOid#area#workarea)$$ty(clusteOid1#familyOid1#typeOid1)$$ty(clusteOid2#familyOid2#typeOid2)$$ty(clusteOid3#familyOid3#typeOid3)$$md(metadDataOid1#operationId1#metaDatavalue1)$$md(metadDataOid2#operationId2#metaDatavalue2)$$md(metadDataOid3#operationId3#metaDatavalue3)$$ax(nodeId1#nodeId2#nodeId3)$$pr(publishRepositoryOid1#publishRepositoryOid2)";
        R01MQueryObject queryObj = R01MFormComposerQueryParser.parseQueryStringToQueryObject(queryString);
        try {
            String queryXmlStr = XOManager.getXML((String)"D:/tools/workspaces/r01/r01mClasses/html/datos/r01mQueryObjectMapping.xml", (Object)queryObj);
            R01FLog.to((String)"r01m.test").info(queryXmlStr);
        }
        catch (XOMarshallerException ex) {
            R01FLog.to((String)"r01m.test").info(ex.getMessage());
            ex.printStackTrace(System.out);
        }
    }
}

