/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.datastore;

import java.io.Serializable;
import java.util.Date;

public class R01MDataStoreItem
implements Serializable {
    private static final long serialVersionUID = 9133298058743844981L;
    public static final int ITEM_SIMPLEFILE = 0;
    public static final int ITEM_DIR = 1;
    public static final int ITEM_LINK = 2;
    public static final int ITEM_HOLE = 3;
    private String locationBasePath;
    private String workAreaRelativePath;
    private String itemName;
    private Date itemModifiedDate;
    private int itemType;
    private long itemSize = 0L;
    private boolean readOnly = false;

    public R01MDataStoreItem() {
    }

    public R01MDataStoreItem(String newLocationBasePath, String newWorkAreaRelativePath, String newItemName, int newItemType) {
        this(newLocationBasePath, newWorkAreaRelativePath, newItemName, newItemType, 0L);
    }

    public R01MDataStoreItem(String newLocationBasePath, String newWorkAreaRelativePath, String newItemName, int newItemType, long newItemSize) {
        this();
        this.locationBasePath = newLocationBasePath;
        this.workAreaRelativePath = newWorkAreaRelativePath;
        this.itemName = newItemName;
        this.itemType = newItemType;
        this.itemSize = newItemSize;
    }

    public R01MDataStoreItem(String newLocationBasePath, String newWorkAreaRelativePath, String newItemName, int newItemType, long newItemSize, long newItemModifiedDate) {
        this.locationBasePath = newLocationBasePath;
        this.workAreaRelativePath = newWorkAreaRelativePath;
        this.itemName = newItemName;
        this.itemType = newItemType;
        this.itemSize = newItemSize;
        this.itemModifiedDate = this.longToDate(newItemModifiedDate);
    }

    public R01MDataStoreItem(String newLocationBasePath, String newWorkAreaRelativePath, String newItemName, int newItemType, long newItemSize, Date newItemModifiedDate) {
        this.locationBasePath = newLocationBasePath;
        this.workAreaRelativePath = newWorkAreaRelativePath;
        this.itemName = newItemName;
        this.itemType = newItemType;
        this.itemSize = newItemSize;
        this.itemModifiedDate = newItemModifiedDate;
    }

    public String composeDebugInfo() {
        return this.getItemType() + " - " + this.getAbsolutePath();
    }

    public int getItemType() {
        return this.itemType;
    }

    public void setItemType(int theItemType) {
        this.itemType = theItemType;
    }

    public String getAbsolutePath() {
        return this.locationBasePath + this.workAreaRelativePath;
    }

    public String getLocationBasePath() {
        return this.locationBasePath;
    }

    public void setLocationBasePath(String theLocationBasePath) {
        this.locationBasePath = theLocationBasePath;
    }

    public String getWorkAreaRelativePath() {
        return this.workAreaRelativePath;
    }

    public void setWorkAreaRelativePath(String theWorkAreaRelativePath) {
        this.workAreaRelativePath = theWorkAreaRelativePath;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String theitemName) {
        this.itemName = theitemName;
    }

    public long getItemSize() {
        return this.itemSize;
    }

    public void setItemSize(long theItemSize) {
        this.itemSize = theItemSize;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bReadOnly) {
        this.readOnly = bReadOnly;
    }

    public Date getItemModifiedDate() {
        return this.itemModifiedDate;
    }

    public void setItemModifiedDate(Date theItemModifiedDate) {
        this.itemModifiedDate = theItemModifiedDate;
    }

    private Date longToDate(long newItemModifiedDate) {
        if (0L < newItemModifiedDate) {
            return new Date(newItemModifiedDate);
        }
        return null;
    }
}

