/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.contentmodel;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MURLAlias;
import com.ejie.r01m.objects.contentmodel.R01MBaseContentModelObject;
import com.ejie.r01m.objects.contentmodel.R01MBaseDocumentInterface;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationRequested;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.contentmodel.R01MDocumentRevisionState;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MPublicationsUtils;
import com.ejie.r01m.utils.R01MUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.utils.StringUtils;

public class R01MDocument
extends R01MBaseContentModelObject
implements R01MBaseDocumentInterface {
    private static final long serialVersionUID = 6217818886934884980L;
    public static final int ACTION_POST_NO_ACTION = 0;
    public static final int ACTION_POST_DELETE = 1;
    public static final String START_STRING = "[Object R01MDocument (";
    public static final int DOC_UI_STATE_NOTPUBLISHED = 0;
    public static final int DOC_UI_STATE_PUBLISHED = 1;
    public static final int DOC_UI_STATE_PUBLISHED_AND_MODIFIED = 2;
    private String oid;
    private String language;
    private String versionId;
    private String name;
    private String internalName;
    private String description;
    private Date createDate = Calendar.getInstance().getTime();
    private String author;
    private Integer depthLevel;
    private Integer updatePeriod;
    private R01MDocumentRevisionState revisionState = new R01MDocumentRevisionState();
    private List<R01MDocumentPublicationTarget> publicationInfo;
    private Map<String, R01MDocumentPublicationRequested> requestedPublications;
    private Map<String, R01MDataFile> dataFiles;
    private Integer actionPost = Integer.valueOf("0");
    private String tags = "";
    private Date portalDataInitDate;
    private Date portalDataEndDate;
    private String portalDataSEOName = "";
    private String portalDataSEODescription = "";
    private long lastUpdateTS = 0L;
    private boolean indexOff = false;
    private List<R01MURLAlias> urlAliases;
    private boolean base = false;
    private boolean empty = false;

    public R01MDocument() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.CONTENTMANAGER_APPCODE, "content");
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.oid = "error-unknown";
        }
    }

    public R01MDataFile getDocumentInitialDataFile() {
        R01MDataFile initialDataFile = null;
        R01MDataFile currDataFile = null;
        if (this.dataFiles != null && this.dataFiles.size() > 0) {
            for (Map.Entry<String, R01MDataFile> me : this.dataFiles.entrySet()) {
                currDataFile = me.getValue();
                if (currDataFile.getInitialPage() != 1) continue;
                initialDataFile = currDataFile;
            }
        }
        return initialDataFile;
    }

    public R01MDataFile getDataFileByName(String name) {
        if (this.getDataFiles() != null && !this.getDataFiles().isEmpty()) {
            for (R01MDataFile curDataFile : this.getDataFiles().values()) {
                if (!name.equals(curDataFile.getName())) continue;
                return curDataFile;
            }
        }
        return null;
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    public void setOid(String theOid) {
        this.oid = theOid;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String theLanguage) {
        this.language = theLanguage;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String theVersionId) {
        this.versionId = theVersionId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String theAuthor) {
        this.author = theAuthor;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date theCreateDate) {
        this.createDate = theCreateDate;
    }

    public R01MDocumentRevisionState getRevisionState() {
        return this.revisionState;
    }

    public void setRevisionState(R01MDocumentRevisionState theRevisionState) {
        this.revisionState = theRevisionState;
    }

    public List<R01MDocumentPublicationTarget> getPublicationInfo() {
        return this.publicationInfo;
    }

    public void setPublicationInfo(List<R01MDocumentPublicationTarget> thePublicationInfo) {
        this.publicationInfo = thePublicationInfo;
    }

    public boolean isPublishedInRepository(String repOid) {
        return R01MPublicationsUtils.isPublishedInRepository(this.getPublicationInfo(), repOid);
    }

    public boolean isPublishedInAnyRepository() {
        return R01MPublicationsUtils.isPublishedInAnyRepository(this.getPublicationInfo());
    }

    public R01MDataFile getDataFile(String dataFileOid) {
        return this.dataFiles == null ? null : this.dataFiles.get(dataFileOid);
    }

    public void addDataFile(R01MDataFile newDataFile) {
        if (newDataFile == null) {
            return;
        }
        if (this.dataFiles == null) {
            this.dataFiles = new HashMap<String, R01MDataFile>();
        }
        this.dataFiles.put(newDataFile.getOid(), newDataFile);
    }

    public Map<String, R01MDataFile> getDataFiles() {
        return this.dataFiles;
    }

    public void setDataFiles(Map<String, R01MDataFile> theDataFiles) {
        this.dataFiles = theDataFiles;
    }

    public Map<String, R01MDocumentPublicationRequested> getRequestedPublications() {
        return this.requestedPublications;
    }

    public void setRequestedPublications(Map<String, R01MDocumentPublicationRequested> theRequestedPublications) {
        this.requestedPublications = theRequestedPublications;
    }

    public void addPublicationRequest(R01MDocumentPublicationRequested pubReq) {
        if (this.requestedPublications == null) {
            this.requestedPublications = new HashMap<String, R01MDocumentPublicationRequested>();
        }
        boolean alreadyExists = false;
        if (this.requestedPublications != null) {
            for (R01MDocumentPublicationRequested currPub : this.requestedPublications.values()) {
                if (!currPub.getRepositoryOid().equals(pubReq.getRepositoryOid()) || currPub.getOperationType() != pubReq.getOperationType() || currPub.getOperationType() != 0 && currPub.getOperationType() != 2) continue;
                alreadyExists = true;
            }
        }
        if (!alreadyExists) {
            this.requestedPublications.put(pubReq.getOid(), pubReq);
        }
    }

    public Integer getDepthLevel() {
        return this.depthLevel;
    }

    public void setDepthLevel(Integer theDepthLevel) {
        this.depthLevel = theDepthLevel;
    }

    public void setUpdatePeriod(Integer theUpdatePeriod) {
        this.updatePeriod = theUpdatePeriod;
    }

    public Integer getUpdatePeriod() {
        return this.updatePeriod;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String theInternalName) {
        this.internalName = theInternalName;
    }

    public Integer getActionPost() {
        return this.actionPost;
    }

    public void setActionPost(Integer theActionPost) {
        this.actionPost = theActionPost;
    }

    public long getLastUpdateTS() {
        return this.lastUpdateTS;
    }

    public void setLastUpdateTS(long theLastUpdateTS) {
        this.lastUpdateTS = theLastUpdateTS;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String theTags) {
        this.tags = theTags;
    }

    public Date getPortalDataInitDate() {
        return this.portalDataInitDate;
    }

    public void setPortalDataInitDate(Date thePortalDataInitDate) {
        this.portalDataInitDate = thePortalDataInitDate;
    }

    public Date getPortalDataEndDate() {
        return this.portalDataEndDate;
    }

    public void setPortalDataEndDate(Date thePortalDataEndDate) {
        this.portalDataEndDate = thePortalDataEndDate;
    }

    @Override
    public boolean isIndexOff() {
        return this.indexOff;
    }

    public void setIndexOff(boolean bIndexOff) {
        this.indexOff = bIndexOff;
    }

    public String getPortalDataSEOName() {
        return this.portalDataSEOName;
    }

    public void setPortalDataSEOName(String thePortalDataSEOName) {
        this.portalDataSEOName = thePortalDataSEOName;
    }

    public String getPortalDataSEODescription() {
        return this.portalDataSEODescription;
    }

    public void setPortalDataSEODescription(String thePortalDataSEODescription) {
        this.portalDataSEODescription = thePortalDataSEODescription;
    }

    public List<R01MURLAlias> getUrlAliases() {
        return this.urlAliases;
    }

    public void setUrlAliases(List<R01MURLAlias> theUrlAliases) {
        this.urlAliases = theUrlAliases;
    }

    public boolean isBase() {
        return this.base;
    }

    public int getBaseValue() {
        if (this.base) {
            return 1;
        }
        return 0;
    }

    public void setBaseValue(int baseParam) {
        if (baseParam == 1) {
            this.setBase(true);
        } else {
            this.setBase(false);
        }
    }

    public void setBase(boolean isBase) {
        this.base = isBase;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    public int getEmptyValue() {
        if (this.empty) {
            return 1;
        }
        return 0;
    }

    public void setEmptyValue(int emptyParam) {
        if (emptyParam == 1) {
            this.setEmpty(true);
        } else {
            this.setEmpty(false);
        }
    }

    public void setEmpty(boolean isEmpty) {
        this.empty = isEmpty;
    }

    public String getPublishRepositoryOid() {
        String pubRepositoryOid = "";
        if (this.isPublishedInAnyRepository()) {
            Date pubDate = null;
            int pubState = 0;
            for (R01MDocumentPublicationTarget pubTarget : this.getPublicationInfo()) {
                if (StringUtils.isEmptyString((String)pubRepositoryOid)) {
                    pubDate = pubTarget.getPublishDate();
                    pubRepositoryOid = pubTarget.getOid();
                    pubState = pubTarget.getState();
                    continue;
                }
                if (!pubTarget.getPublishDate().after(pubDate)) continue;
                pubDate = pubTarget.getPublishDate();
                pubRepositoryOid = pubTarget.getOid();
                pubState = pubTarget.getState();
            }
            if (pubState == 0) {
                pubRepositoryOid = "";
            }
        }
        return pubRepositoryOid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateObject() throws R01MContentModelObjectsValidatorException {
        List<Object> documentAllowedLangs = new ArrayList<String>();
        try {
            documentAllowedLangs.addAll(R01MClientFactory.getMiscellaneousAPI().getLanguages(R01MConstants.DEFAULT_LANG).keySet());
        }
        catch (Exception ex) {
            documentAllowedLangs = null;
        }
        finally {
            if (documentAllowedLangs == null || documentAllowedLangs.isEmpty()) {
                documentAllowedLangs = R01MConstants.DOCUMENT_ALLOWED_LANGS;
            }
        }
        if (StringUtils.isEmptyString((String)this.oid) || StringUtils.isEmptyString((String)this.language) || StringUtils.isEmptyString((String)this.name) || StringUtils.isEmptyString((String)this.internalName) || this.revisionState == null) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MDocument] Los atributos (oid,language,name,internalName,revisionState) son obligatorios.");
        }
        if (this.oid.length() > 50) {
            throw new R01MContentModelObjectsValidatorException(51L, START_STRING + this.oid + ")][Attribute oid] 0 < tama\u00f1o <= 50.");
        }
        if (this.language.length() > 3 || !documentAllowedLangs.contains(this.language)) {
            throw new R01MContentModelObjectsValidatorException(52L, START_STRING + this.oid + ")][Attribute language] El c\u00f3digo de idioma no es v\u00e1lido: " + this.language);
        }
        if (this.internalName.length() > 8) {
            throw new R01MContentModelObjectsValidatorException(53L, START_STRING + this.oid + ")][Attribute internalName] tama\u00f1o <= 8.");
        }
        if (this.versionId != null && this.versionId.length() > 50) {
            throw new R01MContentModelObjectsValidatorException(54L, START_STRING + this.oid + ")(" + this.language + "_" + this.internalName + ")][Attribute versionId] tama\u00f1o <= 50.");
        }
        if (this.name.length() > 1000) {
            throw new R01MContentModelObjectsValidatorException(55L, START_STRING + this.oid + ")(" + this.language + "_" + this.internalName + ")][Attribute name] tama\u00f1o <= 1000.");
        }
        if (this.description != null && this.description.length() > 4000) {
            throw new R01MContentModelObjectsValidatorException(56L, START_STRING + this.oid + ")(" + this.language + "_" + this.internalName + ")][Attribute description] tama\u00f1o <= 4000.");
        }
        if (this.author != null && this.author.length() > 75) {
            throw new R01MContentModelObjectsValidatorException(57L, START_STRING + this.oid + ")(" + this.language + "_" + this.internalName + ")][Attribute author] tama\u00f1o <= 75.");
        }
        if (this.depthLevel != null && (this.depthLevel < 1 || this.depthLevel > 6)) {
            throw new R01MContentModelObjectsValidatorException(58L, START_STRING + this.oid + ")(" + this.language + "_" + this.internalName + ")][Attribute depthLevel] 1 <= tama\u00f1o <= 6.");
        }
        if (this.updatePeriod != null && (this.updatePeriod < 1 || this.updatePeriod > 4)) {
            throw new R01MContentModelObjectsValidatorException(59L, START_STRING + this.oid + ")(" + this.language + "_" + this.internalName + ")][Attribute updatePeriod] 1 <= tama\u00f1o <= 4.");
        }
        if (this.portalDataSEOName != null && this.portalDataSEOName.length() > 255) {
            throw new R01MContentModelObjectsValidatorException(7L, "[Object R01MDocument(" + this.oid + ")][Attribute portalDataSEOName] tama\u00f1o <= 255.");
        }
        if (this.portalDataSEODescription != null && this.portalDataSEODescription.length() > 4000) {
            throw new R01MContentModelObjectsValidatorException(7L, "[Object R01MDocument(" + this.oid + ")][Attribute portalDataSEODescription] tama\u00f1o <= 4000.");
        }
        if (!this._isValidName(this.internalName)) {
            throw new R01MContentModelObjectsValidatorException(START_STRING + this.oid + ")(" + this.language + "_" + this.internalName + ")] [Attribute internalName] Debe ser caracteres en min\u00fasculas, n\u00fameros y gui\u00f3n bajo. Ej:cont_2_ad.");
        }
        this.revisionState.validateObject();
        if (this.publicationInfo != null && !this.publicationInfo.isEmpty()) {
            for (R01MDocumentPublicationTarget r01MDocumentPublicationTarget : this.publicationInfo) {
                if (r01MDocumentPublicationTarget != null) {
                    r01MDocumentPublicationTarget.validateObject();
                    continue;
                }
                throw new R01MContentModelObjectsValidatorException(START_STRING + this.oid + ")(" + this.language + "_" + this.internalName + ")] [Attribute publicationInfo] Contiene valores NULL.");
            }
        }
        if (this.requestedPublications != null && !this.requestedPublications.isEmpty()) {
            String multipleRequestedPublishAllowedByRepository = "false";
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> incorrectRequest = new ArrayList<String>();
            for (Map.Entry<String, R01MDocumentPublicationRequested> registry : this.requestedPublications.entrySet()) {
                R01MDocumentPublicationRequested publicationRequested = registry.getValue();
                if ("false".equals("false") && (publicationRequested.getOperationType() == 0 || publicationRequested.getOperationType() == 2)) {
                    if (arrayList.contains(publicationRequested.getRepositoryOid())) {
                        R01FLog.to((String)"r01m.util").warning(START_STRING + this.oid + ")(" + this.language + "_" + this.internalName + ")] Contiene mas de una peticion de publicacion / despublicacion inmediata para el repositorio con oid:" + publicationRequested.getRepositoryOid() + " procedemos a eliminar la ultima peticion ");
                        incorrectRequest.add(registry.getKey());
                        continue;
                    }
                    arrayList.add(publicationRequested.getRepositoryOid());
                }
                if (publicationRequested.getOid() == null || publicationRequested.getRepositoryOid() == null || publicationRequested.getOperationDate() == null) {
                    R01FLog.to((String)"r01m.util").warning(START_STRING + this.oid + ")(" + this.language + "_" + this.internalName + ")] [Attribute publicationRequested] Contiene valores NULL. Procedemos a eliminar la peticion ");
                    incorrectRequest.add(registry.getKey());
                    continue;
                }
                publicationRequested.validateObject();
            }
            if (!incorrectRequest.isEmpty()) {
                this.removeIncorrectReq(incorrectRequest);
            }
        }
        if (this.dataFiles != null && !this.dataFiles.isEmpty()) {
            for (Map.Entry entry : this.dataFiles.entrySet()) {
                if (!(entry.getValue() instanceof R01MDataFile)) continue;
                R01MDataFile datafile = (R01MDataFile)entry.getValue();
                if (datafile != null) {
                    datafile.validateObject();
                    continue;
                }
                throw new R01MContentModelObjectsValidatorException(START_STRING + this.oid + ")(" + this.language + "_" + this.internalName + ")] [Attribute dataFiles] Contiene valores NULL.");
            }
        }
        if (this.urlAliases != null && !this.urlAliases.isEmpty()) {
            boolean documentHasAliasBase = false;
            for (R01MURLAlias alias : this.urlAliases) {
                if (alias != null) {
                    if (alias.isBaseAlias()) {
                        if (documentHasAliasBase) {
                            alias.setBaseAlias(false);
                            R01FLog.to((String)"r01m.util").info(START_STRING + this.oid + ")(" + this.language + "_" + this.internalName + ")] [Attribute urlalias] El alias base para el documento debe ser \u00fanico: " + alias.getAlias() + " se establece como no base.");
                        }
                        documentHasAliasBase = true;
                    }
                    try {
                        alias.validateObject();
                        continue;
                    }
                    catch (R01MModelObjectsValidatorException ex) {
                        throw new R01MContentModelObjectsValidatorException((Exception)((Object)ex));
                    }
                }
                throw new R01MContentModelObjectsValidatorException(START_STRING + this.oid + ")(" + this.language + "_" + this.internalName + ")] [Attribute urlalias] Contiene valores NULL.");
            }
            if (!documentHasAliasBase) {
                this.urlAliases.get(0).setBaseAlias(true);
            }
        }
    }

    private void removeIncorrectReq(List<String> theIncorrectRequests) {
        if (theIncorrectRequests != null && !theIncorrectRequests.isEmpty()) {
            for (String request : theIncorrectRequests) {
                if (request == null) continue;
                this.requestedPublications.remove(request);
            }
        }
    }

    private boolean _isValidName(String theName) {
        if (theName.indexOf(13) > 0 || theName.indexOf(10) > 0) {
            return false;
        }
        char[] cName = new char[50];
        theName.getChars(0, theName.length(), cName, 0);
        for (int i = 0; i < theName.length(); ++i) {
            if (Character.getNumericValue(cName[i]) >= 10 && Character.getNumericValue(cName[i]) <= 35 || Character.getNumericValue(cName[i]) >= 0 && Character.getNumericValue(cName[i]) <= 9 || String.valueOf(cName[i]).equals("_")) {
                if (Character.getNumericValue(cName[i]) < 10 || Character.getNumericValue(cName[i]) > 35 || !Character.isUpperCase(cName[i])) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

