/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.contentmodel;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.objects.contentmodel.R01MBaseContentModelObject;
import com.ejie.r01m.objects.contentmodel.R01MBaseDatafileInterface;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.util.Calendar;
import java.util.Date;

public class R01MDataFile
extends R01MBaseContentModelObject
implements R01MBaseDatafileInterface {
    private static final long serialVersionUID = 6514992240550999399L;
    public static final int STATE_OF_GENERATION_REG_ERROR = -1;
    public static final int STATE_OF_GENERATION_REG_DEFAULT = 0;
    public static final int STATE_OF_GENERATION_REG_IN_PROGRESS = 1;
    public static final int STATE_OF_GENERATION_REG_REPEAT = 2;
    public static final int STATE_OF_GENERATION_REG_OK = 3;
    private String oid;
    private String templateOid;
    private String name;
    private String description;
    private String author;
    private Date createDate = Calendar.getInstance().getTime();
    private String editUrl;
    private String previewUrl;
    private String generateUrl;
    private int initialPage = 0;
    private boolean metaDataContainer = false;

    public R01MDataFile() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.CONTENTMANAGER_APPCODE, "content");
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.oid = "error-unknown";
        }
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    public void setOid(String theOid) {
        this.oid = theOid;
    }

    @Override
    public String getTemplateOid() {
        return this.templateOid;
    }

    public void setTemplateOid(String theTemplateOid) {
        this.templateOid = theTemplateOid;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String theAuthor) {
        this.author = theAuthor;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date theCreateDate) {
        this.createDate = theCreateDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    @Override
    public String getInternalName() {
        return this.name;
    }

    public void setInternalName(String theInternalName) {
        this.name = theInternalName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    @Override
    public String getEditUrl() {
        return this.editUrl;
    }

    public void setEditUrl(String theEditUrl) {
        this.editUrl = theEditUrl;
    }

    @Override
    public String getPreviewUrl() {
        return this.previewUrl;
    }

    public void setPreviewUrl(String thePreviewUrl) {
        this.previewUrl = thePreviewUrl;
    }

    @Override
    public String getGenerateUrl() {
        return this.generateUrl;
    }

    public void setGenerateUrl(String theGenerateUrl) {
        this.generateUrl = theGenerateUrl;
    }

    @Override
    public int getInitialPage() {
        return this.initialPage;
    }

    public void setInitialPage(int theInitialPage) {
        this.initialPage = theInitialPage;
        if (theInitialPage == 0) {
            this.setMetaDataContainer(false);
        } else if (theInitialPage == 1) {
            this.setMetaDataContainer(true);
        }
    }

    public boolean getMetaDataContainer() {
        return this.metaDataContainer;
    }

    public void setMetaDataContainer(boolean isMetaDataContainer) {
        this.metaDataContainer = isMetaDataContainer;
    }

    public String getGeneratedFileName() {
        String fileName = "";
        if (!StringUtils.isEmptyString((String)this.getPreviewUrl())) {
            fileName = this.getPreviewUrl().substring(this.getPreviewUrl().lastIndexOf("/") + 1, this.getPreviewUrl().length());
        }
        return fileName;
    }

    @Override
    public void validateObject() throws R01MContentModelObjectsValidatorException {
        if (StringUtils.isEmptyString((String)this.oid) || StringUtils.isEmptyString((String)this.name) || StringUtils.isEmptyString((String)this.templateOid) || StringUtils.isEmptyString((String)this.editUrl) || StringUtils.isEmptyString((String)this.previewUrl) || StringUtils.isEmptyString((String)this.generateUrl)) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MDataFile] Los atributos (oid,name,templateOid,editUrl,previewUrl,generateUrl) son obligatorios.");
        }
        if (this.oid.length() > 50) {
            throw new R01MContentModelObjectsValidatorException(101L, "[Object R01MDataFile (" + this.oid + ")][Attribute oid] 0 < tama\u00f1o <= 50.");
        }
        if (this.templateOid.length() > 50) {
            throw new R01MContentModelObjectsValidatorException(102L, "[Object R01MDataFile (" + this.oid + ")][Attribute templateOid] 0 < tama\u00f1o <= 50.");
        }
        if (this.name.length() > 50) {
            throw new R01MContentModelObjectsValidatorException(103L, "[Object R01MDataFile (" + this.oid + ")][Attribute name] tama\u00f1o <= 50.");
        }
        if (!StringUtils.isEmptyString((String)this.description) && this.description.length() > 255) {
            throw new R01MContentModelObjectsValidatorException(104L, "[Object R01MDataFile (" + this.oid + ")(" + this.name + ")][Attribute description] tama\u00f1o <= 255.");
        }
        if (!StringUtils.isEmptyString((String)this.author) && this.author.length() > 75) {
            throw new R01MContentModelObjectsValidatorException(105L, "[Object R01MDataFile (" + this.oid + ")(" + this.name + ")][Attribute author] tama\u00f1o <= 75.");
        }
        if (this.editUrl.length() > 2000) {
            throw new R01MContentModelObjectsValidatorException(106L, "[Object R01MDataFile (" + this.oid + ")(" + this.name + ")][Attribute editUrl] 0 < tama\u00f1o <= 2000.");
        }
        if (this.previewUrl.length() > 2000) {
            throw new R01MContentModelObjectsValidatorException(107L, "[Object R01MDataFile (" + this.oid + ")(" + this.name + ")][Attribute previewUrl] 0 < tama\u00f1o <= 2000.");
        }
        if (this.generateUrl.length() > 2000) {
            throw new R01MContentModelObjectsValidatorException(108L, "[Object R01MDataFile (" + this.oid + ")(" + this.name + ")][Attribute generateUrl] 0 < tama\u00f1o <= 2000.");
        }
        if (this.initialPage != 0 && this.initialPage != 1) {
            throw new R01MContentModelObjectsValidatorException(109L, "[Object R01MDataFile (" + this.oid + ")(" + this.name + ")][Attribute initialPage] Valores: 0 o 1.");
        }
        if (!this._isValidName(this.name)) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MDataFile(" + this.oid + ")] [Attribute name] Debe ser caracteres en min\u00fasculas, n\u00fameros y gui\u00f3n bajo. Ej:cont_2_ad.");
        }
    }

    private boolean _isValidName(String theName) {
        if (theName.indexOf(13) > 0 || theName.indexOf(10) > 0) {
            return false;
        }
        char[] cName = new char[50];
        theName.getChars(0, theName.length(), cName, 0);
        for (int i = 0; i < theName.length(); ++i) {
            if (Character.getNumericValue(cName[i]) >= 10 && Character.getNumericValue(cName[i]) <= 35 || Character.getNumericValue(cName[i]) >= 0 && Character.getNumericValue(cName[i]) <= 9 || String.valueOf(cName[i]).equals("_")) {
                if (Character.getNumericValue(cName[i]) < 10 || Character.getNumericValue(cName[i]) > 35 || !Character.isUpperCase(cName[i])) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

