/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.contentmodel;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.objects.contentmodel.R01MBaseContentModelObject;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MTypologyConfigAPI;
import java.util.StringTokenizer;

public class R01MContentTypologyInfo
extends R01MBaseContentModelObject {
    private static final long serialVersionUID = 6963132638633960753L;
    private String clusterOid;
    private String familyOid;
    private String typeOid;

    public R01MContentTypologyInfo() {
    }

    public R01MContentTypologyInfo(String newClusterOid, String newFamilyOid, String newTypeOid) {
        this();
        this.clusterOid = newClusterOid;
        this.familyOid = newFamilyOid;
        this.typeOid = newTypeOid;
    }

    public String composeMemoCode() {
        return this.clusterOid + ":" + this.familyOid + ":" + this.typeOid;
    }

    public void loadFromMemoCode(String memoCode) {
        if (memoCode == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(memoCode, ":");
        if (st.countTokens() != 3) {
            return;
        }
        int i = 0;
        while (st.hasMoreTokens()) {
            switch (i) {
                case 0: {
                    this.clusterOid = st.nextToken();
                    break;
                }
                case 1: {
                    this.familyOid = st.nextToken();
                    break;
                }
                case 2: {
                    this.typeOid = st.nextToken();
                    break;
                }
            }
            ++i;
        }
    }

    public String getClusterOid() {
        return this.clusterOid;
    }

    public void setClusterOid(String newClusterOid) {
        this.clusterOid = newClusterOid;
    }

    public String getFamilyOid() {
        return this.familyOid;
    }

    public void setFamilyOid(String newFamilyOid) {
        this.familyOid = newFamilyOid;
    }

    public String getTypeOid() {
        return this.typeOid;
    }

    public void setTypeOid(String newTypeOid) {
        this.typeOid = newTypeOid;
    }

    @Override
    public void validateObject() throws R01MContentModelObjectsValidatorException {
        if (StringUtils.isEmptyString((String)this.clusterOid) || StringUtils.isEmptyString((String)this.familyOid) || StringUtils.isEmptyString((String)this.typeOid)) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentTypologyInfo] Los atributos (clusterOid,familyOid,typeOid) son obligatorios.");
        }
        if (this.clusterOid.length() > 50) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentTypologyInfo][Attribute clusterOid] 0 < tama\u00f1o <= 50.");
        }
        if (this.familyOid.length() > 50) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentTypologyInfo][Attribute familyOid] 0 < tama\u00f1o <= 50.");
        }
        if (this.typeOid.length() > 50) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentTypologyInfo][Attribute typeOid] 0 < tama\u00f1o <= 50.");
        }
        R01MTypologyConfigAPI typologyConfigAPI = R01MClientFactory.getTypologyConfigAPI();
        try {
            if (typologyConfigAPI.getClusterConfig(this.clusterOid) == null || typologyConfigAPI.getClusterConfig(this.clusterOid).getFamilies() == null || typologyConfigAPI.getClusterConfig(this.clusterOid).getFamilies().isEmpty() || !typologyConfigAPI.getClusterConfig(this.clusterOid).getFamilies().containsKey(this.familyOid)) {
                throw new R01MContentModelObjectsValidatorException("[Object R01MContentTypologyInfo] La family '" + this.familyOid + "', no pertenece al cluster '" + this.clusterOid + "'.");
            }
        }
        catch (R01MConfigLoadException e) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentTypologyInfo] Error al leer la tipologia,el cluster especificado '" + this.clusterOid + "' no es v\u00e1lido.");
        }
        try {
            if (typologyConfigAPI.getFamilyConfig(this.familyOid) == null || typologyConfigAPI.getFamilyConfig(this.familyOid).getTypes() == null || typologyConfigAPI.getFamilyConfig(this.familyOid).getTypes().isEmpty() || !typologyConfigAPI.getFamilyConfig(this.familyOid).getTypes().containsKey(this.typeOid)) {
                throw new R01MContentModelObjectsValidatorException("[Object R01MContentTypologyInfo] El typo '" + this.typeOid + "', no pertenece a la family '" + this.familyOid + "'.");
            }
        }
        catch (R01MConfigLoadException e) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentTypologyInfo] Error al leer la typologia, la familia especificada '" + this.familyOid + "' no es v\u00e1lida.");
        }
    }
}

