/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.contentmodel;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.services.R01MClientFactory;

public class R01MContentLocation
extends R01MBaseLocationObject {
    private static final long serialVersionUID = 8909195521914015996L;

    public R01MContentLocation() {
    }

    public R01MContentLocation(String newServerOid, String newDataRepositoryOid, String newAreaOid, String newWorkAreaOid) {
        super(newServerOid, newDataRepositoryOid, newAreaOid, newWorkAreaOid);
    }

    @Override
    public void validateObject() throws R01MContentModelObjectsValidatorException {
        if (StringUtils.isEmptyString((String)this.serverOid) || StringUtils.isEmptyString((String)this.dataRepositoryOid) || StringUtils.isEmptyString((String)this.areaOid) || StringUtils.isEmptyString((String)this.workAreaOid)) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentLocation] Los atributos (serverOid,dataRepositoryOid,areaOid,workAreaOid) son obligatorios.");
        }
        if (this.serverOid.length() > 50) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentLocation][Attribute serverOid] 0 < tama\u00f1o <= 50.");
        }
        if (this.dataRepositoryOid.length() > 50) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentLocation][Attribute dataRepositoryOid] 0 < tama\u00f1o <= 50.");
        }
        if (this.areaOid.length() > 50) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentLocation][Attribute areaOid] 0 < tama\u00f1o <= 50.");
        }
        if (this.workAreaOid.length() > 50) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentLocation][Attribute workAreaOid] 0 < tama\u00f1o <= 50.");
        }
        try {
            R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(this.serverOid, this.dataRepositoryOid, this.areaOid, this.workAreaOid);
        }
        catch (R01MConfigLoadException e) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentLocation] El storage especificado no existe, revisar los xml de configuraci\u00f3n del Storage.");
        }
    }
}

