/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.contentmodel;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MBaseHistory;
import com.ejie.r01m.objects.R01MPrintableInterface;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;

public class R01MContentHistory
extends R01MBaseHistory
implements R01MPrintableInterface {
    private static final long serialVersionUID = -4233755034263119591L;
    public static final int ACTION_UNKNOWN = 0;
    public static final int ACTION_NEWCONTENT = 1;
    public static final int ACTION_NEWDOCUMENT = 2;
    public static final int ACTION_NEWDATAFILE = 3;
    public static final int ACTION_UPDATECONTENT = 4;
    public static final int ACTION_UPDATEDOCUMENT = 5;
    public static final int ACTION_UPDATEDATAFILE = 6;
    public static final int ACTION_APPROVEDOCUMENT = 7;
    public static final int ACTION_TRANSLATEDOCUMENT = 8;
    public static final int ACTION_CATALOGUECONTENT = 9;
    public static final int ACTION_PUBLICATEDOCUMENT = 10;
    public static final int ACTION_EXPIRATEDOCUMENT = 11;
    public static final int ACTION_REVISEDOCUMENT = 12;
    public static final int ACTION_BOUNDCONTENT = 13;
    public static final int ACTION_DELETECONTENT = 14;
    public static final int ACTION_DELETEDOCUMENT = 15;
    public static final int ACTION_DELETEDATAFILE = 16;
    public static final int ACTION_REJECTDOCUMENT = 17;
    public static final int ACTION_EDITDOCUMENT = 18;
    public static final int ACTION_COPYCONTENT = 19;
    public static final int ACTION_CHANGECONTENTTYPO = 4;
    public static final int ACTION_CHANGECONTENTLOC = 4;
    public static final int ACTION_UNPUBLISHDOCUMENT = 20;
    public static final int ACTION_COPYDOCUMENT = 21;
    public static final int STATE_NOT_INFILE = 1;
    public static final int STATE_ACTIVE_NOT_INFILE = 2;
    public static final int STATE_ACTIVE_SAVED = 3;
    public static final int TYPE_SAVE_IN_BD = 0;
    public static final int TYPE_SAVE_IN_FILE = 1;

    public R01MContentHistory() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.CONTENTMANAGER_APPCODE);
        }
        catch (GUIDDispenserException guidEx) {
            guidEx.printStackTrace(System.out);
            this.oid = "error-unknown";
        }
    }

    @Override
    public void validateObject() throws R01MContentModelObjectsValidatorException {
        if (StringUtils.isEmptyString((String)this.name) || this.type == null || StringUtils.isEmptyString((String)this.author) || this.action == null || StringUtils.isEmptyString((String)this.objectOid)) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentHistory] Los atributos (name,type,author,action,objectOid) son obligatorios.");
        }
        if (this.name.length() > 30) {
            this.name = this.name.substring(0, 30);
        }
        if (this.type < 0 || this.type > 2) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentHistory(" + this.name + " - " + this.actionName + ")][Attribute type] 0 <= tama\u00f1o <= 2.");
        }
        if (!StringUtils.isEmptyString((String)this.comment) && this.comment.length() > 255) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentHistory(" + this.name + " - " + this.actionName + ")][Attribute comment]  tama\u00f1o <= 255.");
        }
        if (this.author.length() > 75) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentHistory(" + this.name + " - " + this.actionName + ")][Attribute author]  tama\u00f1o <= 75.");
        }
        if (this.action < 1 || this.action > 21) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContentHistory(" + this.name + " - " + this.actionName + ")][Attribute action] 1 <= tama\u00f1o <= 21.");
        }
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(500);
        String tabPrefix = prefix + "\t";
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== R01MContentHistory  ========\r\n");
        sb.append(super.debugInfo(tabPrefix));
        return sb;
    }
}

