/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.contentmodel;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.searchengine.R01MSearchSource;
import com.ejie.r01m.config.objects.searchengine.R01MSearchSourceIndexer;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBasePublicationTarget;
import com.ejie.r01m.objects.cataloguing.R01MGeoCatalog;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.cataloguing.picks.R01MGeoPick;
import com.ejie.r01m.objects.cataloguing.picks.R01MGeoPicks;
import com.ejie.r01m.objects.contentmodel.R01MBaseContentInterface;
import com.ejie.r01m.objects.contentmodel.R01MBaseContentModelObject;
import com.ejie.r01m.objects.contentmodel.R01MBaseDocumentInterface;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.contentmodel.R01MDocumentResume;
import com.ejie.r01m.objects.contentmodel.R01MDocumentRevisionState;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class R01MContent
extends R01MBaseContentModelObject
implements R01MBaseContentInterface {
    private static final long serialVersionUID = 2095777711387979726L;
    public static final int ACTION_POST_NO_ACTION = 0;
    public static final int ACTION_POST_DELETE = 1;
    private String oid;
    private R01MContentLocation storeLocation;
    private R01MContentTypologyInfo typo;
    private String name;
    private String description;
    private Date createDate = Calendar.getInstance().getTime();
    private Date newnessUntilDate = Calendar.getInstance().getTime();
    private String author;
    private String chargePerson;
    private String source;
    private Map<String, R01MBaseDocumentInterface> documents;
    private List<R01MStructureCatalog> labels;
    private Map<String, R01MGeoCatalog> geoLabels;
    private R01MGeoPicks geoPicks;
    private Integer actionPost = Integer.valueOf(Integer.toString(0));
    private String portalDataSEOName = "";
    private String portalDataSEODescription = "";
    private long lastUpdateTS = 0L;
    private boolean hideTypeHeader = false;
    private boolean hideEntityHeader = false;

    public R01MContent() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.CONTENTMANAGER_APPCODE, "content");
            Calendar cal = Calendar.getInstance();
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            this.newnessUntilDate = cal.getTime();
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.oid = "error-unknown";
        }
    }

    public String composeStructureLabelsMemoCode() {
        if (this.getLabels() == null) {
            return "";
        }
        StringBuffer labelsStr = new StringBuffer("");
        Iterator<R01MStructureCatalog> lit = this.getLabels().iterator();
        while (lit.hasNext()) {
            labelsStr.append(lit.next().composeMemoCode());
            labelsStr.append(lit.hasNext() ? ";" : "");
        }
        return labelsStr.toString();
    }

    public String composeGeoLabelsMemoCode() {
        if (this.getGeoLabels() == null) {
            return "";
        }
        StringBuffer labelsStr = new StringBuffer("");
        Iterator<R01MGeoCatalog> lit = this.getGeoLabels().values().iterator();
        while (lit.hasNext()) {
            labelsStr.append(lit.next().composeMemoCode());
            labelsStr.append(lit.hasNext() ? ";" : "");
        }
        return labelsStr.toString();
    }

    public String composeGeoPicksMemoCode() {
        if (this.getGeoPicks() == null) {
            return "";
        }
        StringBuffer labelsStr = new StringBuffer("");
        Iterator<R01MGeoPick> lit = this.getGeoPicks().getGeopicks().iterator();
        while (lit.hasNext()) {
            labelsStr.append(lit.next().getGeocode().composeMemoCode());
            labelsStr.append(lit.hasNext() ? ";" : "");
        }
        return labelsStr.toString();
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    public void setOid(String newOid) {
        this.oid = newOid;
    }

    public R01MContentLocation getStoreLocation() {
        return this.storeLocation;
    }

    public void setStoreLocation(R01MContentLocation newStoreLocation) {
        this.storeLocation = newStoreLocation;
    }

    public R01MContentTypologyInfo getTypo() {
        return this.typo;
    }

    public void setTypo(R01MContentTypologyInfo theTypo) {
        this.typo = theTypo;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public String getInternalName() {
        return this.name;
    }

    public void setInternalName(String theInternalName) {
        this.name = theInternalName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date theCreateDate) {
        this.createDate = theCreateDate;
    }

    public Date getNewnessUntilDate() {
        return this.newnessUntilDate;
    }

    public void setNewnessUntilDate(Date theNewnessUntilDate) {
        this.newnessUntilDate = theNewnessUntilDate;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String theAuthor) {
        this.author = theAuthor;
    }

    public String getChargePerson() {
        return this.chargePerson;
    }

    public void setChargePerson(String theChargePerson) {
        this.chargePerson = theChargePerson;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String theSource) {
        this.source = theSource;
    }

    public R01MDocument getDocument(String documentOid) {
        if (this.documents == null) {
            return null;
        }
        return (R01MDocument)this.documents.get(documentOid);
    }

    public Map<String, R01MDocument> getDocuments() {
        return this.documents;
    }

    public List<R01MDocument> getPublishedDocuments() {
        ArrayList<R01MDocument> publishedDocuments = new ArrayList<R01MDocument>();
        if (this.documents != null) {
            for (R01MBaseDocumentInterface document : this.documents.values()) {
                if (!this._isDocumentPublishedInAnyRepository((R01MDocument)document)) continue;
                publishedDocuments.add((R01MDocument)document);
            }
        }
        return publishedDocuments;
    }

    public List<R01MDocument> getPublishedDocuments(String repoPub) {
        ArrayList<R01MDocument> publishedDocuments = new ArrayList<R01MDocument>();
        if (this.documents != null) {
            for (R01MBaseDocumentInterface document : this.documents.values()) {
                if (!this._isDocumentPublishedInSpecifiedRepository((R01MDocument)document, repoPub)) continue;
                publishedDocuments.add((R01MDocument)document);
            }
        }
        return publishedDocuments;
    }

    public List<R01MDocument> getDocumentsByLanguage(String lang) {
        ArrayList<R01MDocument> documentList = new ArrayList<R01MDocument>();
        if (this.documents != null) {
            for (R01MBaseDocumentInterface document : this.documents.values()) {
                if (!document.getLanguage().equals(lang)) continue;
                documentList.add((R01MDocument)document);
            }
        }
        return documentList;
    }

    public List<R01MDocument> getPublishedDocumentsByLanguage(String lang) {
        ArrayList<R01MDocument> publishedDocuments = new ArrayList<R01MDocument>();
        if (this.documents != null) {
            for (R01MBaseDocumentInterface document : this.documents.values()) {
                if (!document.getLanguage().equals(lang) || !this._isDocumentPublishedInAnyRepository((R01MDocument)document)) continue;
                publishedDocuments.add((R01MDocument)document);
            }
        }
        return publishedDocuments;
    }

    public List<R01MDocument> getPublishedDocumentsByLanguage(String lang, String repoPub) {
        ArrayList<R01MDocument> publishedDocuments = new ArrayList<R01MDocument>();
        if (this.documents != null) {
            for (R01MBaseDocumentInterface document : this.documents.values()) {
                if (!document.getLanguage().equals(lang) || !this._isDocumentPublishedInSpecifiedRepository((R01MDocument)document, repoPub)) continue;
                publishedDocuments.add((R01MDocument)document);
            }
        }
        return publishedDocuments;
    }

    public List<R01MDocument> getDocumentsByInternalName(String internalName) {
        ArrayList<R01MDocument> documentList = new ArrayList<R01MDocument>();
        if (this.documents != null) {
            for (R01MBaseDocumentInterface document : this.documents.values()) {
                if (!document.getInternalName().equals(internalName)) continue;
                documentList.add((R01MDocument)document);
            }
        }
        return documentList;
    }

    public List<R01MDocument> getPublishedDocumentsByInternalName(String internalName) {
        ArrayList<R01MDocument> publishedDocuments = new ArrayList<R01MDocument>();
        if (this.documents != null) {
            for (R01MBaseDocumentInterface document : this.documents.values()) {
                if (!document.getInternalName().equals(internalName) || !this._isDocumentPublishedInAnyRepository((R01MDocument)document)) continue;
                publishedDocuments.add((R01MDocument)document);
            }
        }
        return publishedDocuments;
    }

    public List<R01MDocument> getPublishedDocumentsByInternalName(String internalName, String repoPub) {
        ArrayList<R01MDocument> publishedDocuments = new ArrayList<R01MDocument>();
        if (this.documents != null) {
            for (R01MBaseDocumentInterface document : this.documents.values()) {
                if (!document.getInternalName().equals(internalName) || !this._isDocumentPublishedInSpecifiedRepository((R01MDocument)document, repoPub)) continue;
                publishedDocuments.add((R01MDocument)document);
            }
        }
        return publishedDocuments;
    }

    public R01MDocument getDocumentsByLanguageAndInternalName(String lang, String internalName) {
        if (this.documents != null) {
            for (R01MBaseDocumentInterface document : this.documents.values()) {
                if (!document.getInternalName().equals(internalName) || !document.getLanguage().equals(lang)) continue;
                return (R01MDocument)document;
            }
        }
        return null;
    }

    public List<String> getGroupsName() {
        if (this.documents != null && !this.documents.isEmpty()) {
            ArrayList<String> groups = new ArrayList<String>();
            for (R01MBaseDocumentInterface document : this.documents.values()) {
                if (((R01MDocument)document).getDataFiles() == null || ((R01MDocument)document).getDataFiles().isEmpty() || groups.contains(document.getInternalName())) continue;
                groups.add(document.getInternalName());
            }
            return groups;
        }
        return null;
    }

    public boolean hasGroups() {
        List<String> groups = this.getGroupsName();
        return groups != null && !groups.isEmpty() && groups.size() > 1;
    }

    public Map<String, List<R01MDocument>> getDocumentsByGroups() {
        HashMap<String, List<R01MDocument>> documentsByGroups = new HashMap<String, List<R01MDocument>>();
        List<String> groups = this.getGroupsName();
        if (groups != null && !groups.isEmpty()) {
            List<R01MDocument> documentsByGroup = null;
            for (int i = 0; i < groups.size(); ++i) {
                String group = groups.get(i).toString();
                documentsByGroup = null;
                if (StringUtils.isEmptyString((String)group)) continue;
                documentsByGroup = this.getDocumentsByInternalName(group);
                documentsByGroups.put(group, documentsByGroup);
            }
        }
        return documentsByGroups;
    }

    public boolean validateGroupName(String groupName) {
        if (StringUtils.isEmptyString((String)groupName) || groupName.length() > 8 || !this._existGroupName(groupName)) {
            // empty if block
        }
        return false;
    }

    private boolean _existGroupName(String groupName) {
        List<String> groups = this.getGroupsName();
        for (int i = 0; i < groups.size(); ++i) {
            if (!groupName.equals(groups.get(i))) continue;
            return true;
        }
        return false;
    }

    public void addDocument(R01MDocument newDoc) {
        if (newDoc == null) {
            return;
        }
        if (this.documents == null) {
            this.documents = new HashMap<String, R01MBaseDocumentInterface>();
        }
        this.documents.put(newDoc.getOid(), newDoc);
    }

    public void setDocuments(Map<String, ?> theDocuments) {
        HashMap<String, R01MBaseDocumentInterface> finalDocuments = new HashMap<String, R01MBaseDocumentInterface>();
        if (theDocuments != null) {
            for (Map.Entry<String, ?> entry : theDocuments.entrySet()) {
                if (entry.getValue() instanceof R01MDocumentResume) {
                    R01MDocument currentDocument = new R01MDocument();
                    if (this.documents == null || !this.documents.containsKey(((R01MDocumentResume)entry.getValue()).getOid())) continue;
                    try {
                        currentDocument = R01MClientFactory.getContentModelAPI(R01MAuthManager.createMasterSystemUserContext()).loadDocument(((R01MDocumentResume)entry.getValue()).getOid());
                        currentDocument.setOid(((R01MDocumentResume)entry.getValue()).getOid());
                        currentDocument.setInternalName(((R01MDocumentResume)entry.getValue()).getInternalName());
                        currentDocument.setLanguage(((R01MDocumentResume)entry.getValue()).getLanguage());
                        currentDocument.setName(((R01MDocumentResume)entry.getValue()).getName());
                        currentDocument.setLastUpdateTS(((R01MDocumentResume)entry.getValue()).getLastUpdateTS());
                        currentDocument.setRevisionState(new R01MDocumentRevisionState(((R01MDocumentResume)entry.getValue()).getState()));
                        finalDocuments.put(entry.getKey(), currentDocument);
                    }
                    catch (R01MSecurityException e) {
                        e.printStackTrace();
                    }
                    catch (R01MContentModelException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(entry.getValue() instanceof R01MDocument)) continue;
                finalDocuments.put(entry.getKey(), (R01MDocument)entry.getValue());
            }
        }
        this.documents = finalDocuments;
    }

    public void setDocumentResumes(Map<String, ?> theDocuments) {
        HashMap<String, R01MBaseDocumentInterface> finalDocuments = new HashMap<String, R01MBaseDocumentInterface>();
        for (Map.Entry<String, ?> entry : theDocuments.entrySet()) {
            if (entry.getValue() instanceof R01MDocument) {
                R01MDocumentResume currentDocument = new R01MDocumentResume((R01MDocument)entry.getValue());
                finalDocuments.put(entry.getKey(), currentDocument);
                continue;
            }
            if (!(entry.getValue() instanceof R01MDocumentResume)) continue;
            finalDocuments.put(entry.getKey(), (R01MDocumentResume)entry.getValue());
        }
        this.documents = finalDocuments;
    }

    public List<R01MStructureCatalog> getLabels() {
        return this.labels;
    }

    public void setLabels(List<R01MStructureCatalog> theLabels) {
        this.labels = theLabels;
    }

    public Map getGeocods() {
        return null;
    }

    public void setGeocods(Map theGeocods) {
    }

    public Map<String, R01MGeoCatalog> getGeoLabels() {
        return this.geoLabels;
    }

    public void setGeoLabels(Map<String, R01MGeoCatalog> theGeoLabels) {
        this.geoLabels = theGeoLabels;
    }

    public R01MGeoPicks getGeoPicks() {
        return this.geoPicks;
    }

    public void setGeoPicks(R01MGeoPicks theGeoPicks) {
        this.geoPicks = theGeoPicks;
    }

    public Integer getActionPost() {
        return this.actionPost;
    }

    public void setActionPost(Integer theActionPost) {
        this.actionPost = theActionPost;
    }

    public long getLastUpdateTS() {
        return this.lastUpdateTS;
    }

    public void setLastUpdateTS(long theLastUpdateTS) {
        this.lastUpdateTS = theLastUpdateTS;
    }

    public String getPortalDataSEOName() {
        return this.portalDataSEOName;
    }

    public void setPortalDataSEOName(String thePortalDataSEOName) {
        this.portalDataSEOName = thePortalDataSEOName;
    }

    public String getPortalDataSEODescription() {
        return this.portalDataSEODescription;
    }

    public void setPortalDataSEODescription(String thePortalDataSEODescription) {
        this.portalDataSEODescription = thePortalDataSEODescription;
    }

    public boolean isHideTypeHeader() {
        return this.hideTypeHeader;
    }

    public void setHideTypeHeader(boolean theHideTypeHeader) {
        this.hideTypeHeader = theHideTypeHeader;
    }

    public boolean isHideEntityHeader() {
        return this.hideEntityHeader;
    }

    public void setHideEntityHeader(boolean theHideEntityHeader) {
        this.hideEntityHeader = theHideEntityHeader;
    }

    public R01MDocument[] getDocumentGroup(String internalName) {
        List<R01MDocument> documentList;
        R01MDocument[] returnArray = null;
        if (internalName != null && !internalName.equals("") && (documentList = this.getDocumentsByInternalName(internalName)) != null && !documentList.isEmpty()) {
            returnArray = new R01MDocument[documentList.size()];
            for (int i = 0; i < documentList.size(); ++i) {
                returnArray[i] = documentList.get(i);
            }
        }
        return returnArray;
    }

    public R01MDocument getReferenceDocument(String internalName) {
        List<R01MDocument> documentList;
        R01MDocument retDocument = null;
        if (internalName != null && !internalName.equals("") && (documentList = this.getDocumentsByInternalName(internalName)) != null && !documentList.isEmpty()) {
            for (R01MDocument document : documentList) {
                if (!document.isBase()) continue;
                retDocument = document;
            }
        }
        return retDocument;
    }

    public boolean isGeneratedRispFiles() {
        boolean isOpendata;
        block7: {
            isOpendata = false;
            boolean generateRispFiles = false;
            try {
                generateRispFiles = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(this.getTypo().getClusterOid(), this.getTypo().getFamilyOid(), this.getTypo().getTypeOid()).getOpendata().isGenerateRispFiles();
            }
            catch (R01MConfigLoadException ex) {
                // empty catch block
            }
            try {
                List<R01MSearchSourceIndexer> srchIndexers;
                R01MSearchSource currentSource;
                List<R01MSearchSourceIndexer> srchIndexers2;
                String context = R01MSearchEngineUtils.obtainContext(XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"searchEngine/defaultSearchEngineContext", (String)"intranet"), null);
                Iterator<R01MSearchSource> i$ = R01MClientFactory.getSearchEngineConfigAPI().getSearchEngineConfig().getSearchSources(context).values().iterator();
                while (i$.hasNext() && (srchIndexers2 = (currentSource = i$.next()).getIndexers()) != null) {
                    for (R01MSearchSourceIndexer indexer : srchIndexers2) {
                        String indexerClassName = indexer.getImplClassName();
                        if (!indexerClassName.equalsIgnoreCase("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDCATIndexer") && !indexerClassName.equalsIgnoreCase("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KRDFIndexer") && (!indexerClassName.equalsIgnoreCase("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KRispIndexer") || !generateRispFiles)) continue;
                        isOpendata = true;
                        break;
                    }
                    if (!isOpendata) continue;
                    break;
                }
                if (isOpendata || (srchIndexers = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(this.getTypo().getClusterOid(), this.getTypo().getFamilyOid(), this.getTypo().getTypeOid()).getTypoIndexer()) == null) break block7;
                for (R01MSearchSourceIndexer indexer : srchIndexers) {
                    String indexerClassName = indexer.getImplClassName();
                    if (!indexerClassName.equalsIgnoreCase("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDCATIndexer") && !indexerClassName.equalsIgnoreCase("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KRDFIndexer") && (!indexerClassName.equalsIgnoreCase("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KRispIndexer") || !generateRispFiles)) continue;
                    isOpendata = true;
                    break;
                }
            }
            catch (R01MConfigLoadException r01MConfigLoadException) {
                // empty catch block
            }
        }
        return isOpendata;
    }

    @Override
    public void validateObject() throws R01MContentModelObjectsValidatorException {
        if (this.storeLocation == null || this.typo == null || this.newnessUntilDate == null) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContent] Los atributos (oid,name,storeLocation,chargePerson,newnessUntilDate) son obligatorios.");
        }
        if (StringUtils.isEmptyString((String)this.oid) || this.oid.length() > 50) {
            throw new R01MContentModelObjectsValidatorException(2L, "[Object R01MContent(" + this.oid + ")][Attribute oid] 0 < tama\u00f1o <= 50.");
        }
        if (StringUtils.isEmptyString((String)this.name) || this.name.length() > 30) {
            throw new R01MContentModelObjectsValidatorException(3L, "[Object R01MContent(" + this.oid + ")][Attribute name] 0 < tama\u00f1o <= 30.");
        }
        if (this.description != null && this.description.length() > 255) {
            throw new R01MContentModelObjectsValidatorException(4L, "[Object R01MContent(" + this.oid + ")][Attribute description] tama\u00f1o <= 255.");
        }
        if (this.author != null && this.author.length() > 75) {
            throw new R01MContentModelObjectsValidatorException(5L, "[Object R01MContent(" + this.oid + ")][Attribute author] tama\u00f1o <= 75.");
        }
        if (StringUtils.isEmptyString((String)this.chargePerson) || this.chargePerson.length() > 75) {
            throw new R01MContentModelObjectsValidatorException(6L, "[Object R01MContent(" + this.oid + ")][Attribute chargePerson] 0 < tama\u00f1o <= 75.");
        }
        if (this.source != null && this.source.length() > 50) {
            throw new R01MContentModelObjectsValidatorException(7L, "[Object R01MContent(" + this.oid + ")][Attribute source] tama\u00f1o <= 50.");
        }
        if (this.portalDataSEOName != null && this.portalDataSEOName.length() > 255) {
            throw new R01MContentModelObjectsValidatorException(7L, "[Object R01MContent(" + this.oid + ")][Attribute portalDataSEOName] tama\u00f1o <= 255.");
        }
        if (this.portalDataSEODescription != null && this.portalDataSEODescription.length() > 4000) {
            throw new R01MContentModelObjectsValidatorException(7L, "[Object R01MContent(" + this.oid + ")][Attribute portalDataSEODescription] tama\u00f1o <= 4000.");
        }
        if (!this._isValidName(this.name)) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MContent(" + this.oid + ")][Attribute name] Debe ser caracteres en min\u00fasculas, n\u00fameros y gui\u00f3n bajo. Ej:cont_2_ad.");
        }
        this.storeLocation.validateObject();
        this.typo.validateObject();
        if (this.documents != null && !this.documents.isEmpty()) {
            for (Map.Entry<String, R01MBaseDocumentInterface> me : this.documents.entrySet()) {
                if (!(me.getValue() instanceof R01MDocument)) continue;
                R01MDocument document = (R01MDocument)me.getValue();
                if (document != null) {
                    document.validateObject();
                    continue;
                }
                throw new R01MContentModelObjectsValidatorException("[Object R01MContent(" + this.oid + ")][Attribute documents] Contiene valores NULL.");
            }
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            for (int i = 0; i < this.labels.size(); ++i) {
                R01MStructureCatalog label = this.labels.get(i);
                if (label == null) {
                    throw new R01MContentModelObjectsValidatorException("[Object R01MContent(" + this.oid + ")][Attribute labels] Contiene valores NULL.");
                }
                label.validateObject();
            }
        }
        if (this.geoPicks != null && !this.geoPicks.getGeopicks().isEmpty()) {
            for (R01MGeoPick geoCatalog : this.geoPicks.getGeopicks()) {
                if (geoCatalog != null) {
                    geoCatalog.getGeocode().validateObject();
                    continue;
                }
                throw new R01MContentModelObjectsValidatorException("[Object R01MContent(" + this.oid + ")][Attribute geoPicks] Contiene valores NULL.");
            }
        }
    }

    private boolean _isDocumentPublishedInAnyRepository(R01MDocument document) {
        boolean isPublished = false;
        List<R01MDocumentPublicationTarget> publications = document.getPublicationInfo();
        if (publications != null && !publications.isEmpty()) {
            HashMap<String, R01MDocumentPublicationTarget> newestPublicationsByTarget = new HashMap<String, R01MDocumentPublicationTarget>();
            for (R01MDocumentPublicationTarget publication : publications) {
                if (newestPublicationsByTarget.keySet().contains(publication.getOid())) {
                    if (!((R01MDocumentPublicationTarget)newestPublicationsByTarget.get(publication.getOid())).getPublishDate().before(publication.getPublishDate())) continue;
                    newestPublicationsByTarget.put(publication.getOid(), publication);
                    continue;
                }
                newestPublicationsByTarget.put(publication.getOid(), publication);
            }
            if (!newestPublicationsByTarget.isEmpty()) {
                Iterator itPublications = newestPublicationsByTarget.values().iterator();
                while (itPublications.hasNext()) {
                    if (((R01MDocumentPublicationTarget)itPublications.next()).getState() != 1) continue;
                    isPublished = true;
                    break;
                }
            }
        }
        return isPublished;
    }

    private boolean _isDocumentPublishedInSpecifiedRepository(R01MDocument document, String repoPub) {
        boolean isPublished = false;
        List<R01MDocumentPublicationTarget> publications = document.getPublicationInfo();
        if (publications != null && !publications.isEmpty()) {
            R01MBasePublicationTarget publication = null;
            for (R01MDocumentPublicationTarget currentPublication : publications) {
                if (!currentPublication.getOid().equals(repoPub) || publication != null && !publication.getPublishDate().before(currentPublication.getPublishDate())) continue;
                publication = currentPublication;
            }
            if (publication.getState() == 1) {
                isPublished = true;
            }
        }
        return isPublished;
    }

    private boolean _isValidName(String theName) {
        if (theName.indexOf(13) > 0 || theName.indexOf(10) > 0) {
            return false;
        }
        char[] cName = new char[50];
        theName.getChars(0, theName.length(), cName, 0);
        for (int i = 0; i < theName.length(); ++i) {
            if (Character.getNumericValue(cName[i]) >= 10 && Character.getNumericValue(cName[i]) <= 35 || Character.getNumericValue(cName[i]) >= 0 && Character.getNumericValue(cName[i]) <= 9 || String.valueOf(cName[i]).equals("_")) {
                if (Character.getNumericValue(cName[i]) < 10 || Character.getNumericValue(cName[i]) > 35 || !Character.isUpperCase(cName[i])) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

