/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.cataloguing.structures;

import com.ejie.r01f.util.StateMap;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MCatalogModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MPrintableInterface;
import com.ejie.r01m.objects.cataloguing.structures.R01MRelation;
import com.ejie.r01m.objects.cataloguing.structures.R01MValidateCataloguingInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class R01MStructureItem
implements Serializable,
R01MValidateCataloguingInterface,
R01MPrintableInterface {
    private static final long serialVersionUID = -8805143727227093981L;
    public static final String SALTO_LINEA = "\r\n";
    public static final String NULL_VALUE = "null";
    private int relationId;
    private int relationParentId;
    private int rootLabelId;
    private String rootLabelOid;
    private int childLabelId;
    private String structureGuid;
    private int structureId;
    private R01MStructureItem parent = null;
    private Map children = new StateMap();
    private int role = -1;
    private List similarLabels;
    private String childLabelPath;
    private String standarizedTermInLanguage;
    private String labelDescription;
    private boolean hasChildren = false;

    public R01MStructureItem getParent() {
        return this.parent;
    }

    public void setParent(R01MStructureItem theParent) {
        this.parent = theParent;
    }

    public Map getChildren() {
        return this.children;
    }

    public void setChildren(Map theChildren) {
        this.children = theChildren;
    }

    public String getStructureGuid() {
        return this.structureGuid;
    }

    public void setStructureGuid(String theStructureGuid) {
        this.structureGuid = theStructureGuid;
    }

    public int getStructureId() {
        return this.structureId;
    }

    public void setStructureId(int theStructureId) {
        this.structureId = theStructureId;
    }

    public int getRole() {
        return this.role;
    }

    public void setRole(int theRole) {
        this.role = theRole;
    }

    public List getSimilarLabels() {
        return this.similarLabels;
    }

    public void setSimilarLabels(List theSimilarLabels) {
        this.similarLabels = theSimilarLabels;
    }

    public String getChildLabelPath() {
        return this.childLabelPath;
    }

    public void setChildLabelPath(String theChildLabelPath) {
        this.childLabelPath = theChildLabelPath;
    }

    public boolean hasSimilarLabels() {
        return !this.similarLabels.isEmpty();
    }

    public void addChild(R01MStructureItem child) {
        this.children.put(child.getRootLabelOid(), child);
    }

    public void addSimilarLabel(R01MStructureItem similar) {
        this.similarLabels.add("" + similar.getRootLabelId());
    }

    public List getChildrenGUIDs() {
        ArrayList<String> childrenGUIDs = new ArrayList<String>();
        Iterator childrenIterator = this.getChildren().keySet().iterator();
        childrenGUIDs.add(this.getRootLabelOid());
        if (this.hasChildren()) {
            while (childrenIterator.hasNext()) {
                R01MStructureItem st = (R01MStructureItem)this.getChildren().get(childrenIterator.next());
                childrenGUIDs.addAll(st.getChildrenGUIDs());
            }
        }
        return childrenGUIDs;
    }

    public List getChildrenRelations() {
        ArrayList<R01MRelation> childrenRelations = new ArrayList<R01MRelation>();
        if (this.hasChildren()) {
            Iterator childrenIterator = this.getChildren().keySet().iterator();
            while (childrenIterator.hasNext()) {
                R01MStructureItem st = (R01MStructureItem)this.getChildren().get(childrenIterator.next());
                childrenRelations.addAll(st.getChildrenRelations());
            }
            if (this.getParent() == null) {
                childrenRelations.add(new R01MRelation(0, this.getRootLabelId(), 'H'));
            } else {
                childrenRelations.add(new R01MRelation(this.getParent().getRootLabelId(), this.getRootLabelId(), 'H'));
            }
        } else if (this.getParent() == null) {
            childrenRelations.add(new R01MRelation(0, this.getRootLabelId(), 'H'));
        } else {
            childrenRelations.add(new R01MRelation(this.getParent().getRootLabelId(), this.getRootLabelId(), 'H'));
        }
        return childrenRelations;
    }

    public int getRelationId() {
        return this.relationId;
    }

    public void setRelationId(int theRelationId) {
        this.relationId = theRelationId;
    }

    public int getRelationParentId() {
        return this.relationParentId;
    }

    public void setRelationParentId(int theRelationParentId) {
        this.relationParentId = theRelationParentId;
    }

    public int getRootLabelId() {
        return this.rootLabelId;
    }

    public void setRootLabelId(int theRootLabelId) {
        this.rootLabelId = theRootLabelId;
    }

    public String getRootLabelOid() {
        return this.rootLabelOid;
    }

    public void setRootLabelOid(String theRootLabelOid) {
        this.rootLabelOid = theRootLabelOid;
    }

    public int getChildLabelId() {
        return this.childLabelId;
    }

    public void setChildLabelId(int theChildLabelId) {
        this.childLabelId = theChildLabelId;
    }

    public String getStandarizedTermInLanguage() {
        return this.standarizedTermInLanguage;
    }

    public void setStandarizedTermInLanguage(String theStandarizedTermInLanguage) {
        this.standarizedTermInLanguage = theStandarizedTermInLanguage;
    }

    public String getLabelDescription() {
        return this.labelDescription;
    }

    public void setLabelDescription(String theLabelDescription) {
        this.labelDescription = theLabelDescription;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean theHasChildren) {
        this.hasChildren = theHasChildren;
    }

    @Override
    public void validateObject() throws R01MCatalogModelObjectsValidatorException {
        if (this.structureGuid == null) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MStructureItem] El atributo (structureGuid) es obligatorio.");
        }
        if (!StringUtils.isEmptyString((String)this.structureGuid) && this.structureGuid.length() > 50) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MStructureItem(" + this.structureGuid + ")][Attribute structureGuid] 0 < tama\u00f1o <= 50.");
        }
        if (this.children != null && !this.children.isEmpty()) {
            for (R01MStructureItem structureItem : this.children.values()) {
                if (structureItem != null) {
                    structureItem.validateObject();
                    continue;
                }
                throw new R01MCatalogModelObjectsValidatorException("[Object R01MStructureItem(" + this.structureGuid + ")][Attribute children] Contiene valores NULL.");
            }
        }
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        String tabPrefix = prefix + "\t";
        StringBuffer sb = new StringBuffer(163);
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("======== R01MStructureItem  ========\r\n");
        sb.append(prefix);
        sb.append("\tStructureId:");
        sb.append(this.getStructureId());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tStructureGuid:");
        sb.append(this.getStructureGuid() == null ? NULL_VALUE : this.getStructureGuid());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tStandarizedTermInLanguage:");
        sb.append(this.getStandarizedTermInLanguage() == null ? NULL_VALUE : this.getStandarizedTermInLanguage());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tLabelDescription:");
        sb.append(this.getLabelDescription() == null ? NULL_VALUE : this.getLabelDescription());
        sb.append(SALTO_LINEA);
        if (this.getSimilarLabels() != null && !this.getSimilarLabels().isEmpty()) {
            sb.append(prefix);
            sb.append("\tSimilarLabels:\r\n");
            for (Map.Entry entry : this.getSimilarLabels()) {
                sb.append(tabPrefix);
                sb.append(((R01MStructureItem)entry.getValue()).debugInfo(tabPrefix));
                sb.append(SALTO_LINEA);
            }
        }
        sb.append(prefix);
        sb.append("\tRelationParentId:");
        sb.append(this.getRelationParentId());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tRelationId:");
        sb.append(this.getRelationId());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tRootLabelId:");
        sb.append(this.getRootLabelId());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tRootLabelOid:");
        sb.append(this.getRootLabelOid() == null ? NULL_VALUE : this.getRootLabelOid());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tRole:");
        sb.append(this.getRole());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tParent:");
        sb.append(this.getParent() == null ? NULL_VALUE : this.getParent().debugInfo(tabPrefix).toString());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tHasChildren:");
        sb.append(this.hasChildren());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tChildLabelId:");
        sb.append(this.getChildLabelId());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tChildLabelPath:");
        sb.append(this.getChildLabelPath() == null ? NULL_VALUE : this.getChildLabelPath());
        sb.append(SALTO_LINEA);
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            sb.append(prefix);
            sb.append("\tChildren (");
            sb.append(this.getChildren().size());
            sb.append("):\r\n");
            for (Map.Entry entry : this.getChildren().entrySet()) {
                sb.append(tabPrefix);
                sb.append(((R01MStructureItem)entry.getValue()).getStandarizedTermInLanguage());
                sb.append(SALTO_LINEA);
            }
        }
        return sb;
    }
}

