/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.cataloguing.structures;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MCatalogModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MPrintableInterface;
import com.ejie.r01m.objects.cataloguing.structures.R01MValidateCataloguingInterface;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class R01MStructureDefinition
implements Serializable,
R01MValidateCataloguingInterface,
R01MPrintableInterface {
    private static final long serialVersionUID = -7722810419048309536L;
    public static final String SALTO_LINEA = "\r\n";
    public static final String NULL_VALUE = "null";
    public static final char STRUCTURE_EMPTY_CHAR = '\u0000';
    public static final char STRUCTURE_TYPE_AXIS = 'E';
    public static final char STRUCTURE_TYPE_GUIDE = 'G';
    public static final char STRUCTURE_STATUS_ENABLED = 'H';
    public static final char STRUCTURE_STATUS_DISABLED = 'D';
    private int structureId;
    private String structureGUID;
    private char structureType = (char)69;
    private String structureDescription = "";
    private String structureGroup = "";
    private Map structureNames = new HashMap();
    private int bagId = -1;
    private char structureState = (char)68;

    public R01MStructureDefinition() {
        try {
            this.structureGUID = R01MUtils.generateNewOid(R01MConstants.STRUCTURES_APPCODE);
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.structureGUID = null;
        }
    }

    public int getBagId() {
        return this.bagId;
    }

    public void setBagId(int theBagId) {
        this.bagId = theBagId;
    }

    public String getStructureDescription() {
        return this.structureDescription;
    }

    public void setStructureDescription(String theStructureDescription) {
        this.structureDescription = theStructureDescription;
    }

    public String getStructureGUID() {
        return this.structureGUID;
    }

    public void setStructureGUID(String theStructureGUID) {
        this.structureGUID = theStructureGUID;
    }

    public Map getStructureNames() {
        return this.structureNames;
    }

    public void setStructureNames(Map theStructureNames) {
        this.structureNames = theStructureNames;
    }

    public char getStructureState() {
        return this.structureState;
    }

    public void setStructureState(char theStructureState) {
        this.structureState = theStructureState;
    }

    public char getStructureType() {
        return this.structureType;
    }

    public void setStructureType(char theStructureType) {
        this.structureType = theStructureType;
    }

    public int getStructureId() {
        return this.structureId;
    }

    public void setStructureId(int theStructureId) {
        this.structureId = theStructureId;
    }

    public void setName(String name, String languageCode) {
        this.structureNames.put(languageCode, name);
    }

    public String getName(String languageCode) {
        String name = "**Sin t&eacute;rmino**";
        if (this.structureNames != null && !this.structureNames.isEmpty() && this.structureNames.containsKey(languageCode) && (name = (String)this.structureNames.get(languageCode)) == null) {
            name = "**Sin t&eacute;rmino**";
        }
        return name;
    }

    public String getStructureGroup() {
        return this.structureGroup;
    }

    public void setStructureGroup(String theStructureGroup) {
        this.structureGroup = theStructureGroup;
    }

    @Override
    public void validateObject() throws R01MCatalogModelObjectsValidatorException {
        if (StringUtils.isEmptyString((String)this.structureGUID) || StringUtils.isEmptyString((String)String.valueOf(this.structureType)) || StringUtils.isEmptyString((String)String.valueOf(this.structureState))) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MStructureDefinition] Los atributos (bagGUID,structureType, structureState) son obligatorios.");
        }
        if (this.structureGUID.length() > 50) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MStructureDefinition(" + this.structureGUID + ")][Attribute oid] 0 < tama\u00f1o <= 50.");
        }
        if (!StringUtils.isEmptyString((String)this.structureDescription) && this.structureDescription.length() > 250) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MStructureDefinition(" + this.structureGUID + ")][Attribute description] 0 < tama\u00f1o <= 250.");
        }
        if (!StringUtils.isEmptyString((String)this.structureGroup) && this.structureGroup.length() > 100) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MStructureDefinition(" + this.structureGUID + ")][Attribute group] 0 < tama\u00f1o <= 100.");
        }
        if (this.structureNames != null && !this.structureNames.isEmpty()) {
            for (Map.Entry mapEntry : this.structureNames.entrySet()) {
                String idioma = (String)mapEntry.getKey();
                String name = (String)mapEntry.getValue();
                if (StringUtils.isEmptyString((String)idioma)) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MStructureDefinition] El idioma en un nombre de estructura es obligarotio");
                }
                if (idioma.length() > 3) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MStructureDefinition(" + this.structureGUID + ")][Attribute idioma] 0 < tama\u00f1o <= 3.");
                }
                if (StringUtils.isEmptyString((String)name)) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MStructureDefinition] El nombre de estructura es obligarotio");
                }
                if (name.length() <= 250) continue;
                throw new R01MCatalogModelObjectsValidatorException("[Object R01MStructureDefinition(" + this.structureGUID + ")][Attribute name] 0 < tama\u00f1o <= 250.");
            }
        }
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        String tabPrefix = prefix + "\t";
        StringBuffer sb = new StringBuffer(163);
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("======== R01MStructureDefinition  ========\r\n");
        sb.append(prefix);
        sb.append("\tBagId:");
        sb.append(this.getBagId());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tStructureId:");
        sb.append(this.getStructureId());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tStructureGUID:");
        sb.append(this.getStructureGUID() == null ? NULL_VALUE : this.getStructureGUID());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tgetStructureGroup:");
        sb.append(this.getStructureGroup() == null ? NULL_VALUE : this.getStructureGroup());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tStructureDescription:");
        sb.append(this.getStructureDescription() == null ? NULL_VALUE : this.getStructureDescription());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tStructureState:");
        sb.append(this.getStructureState());
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("\tgetStructureType:");
        sb.append(this.getStructureType());
        sb.append(SALTO_LINEA);
        if (this.getStructureNames() != null && !this.getStructureNames().isEmpty()) {
            sb.append(prefix);
            sb.append("\tNames:\r\n");
            Map.Entry me2 = null;
            for (Map.Entry me2 : this.getStructureNames().entrySet()) {
                sb.append(tabPrefix);
                sb.append('\t');
                sb.append(me2.getKey());
                sb.append('=');
                sb.append(me2.getValue());
                sb.append(SALTO_LINEA);
            }
        }
        return sb;
    }
}

