/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.cataloguing.structures;

import com.ejie.r01f.util.StateMap;
import com.ejie.r01m.exceptions.R01MCatalogModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MPrintableInterface;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureDefinition;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureItem;
import com.ejie.r01m.objects.cataloguing.structures.R01MValidateCataloguingInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class R01MStructure
implements Serializable,
R01MValidateCataloguingInterface,
R01MPrintableInterface {
    private static final long serialVersionUID = -658010022470457242L;
    public static final String SALTO_LINEA = "\r\n";
    public static final String NULL_VALUE = "null";
    private R01MStructureDefinition sDefinition = null;
    private Map structureItems = new StateMap();

    public R01MStructure() {
    }

    public R01MStructure(R01MStructureDefinition sDef) {
        this.sDefinition = sDef;
    }

    public void addStructureItem(R01MStructureItem newStructureItem) {
        this.structureItems.put(newStructureItem.getRootLabelOid(), newStructureItem);
    }

    public R01MStructureDefinition getSDefinition() {
        return this.sDefinition;
    }

    public void setSDefinition(R01MStructureDefinition definition) {
        this.sDefinition = definition;
    }

    public Map getStructuresItem() {
        return this.structureItems;
    }

    public void setStructuresItem(Map newStructuresItem) {
        this.structureItems = newStructuresItem;
    }

    public Map getStructureItems() {
        return this.structureItems;
    }

    public void setStructureItems(Map theStructureItems) {
        this.structureItems = theStructureItems;
    }

    public Collection findLabel(String labelOid) {
        if (this.structureItems == null) {
            return null;
        }
        ArrayList<R01MStructureItem> outStructureItems = new ArrayList<R01MStructureItem>();
        R01MStructureItem currItem2 = null;
        R01MStructureItem foundItem = null;
        for (R01MStructureItem currItem2 : this.structureItems.values()) {
            foundItem = this.findLableInSubBranch(currItem2, labelOid);
            if (foundItem == null) continue;
            outStructureItems.add(currItem2);
        }
        return outStructureItems;
    }

    public R01MStructureItem findLableInSubBranch(R01MStructureItem parentItem, String labelOid) {
        return this.findLabelInSubBranch(parentItem, labelOid);
    }

    public R01MStructureItem findLabelInSubBranch(R01MStructureItem parentItem, String labelOid) {
        if (parentItem.getRootLabelOid().equals(labelOid)) {
            return parentItem;
        }
        R01MStructureItem outItem = null;
        Iterator it = parentItem.getChildren().values().iterator();
        while (it.hasNext()) {
            outItem = this.findLableInSubBranch((R01MStructureItem)it.next(), labelOid);
            if (outItem == null) continue;
            return outItem;
        }
        return null;
    }

    @Override
    public void validateObject() throws R01MCatalogModelObjectsValidatorException {
        if (this.sDefinition == null) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MStructure] El atributo sDefinition es obligatorio.");
        }
        this.sDefinition.validateObject();
        if (this.structureItems != null && !this.structureItems.isEmpty()) {
            Iterator structuresItemIt = this.structureItems.values().iterator();
            while (structuresItemIt.hasNext()) {
                ((R01MStructureItem)structuresItemIt.next()).validateObject();
            }
        }
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        String tabPrefix = prefix + "\t";
        StringBuffer sb = new StringBuffer(163);
        sb.append(SALTO_LINEA);
        sb.append(prefix);
        sb.append("======== R01MStructure  ========\r\n");
        sb.append(prefix);
        sb.append("\tStructure definition:");
        sb.append(this.getSDefinition().debugInfo(tabPrefix));
        sb.append(SALTO_LINEA);
        if (this.getStructureItems() != null && !this.getStructureItems().isEmpty()) {
            sb.append(prefix);
            sb.append("\tStructureItems (");
            sb.append(this.getStructureItems().size());
            sb.append("):\r\n");
            Map.Entry me2 = null;
            for (Map.Entry me2 : this.getStructureItems().entrySet()) {
                sb.append(tabPrefix);
                sb.append(((R01MStructureItem)me2.getValue()).debugInfo(tabPrefix));
                sb.append(SALTO_LINEA);
            }
        }
        return sb;
    }
}

