/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.cataloguing.structures;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MCatalogModelObjectsValidatorException;
import com.ejie.r01m.objects.cataloguing.structures.R01MValidateCataloguingInterface;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.Serializable;

public class R01MRelation
implements Serializable,
R01MValidateCataloguingInterface {
    private static final long serialVersionUID = -515142853102618200L;
    public static final char RELATION_SIMILARITY_CODE = 'R';
    public static final char RELATION_HIERARCHY_CODE = 'H';
    private String relationGuid;
    private int labelId1;
    private int labelId2;
    private int relationId;
    private int relationParentId = 0;
    private char relationType = (char)72;
    private int structureId;
    private int order;
    private String termInLanguage = "";
    private boolean hasChildren = false;

    public R01MRelation() {
        try {
            this.relationGuid = R01MUtils.generateNewOid(R01MConstants.STRUCTURES_APPCODE);
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.relationGuid = null;
        }
    }

    public R01MRelation(int newLabelId1, int newLabelId2, char newRelationType) {
        this();
        this.labelId1 = newLabelId1;
        this.labelId2 = newLabelId2;
        this.relationType = newRelationType;
    }

    public R01MRelation(int newLabelId1, int newLabelId2, char newRelationType, int theStructureId, int theOrder) {
        this(newLabelId1, newLabelId2, newRelationType);
        this.structureId = theStructureId;
        this.order = theOrder;
    }

    public String getRelationGuid() {
        return this.relationGuid;
    }

    public void setRelationGuid(String theRelationGuid) {
        this.relationGuid = theRelationGuid;
    }

    public int getLabelId1() {
        return this.labelId1;
    }

    public void setLabelId1(int theLabelGuid1) {
        this.labelId1 = theLabelGuid1;
    }

    public int getLabelId2() {
        return this.labelId2;
    }

    public void setLabelId2(int theLabelGuid2) {
        this.labelId2 = theLabelGuid2;
    }

    public char getRelationType() {
        return this.relationType;
    }

    public void setRelationType(char theRelationType) {
        this.relationType = theRelationType;
    }

    public int getStructureId() {
        return this.structureId;
    }

    public void setStructureId(int theStructureId) {
        this.structureId = theStructureId;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int theOrder) {
        this.order = theOrder;
    }

    public int getRelationId() {
        return this.relationId;
    }

    public void setRelationId(int theRelationId) {
        this.relationId = theRelationId;
    }

    public int getRelationParentId() {
        return this.relationParentId;
    }

    public void setRelationParentId(int theRelationParentId) {
        this.relationParentId = theRelationParentId;
    }

    public String getTermInLanguage() {
        return this.termInLanguage;
    }

    public void setTermInLanguage(String theTermInLanguage) {
        this.termInLanguage = theTermInLanguage;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean theHasChildren) {
        this.hasChildren = theHasChildren;
    }

    @Override
    public void validateObject() throws R01MCatalogModelObjectsValidatorException {
        if (StringUtils.isEmptyString((String)Integer.toString(this.labelId1)) || StringUtils.isEmptyString((String)Integer.toString(this.labelId2)) || StringUtils.isEmptyString((String)this.relationGuid) || StringUtils.isEmptyString((String)String.valueOf(this.relationType)) || StringUtils.isEmptyString((String)Integer.toString(this.order)) || StringUtils.isEmptyString((String)Integer.toString(this.relationParentId))) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MRelation] Los atributos (labelId1,labelId2,relationGuid,relationType,order, relationParentId) son obligatorios.");
        }
        if (this.relationGuid.length() > 50) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MRelation(" + this.relationGuid + ")][Attribute oid] 0 < tama\u00f1o <= 50.");
        }
    }
}

