/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.cataloguing.structures;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MCatalogModelObjectsValidatorException;
import com.ejie.r01m.objects.cataloguing.structures.R01MTerm;
import com.ejie.r01m.objects.cataloguing.structures.R01MValidateCataloguingInterface;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class R01MLabel
implements Serializable,
R01MValidateCataloguingInterface {
    private static final long serialVersionUID = 3064906250948960952L;
    private int labelId;
    private String oid;
    private int bagId;
    private String description;
    private Map languageSynonyms = new HashMap();
    private Map<String, R01MTerm> standardizedTerms = new HashMap<String, R01MTerm>();
    private String extOID;

    public R01MLabel() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.STRUCTURES_APPCODE);
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.oid = null;
        }
    }

    public int getLabelId() {
        return this.labelId;
    }

    public void setLabelId(int theLabelId) {
        this.labelId = theLabelId;
    }

    public int getBagId() {
        return this.bagId;
    }

    public void setBagId(int theBagId) {
        this.bagId = theBagId;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String theOid) {
        this.oid = theOid;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public Map getLanguageSynonyms() {
        return this.languageSynonyms;
    }

    public Collection getLanguageSynonyms(String language) {
        return (Collection)this.languageSynonyms.get(language);
    }

    public void setLanguageSynonyms(Map theSynonyms) {
        this.languageSynonyms = theSynonyms;
    }

    public String getExtOID() {
        return this.extOID;
    }

    public void setExtOID(String theExtOID) {
        this.extOID = theExtOID;
    }

    public Map<String, R01MTerm> getStandardizedTerms() {
        return this.standardizedTerms;
    }

    public R01MTerm getStandardizedTerm(String language) throws R01MCatalogException {
        try {
            return this.standardizedTerms.get(language);
        }
        catch (NullPointerException nullEx) {
            throw new R01MCatalogException("No hay t\u00e9rmino en ese idioma");
        }
    }

    public String getStandarizedTermValue(String language) {
        String value = null;
        if (this.standardizedTerms != null && !this.standardizedTerms.isEmpty() && this.standardizedTerms.containsKey(language)) {
            try {
                R01MTerm mterm = this.getStandardizedTerm(language);
                value = mterm.getValue();
            }
            catch (R01MCatalogException ex) {
                value = "**Sin t&eacute;rmino**";
            }
            if (value == null) {
                value = "**Sin t&eacute;rmino**";
            }
        } else {
            value = "**Sin t&eacute;rmino**";
        }
        return value;
    }

    public void setStandardizedTerms(Map theStandardizedTerms) {
        this.standardizedTerms = theStandardizedTerms;
    }

    public void addStandardizedTerm(R01MTerm term) {
        String language = term.getLanguage();
        if (this.standardizedTerms.containsKey(language)) {
            term.setType('N');
            this.addLanguageSynonymous(term);
        } else {
            this.standardizedTerms.put(language, term);
        }
    }

    public void addLanguageSynonymous(R01MTerm term) {
        String language = term.getLanguage();
        Collection<R01MTerm> col = null;
        col = this.languageSynonyms.containsKey(language) ? (Collection)this.languageSynonyms.get(language) : new ArrayList<R01MTerm>();
        col.add(term);
        this.languageSynonyms.put(language, col);
    }

    public StringBuffer composeDebugInfo() {
        StringBuffer sb = new StringBuffer(29);
        sb.append("Oid=");
        sb.append(StringUtils.isEmptyString((String)this.getOid()) ? "" : this.getOid());
        sb.append(" no exists in the bag");
        sb.append("\r\n");
        return sb;
    }

    @Override
    public void validateObject() throws R01MCatalogModelObjectsValidatorException {
        if (StringUtils.isEmptyString((String)this.oid) || StringUtils.isEmptyString((String)Integer.toString(this.bagId)) || this.bagId == 0) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MLabel] Los atributos (oid,bagId) son obligatorios.");
        }
        if (this.oid.length() > 50) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MLabel(" + this.oid + ")][Attribute oid] 0 < tama\u00f1o <= 50.");
        }
        if (!StringUtils.isEmptyString((String)this.description) && this.description.length() > 250) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MLabel(" + this.oid + ")][Attribute description] 0 < tama\u00f1o <= 250.");
        }
        if (!StringUtils.isEmptyString((String)this.extOID) && this.extOID.length() > 250) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MLabel(" + this.oid + ")][Attribute extOID] 0 < tama\u00f1o <= 250.");
        }
        if (this.languageSynonyms != null && !this.languageSynonyms.isEmpty()) {
            for (Map.Entry entry : this.languageSynonyms.entrySet()) {
                Collection synonymus = (Collection)entry.getValue();
                if ((String)entry.getKey() == null) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MLabel] El idioma de un termino sin\u00f3nimo es obligarotio");
                }
                if (!StringUtils.isEmptyString((String)((String)entry.getKey())) && ((String)entry.getKey()).length() > 3) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MBagGroup(" + this.oid + ")][Attribute idioma termino sinonimo] 0 < tama\u00f1o <= 3.");
                }
                if (synonymus == null || synonymus.isEmpty()) continue;
                for (R01MTerm term : synonymus) {
                    if (term == null) continue;
                    term.validateObject();
                }
            }
        }
        if (this.standardizedTerms != null && !this.standardizedTerms.isEmpty()) {
            for (Map.Entry<String, R01MTerm> entry : this.standardizedTerms.entrySet()) {
                if (entry.getKey() == null) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MLabel] El idioma de un termino standard es obligarotio");
                }
                if (!StringUtils.isEmptyString((String)entry.getKey()) && entry.getKey().length() > 3) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MBagGroup(" + this.oid + ")][Attribute idioma termino standard] 0 < tama\u00f1o <= 3.");
                }
                entry.getValue().validateObject();
            }
        }
    }
}

