/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.cataloguing.structures;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MCatalogModelObjectsValidatorException;
import com.ejie.r01m.objects.cataloguing.structures.R01MBag;
import com.ejie.r01m.objects.cataloguing.structures.R01MValidateCataloguingInterface;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class R01MBagGroup
implements Serializable,
R01MValidateCataloguingInterface {
    private static final long serialVersionUID = -3008144987381636462L;
    public static final int EMPTY_ID = -1;
    private int id = -1;
    private String guid;
    private Map<String, String> descriptions;
    private Map<String, String> names;
    private List<R01MBag> belongBags;

    public R01MBagGroup() {
        try {
            this.guid = R01MUtils.generateNewOid(R01MConstants.STRUCTURES_APPCODE);
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.guid = null;
        }
    }

    public Map<String, String> getNames() {
        return this.names;
    }

    public String getName(String lang) {
        return this.names != null ? this.names.get(lang) : null;
    }

    public void setNames(Map<String, String> theNames) {
        this.names = theNames;
    }

    public void setName(String lang, String theName) {
        if (this.names == null) {
            this.names = new HashMap<String, String>();
        }
        this.names.put(lang, theName);
    }

    public List<R01MBag> getBelongBags() {
        return this.belongBags;
    }

    public void setBelongBags(List<R01MBag> theBelongBags) {
        this.belongBags = theBelongBags;
    }

    public R01MBag getBelongBag(String theBagId) {
        if (this.belongBags == null) {
            this.belongBags = new ArrayList<R01MBag>();
        }
        Iterator<R01MBag> bags = this.belongBags.iterator();
        R01MBag bagResult = null;
        while (bags.hasNext()) {
            R01MBag bag = bags.next();
            if (bag.getBagId() != Integer.parseInt(theBagId)) continue;
            bagResult = bag;
            break;
        }
        return bagResult;
    }

    public String getDescription(String lang) {
        return this.descriptions != null ? this.descriptions.get(lang) : null;
    }

    public void setDescription(String lang, String theDescription) {
        if (this.descriptions == null) {
            this.descriptions = new HashMap<String, String>();
        }
        this.descriptions.put(lang, theDescription);
    }

    public void setDescriptions(Map<String, String> theDescriptions) {
        this.descriptions = theDescriptions;
    }

    public Map<String, String> getDescriptions() {
        return this.descriptions;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int theId) {
        this.id = theId;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String theGUID) {
        this.guid = theGUID;
    }

    @Override
    public void validateObject() throws R01MCatalogModelObjectsValidatorException {
        String idioma;
        if (StringUtils.isEmptyString((String)this.guid)) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MBagGroup] El atributo guid es obligatorio.");
        }
        if (this.guid.length() > 50) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MBagGroup(" + this.guid + ")][Attribute guid] 0 < tama\u00f1o <= 50.");
        }
        if (this.descriptions != null && !this.descriptions.isEmpty()) {
            for (Map.Entry<String, String> entry : this.descriptions.entrySet()) {
                idioma = entry.getKey();
                String description = entry.getValue();
                if (idioma == null) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MBagGroup] El idioma en una descripcion es obligarotio");
                }
                if (!StringUtils.isEmptyString((String)idioma) && idioma.length() > 3) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MBagGroup(" + this.guid + ")][Attribute idioma description] 0 < tama\u00f1o <= 3.");
                }
                if (StringUtils.isEmptyString((String)description) || description.length() <= 250) continue;
                throw new R01MCatalogModelObjectsValidatorException("[Object R01MBagGroup(" + this.guid + ")][Attribute description] 0 < tama\u00f1o <= 250.");
            }
        }
        if (this.names != null && !this.names.isEmpty()) {
            for (Map.Entry entry : this.names.entrySet()) {
                idioma = (String)entry.getKey();
                String name = (String)entry.getValue();
                if (idioma == null) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MBagGroup] El idioma en un nombre de agrupaci\u00f3n es obligarotio");
                }
                if (!StringUtils.isEmptyString((String)idioma) && idioma.length() > 3) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MBagGroup(" + this.guid + ")][Attribute idioma name] 0 < tama\u00f1o <= 3.");
                }
                if (name == null) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MBagGroup] El nombre de agrupaci\u00f3n es obligarotio");
                }
                if (StringUtils.isEmptyString((String)name) || name.length() <= 250) continue;
                throw new R01MCatalogModelObjectsValidatorException("[Object R01MBagGroup(" + this.guid + ")][Attribute name] 0 < tama\u00f1o <= 250.");
            }
        }
        if (this.belongBags != null && !this.belongBags.isEmpty()) {
            for (R01MBag r01MBag : this.belongBags) {
                String bagid = String.valueOf(r01MBag.getBagId());
                if (StringUtils.isEmptyString((String)bagid)) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MBagGroup] EL ID de las bolsas pertenecientes a un grupo de bolsas es obligatorio");
                }
                if (NumberUtils.isNumber((String)bagid)) continue;
                throw new R01MCatalogModelObjectsValidatorException("[Object R01MBagGroup] EL ID de las bolsas pertenecientes a un grupo de bolsas debe ser num\u00e9rico");
            }
        }
    }
}

