/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.cataloguing.structures;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MCatalogModelObjectsValidatorException;
import com.ejie.r01m.objects.cataloguing.structures.R01MValidateCataloguingInterface;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class R01MBag
implements Serializable,
R01MValidateCataloguingInterface {
    private static final long serialVersionUID = -175346332137931316L;
    private int bagId;
    private String groupOid;
    private String bagDescription = "";
    private String bagGUID;
    private Map<String, String> bagNames = new Hashtable<String, String>();
    private List<String> belongStuctures;
    private String bagXlnetsUID = "";

    public R01MBag() {
        try {
            this.bagGUID = R01MUtils.generateNewOid(R01MConstants.STRUCTURES_APPCODE);
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.bagGUID = null;
        }
    }

    public String getBagDescription() {
        return this.bagDescription;
    }

    public void setBagDescription(String theBagDescription) {
        this.bagDescription = theBagDescription;
    }

    public String getBagGUID() {
        return this.bagGUID;
    }

    public void setBagGUID(String theBagGUID) {
        this.bagGUID = theBagGUID;
    }

    public Map<String, String> getBagNames() {
        return this.bagNames;
    }

    public List<String> getBelongStructures() {
        return this.belongStuctures;
    }

    public void setBelongStructures(List<String> theBelongStructures) {
        this.belongStuctures = theBelongStructures;
    }

    public void setBagNames(Map<String, String> theBagNames) {
        this.bagNames = theBagNames;
    }

    public String getBagXlnetsUID() {
        return this.bagXlnetsUID;
    }

    public void setBagXlnetsUID(String theBagXlnetsUID) {
        this.bagXlnetsUID = theBagXlnetsUID;
    }

    public void setName(String name, String languageCode) {
        this.bagNames.put(languageCode, name);
    }

    public String getName(String languageCode) {
        String name = "**Sin t&eacute;rmino**";
        if (this.bagNames != null && !this.bagNames.isEmpty() && this.bagNames.containsKey(languageCode)) {
            return this.bagNames.get(languageCode);
        }
        return name;
    }

    public int getBagId() {
        return this.bagId;
    }

    public void setBagId(int theBagId) {
        this.bagId = theBagId;
    }

    public String getGroupOid() {
        return this.groupOid;
    }

    public void setGroupOid(String theGroupOid) {
        this.groupOid = theGroupOid;
    }

    @Override
    public void validateObject() throws R01MCatalogModelObjectsValidatorException {
        if (StringUtils.isEmptyString((String)this.bagGUID) || StringUtils.isEmptyString((String)this.bagXlnetsUID)) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MBag] Los atributos (bagGUID,bagXlnetsUID) son obligatorios.");
        }
        if (this.bagGUID.length() > 50) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MBag(" + this.bagGUID + ")][Attribute bagGUID] 0 < tama\u00f1o <= 50.");
        }
        if (this.bagXlnetsUID.length() > 50) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MBag(" + this.bagGUID + ")][Attribute bagXlnetsUID] 0 < tama\u00f1o <= 50.");
        }
        if (!StringUtils.isEmptyString((String)this.bagDescription) && this.bagDescription.length() > 250) {
            throw new R01MCatalogModelObjectsValidatorException("[Object R01MBag(" + this.bagGUID + ")][Attribute bagDescription] 0 < tama\u00f1o <= 250.");
        }
        if (this.bagNames != null && !this.bagNames.isEmpty()) {
            for (Map.Entry<String, String> mapEntry : this.bagNames.entrySet()) {
                String idioma = mapEntry.getKey();
                String name = mapEntry.getValue();
                if (idioma == null) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MBag] El idioma en un nombre de bolsa es obligarotio");
                }
                if (name == null) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MBag] El valor en un nombre de bolsa es obligarotio");
                }
                if (!StringUtils.isEmptyString((String)name) && name.length() > 250) {
                    throw new R01MCatalogModelObjectsValidatorException("[Object R01MBag(" + this.bagGUID + ")][Attribute name] 0 < tama\u00f1o <= 250.");
                }
                if (StringUtils.isEmptyString((String)idioma) || idioma.length() <= 3) continue;
                throw new R01MCatalogModelObjectsValidatorException("[Object R01MBag(" + this.bagGUID + ")][Attribute idioma] 0 < tama\u00f1o <= 3.");
            }
        }
        if (this.belongStuctures != null && !this.belongStuctures.isEmpty()) {
            for (String structureOid : this.belongStuctures) {
                if (StringUtils.isEmptyString((String)structureOid) || structureOid.length() <= 50) continue;
                throw new R01MCatalogModelObjectsValidatorException("[Object R01MBag(" + this.bagGUID + ")][Attribute structureOid] 0 < tama\u00f1o <= 50.");
            }
        }
    }
}

