/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.cataloguing.picks;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeocode;
import com.ejie.r01m.objects.cataloguing.picks.R01MAccessibilityInfo;
import com.ejie.r01m.objects.cataloguing.picks.R01MContactInfo;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class R01MGeoPick
implements Serializable {
    private static final long serialVersionUID = -4254139076471572368L;
    private String oid;
    private R01MGeocode geocode;
    private List contacts;
    private R01MAccessibilityInfo accessibility;

    public R01MGeoPick() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.STRUCTURES_APPCODE);
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.oid = "error-unknown";
        }
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public R01MGeocode getGeocode() {
        return this.geocode;
    }

    public void setGeocode(R01MGeocode geocode) {
        this.geocode = geocode;
    }

    public List getContacts() {
        return this.contacts;
    }

    public void setContacts(List contacts) {
        this.contacts = contacts;
    }

    public R01MAccessibilityInfo getAccessibility() {
        return this.accessibility;
    }

    public void setAccessibility(R01MAccessibilityInfo accessibility) {
        this.accessibility = accessibility;
    }

    public void addContact(R01MContactInfo newContact) {
        if (this.getContacts() == null) {
            this.setContacts(new ArrayList(1));
        }
        this.getContacts().add(newContact);
    }
}

