/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.cataloguing.picks;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01m.objects.cataloguing.contact.R01MContactMail;
import com.ejie.r01m.objects.cataloguing.contact.R01MContactPhone;
import com.ejie.r01m.objects.cataloguing.contact.R01MContactSocialNetwork;
import com.ejie.r01m.objects.cataloguing.contact.R01MContactWeb;
import com.ejie.r01m.objects.cataloguing.contact.R01MPerson;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class R01MContactInfo
implements Serializable {
    private static final long serialVersionUID = 859558385024639382L;
    public String oid;
    private R01MPerson person;
    private List<R01MContactPhone> phones;
    private List<R01MContactSocialNetwork> socialNetworks;
    private List<R01MContactMail> mailAddresses;
    private List<R01MContactWeb> webSites;
    private boolean allDataIsPrivate;

    public R01MContactInfo() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.CONTENTMANAGER_APPCODE);
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.oid = "error-unknown";
        }
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public R01MPerson getPerson() {
        return this.person;
    }

    public void setPerson(R01MPerson person) {
        this.person = person;
    }

    public List<R01MContactPhone> getPhones() {
        return this.phones;
    }

    public void setPhones(List<R01MContactPhone> phones) {
        this.phones = phones;
    }

    public List<R01MContactSocialNetwork> getSocialNetworks() {
        return this.socialNetworks;
    }

    public void setSocialNetworks(List<R01MContactSocialNetwork> socialNetworks) {
        this.socialNetworks = socialNetworks;
    }

    public List<R01MContactMail> getMailAddresses() {
        return this.mailAddresses;
    }

    public void setMailAddresses(List<R01MContactMail> mailAddresses) {
        this.mailAddresses = mailAddresses;
    }

    public List<R01MContactWeb> getWebSites() {
        return this.webSites;
    }

    public void setWebSites(List<R01MContactWeb> webSites) {
        this.webSites = webSites;
    }

    public boolean isAllDataIsPrivate() {
        return this.allDataIsPrivate;
    }

    public void setAllDataIsPrivate(boolean allDataIsPrivate) {
        this.allDataIsPrivate = allDataIsPrivate;
    }

    public void addPhone(R01MContactPhone newPhone) {
        if (this.getPhones() == null) {
            this.setPhones(new ArrayList<R01MContactPhone>());
        }
        this.getPhones().add(newPhone);
    }

    public void addSocialNetwork(R01MContactSocialNetwork newSocialNetwork) {
        if (this.getSocialNetworks() == null) {
            this.setSocialNetworks(new ArrayList<R01MContactSocialNetwork>());
        }
        this.getSocialNetworks().add(newSocialNetwork);
    }

    public void addMailAddress(R01MContactMail newMail) {
        if (this.getMailAddresses() == null) {
            this.setMailAddresses(new ArrayList<R01MContactMail>());
        }
        this.getMailAddresses().add(newMail);
    }

    public void addWeb(R01MContactWeb newWeb) {
        if (this.getWebSites() == null) {
            this.setWebSites(new ArrayList<R01MContactWeb>());
        }
        this.getWebSites().add(newWeb);
    }
}

