/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.cataloguing.geo;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeoCountry;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeoCounty;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeoDistrict;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeoLocality;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeoLocation;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeoMunicipality;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeoRegion;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeoStreet;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeoStreetNumber;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeoTerritory;
import com.ejie.r01m.objects.contentmodel.R01MBaseContentModelObject;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.util.HashMap;
import java.util.Map;

public class R01MGeocode
extends R01MBaseContentModelObject {
    private static final long serialVersionUID = 4881706696190022932L;
    public static final int NORA = 0;
    public static final int GMAPS = 1;
    public String oid;
    private R01MGeoCountry country;
    private R01MGeoRegion region;
    private R01MGeoTerritory territory;
    private R01MGeoCounty county;
    private R01MGeoMunicipality municipality;
    private R01MGeoLocality locality;
    private R01MGeoDistrict district;
    private R01MGeoStreet street;
    private R01MGeoStreetNumber streetNumber;
    private String postCode;
    private Map address2;
    private Map title;
    private Map directions;
    private int locationSource = 0;
    private R01MGeoLocation location;

    public R01MGeocode() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.STRUCTURES_APPCODE);
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.oid = "error-unknown";
        }
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public R01MGeoCountry getCountry() {
        return this.country;
    }

    public void setCountry(R01MGeoCountry country) {
        this.country = country;
    }

    public R01MGeoRegion getRegion() {
        return this.region;
    }

    public void setRegion(R01MGeoRegion region) {
        this.region = region;
    }

    public R01MGeoTerritory getTerritory() {
        return this.territory;
    }

    public void setTerritory(R01MGeoTerritory territory) {
        this.territory = territory;
    }

    public R01MGeoCounty getCounty() {
        return this.county;
    }

    public void setCounty(R01MGeoCounty county) {
        this.county = county;
    }

    public R01MGeoMunicipality getMunicipality() {
        return this.municipality;
    }

    public void setMunicipality(R01MGeoMunicipality municipality) {
        this.municipality = municipality;
    }

    public R01MGeoLocality getLocality() {
        return this.locality;
    }

    public void setLocality(R01MGeoLocality locality) {
        this.locality = locality;
    }

    public R01MGeoDistrict getDistrict() {
        return this.district;
    }

    public void setDistrict(R01MGeoDistrict district) {
        this.district = district;
    }

    public R01MGeoStreet getStreet() {
        return this.street;
    }

    public void setStreet(R01MGeoStreet street) {
        this.street = street;
    }

    public R01MGeoStreetNumber getStreetNumber() {
        return this.streetNumber;
    }

    public void setStreetNumber(R01MGeoStreetNumber streetNumber) {
        this.streetNumber = streetNumber;
    }

    public R01MGeoLocation getLocation() {
        return this.location;
    }

    public void setLocation(R01MGeoLocation location) {
        this.location = location;
    }

    public Map getDirections() {
        return this.directions;
    }

    public void setDirections(Map directions) {
        this.directions = directions;
    }

    public Map getTitle() {
        return this.title;
    }

    public void setTitle(Map title) {
        this.title = title;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public Map getAddress2() {
        return this.address2;
    }

    public void setAddress2(Map address2) {
        this.address2 = address2;
    }

    public int getLocationSource() {
        return this.locationSource;
    }

    public void setLocationSource(int locationSource) {
        this.locationSource = locationSource;
    }

    public String composeMemoCode() {
        return this.country + "," + this.territory + "," + this.municipality;
    }

    public void putTitle(String lang, String theTitle) {
        if (this.getTitle() == null) {
            this.setTitle(new HashMap());
        }
        this.getTitle().put(lang, theTitle);
    }

    public void putAddress2(String lang, String theAddress2) {
        if (this.getAddress2() == null) {
            this.setAddress2(new HashMap());
        }
        this.getAddress2().put(lang, theAddress2);
    }

    public void putDirection(String lang, String theDirection) {
        if (this.getDirections() == null) {
            this.setDirections(new HashMap());
        }
        this.getDirections().put(lang, theDirection);
    }

    public String toAddress() {
        StringBuffer sb = new StringBuffer();
        if (this.territory != null && (this.territory.getId().equals("01") || this.territory.getId().equals("20") || this.territory.getId().equals("48")) && (this.municipality != null && this.locality == null && this.district == null || this.street != null)) {
            if (this.street != null) {
                sb.append(new StringBuffer().append("STREETNUMBER").append(":").toString());
                if (this.streetNumber != null && this.streetNumber.getId() != null) {
                    sb.append(this.streetNumber.getId());
                }
                sb.append(",").append(this.street.getId());
                sb.append(this.locality == null ? "" : "," + this.locality.getId());
            } else if (this.municipality != null) {
                sb.append(new StringBuffer().append("MUNICIPALITY").append(":").toString()).append(this.municipality.getId());
                sb.append(this.territory == null ? "" : "," + this.territory.getId());
                sb.append(this.region == null ? "" : "," + this.region.getId());
            }
        } else {
            if (this.street != null) {
                sb.append(this.street.getName()).append(",");
            }
            if (this.streetNumber != null) {
                sb.append(this.streetNumber.getName()).append(",");
            }
            if (this.locality != null) {
                sb.append(this.locality.getName()).append(",");
            }
            if (this.municipality != null) {
                sb.append(this.municipality.getName()).append(",");
            }
            if (this.territory != null) {
                sb.append(this.territory.getName()).append(",");
            }
            if (this.region != null) {
                sb.append(this.region.getName()).append(",");
            }
            if (this.country != null) {
                sb.append(this.country.getName());
            }
        }
        return sb.toString();
    }

    @Override
    public void validateObject() throws R01MContentModelObjectsValidatorException {
    }

    public StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(126);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== R01MGeocode ========\r\n");
        sb.append(prefix);
        sb.append("\tOid:");
        sb.append(this.getOid() == null ? "null" : this.getOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tCountryOid:");
        sb.append(this.getCountry() == null ? "null" : this.getCountry().getId().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tCountryName:");
        sb.append(this.getCountry() == null ? "null" : this.getCountry().getName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tRegionOid:");
        sb.append(this.getRegion() == null ? "null" : this.getRegion().getId().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tRegionName:");
        sb.append(this.getRegion() == null ? "null" : this.getRegion().getName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tTerritoryOid:");
        sb.append(this.getTerritory() == null ? "null" : this.getTerritory().getId().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tTerritoryName:");
        sb.append(this.getTerritory() == null ? "null" : this.getTerritory().getName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tCountyOid:");
        sb.append(this.getCounty() == null ? "null" : this.getCounty().getId().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tCountyName:");
        sb.append(this.getCounty() == null ? "null" : this.getCounty().getName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tMunicipalityOid:");
        sb.append(this.getMunicipality() == null ? "null" : this.getMunicipality().getId().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tMunicipalityName:");
        sb.append(this.getMunicipality() == null ? "null" : this.getMunicipality().getName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tLocalityOid:");
        sb.append(this.getLocality() == null ? "null" : this.getLocality().getId().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tLocalityName:");
        sb.append(this.getLocality() == null ? "null" : this.getLocality().getName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tDistrictOid:");
        sb.append(this.getDistrict() == null ? "null" : this.getDistrict().getId().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tDistrictName:");
        sb.append(this.getDistrict() == null ? "null" : this.getDistrict().getName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tStreetOid:");
        sb.append(this.getStreet() == null ? "null" : this.getStreet().getId().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tStreetName:");
        sb.append(this.getStreet() == null ? "null" : this.getStreet().getName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tStreetnumberOid:");
        sb.append(this.getStreetNumber() == null ? "null" : this.getStreetNumber().getId().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tStreetnumberName:");
        sb.append(this.getStreetNumber() == null ? "null" : this.getStreetNumber().getName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tLocation(Standard):");
        sb.append(this.getLocation() == null ? "null" : this.getLocation().getDatum().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tLocation(Latitude):");
        sb.append(this.getLocation() == null ? "null" : "" + this.getLocation().getLatitude());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tLocation(Longitude):");
        sb.append(this.getLocation() == null ? "null" : "" + this.getLocation().getLongitude());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tPostCode:");
        sb.append(this.getPostCode() == null ? "null" : "" + this.getPostCode());
        sb.append("\r\n");
        if (this.title != null && !this.title.isEmpty()) {
            for (Map.Entry me : this.title.entrySet()) {
                sb.append(prefix);
                sb.append("\tTitle(");
                sb.append(me.getKey());
                sb.append("):");
                sb.append(me.getValue());
                sb.append("\r\n");
            }
        }
        if (this.address2 != null && !this.address2.isEmpty()) {
            for (Map.Entry me : this.address2.entrySet()) {
                sb.append(prefix);
                sb.append("\tAddress2(");
                sb.append(me.getKey());
                sb.append("):");
                sb.append(me.getValue());
                sb.append("\r\n");
            }
        }
        if (this.directions != null && !this.directions.isEmpty()) {
            for (Map.Entry me : this.directions.entrySet()) {
                sb.append(prefix);
                sb.append("\tDirections(");
                sb.append(me.getKey());
                sb.append("):");
                sb.append(me.getValue());
                sb.append("\r\n");
            }
        }
        return sb;
    }
}

