/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.cataloguing;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MPrintableInterface;
import com.ejie.r01m.objects.contentmodel.R01MBaseContentModelObject;
import java.util.StringTokenizer;

public class R01MStructureCatalog
extends R01MBaseContentModelObject
implements R01MPrintableInterface,
Comparable {
    private static final long serialVersionUID = -2328414711758952555L;
    public String structureOid;
    public String oid;
    public String role;

    public R01MStructureCatalog() {
    }

    public R01MStructureCatalog(String newStructureOid, String newLabelOid, String newRole) {
        this.structureOid = newStructureOid;
        this.oid = newLabelOid;
        this.role = newRole;
    }

    public String composeMemoCode() {
        return this.structureOid + ";" + this.role + ";" + this.oid;
    }

    public void loadFromMemoCode(String memoCode) {
        if (memoCode == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(memoCode, ";");
        if (st.countTokens() != 3) {
            return;
        }
        int i = 0;
        while (st.hasMoreTokens()) {
            switch (i) {
                case 0: {
                    this.structureOid = st.nextToken();
                    break;
                }
                case 1: {
                    this.role = st.nextToken();
                    break;
                }
                case 2: {
                    this.oid = st.nextToken();
                    break;
                }
            }
            ++i;
        }
    }

    public String getKey() {
        return this.getOid() + ":" + this.getStructureOid();
    }

    public void setKey(String theKey) {
    }

    public String getStructureOid() {
        return this.structureOid;
    }

    public void setStructureOid(String theStructureOid) {
        this.structureOid = theStructureOid;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String theOid) {
        this.oid = theOid;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String theRole) {
        this.role = theRole;
    }

    @Override
    public void validateObject() throws R01MContentModelObjectsValidatorException {
        if (StringUtils.isEmptyString((String)this.structureOid) || this.structureOid.length() > 50) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MStructureCatalog] [Attribute structureOid] 0 < tama\u00f1o <= 50.");
        }
        if (StringUtils.isEmptyString((String)this.oid) || this.oid.length() > 50) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MStructureCatalog] [Attribute oid] 0 < tama\u00f1o <= 50.");
        }
        if (StringUtils.isEmptyString((String)this.role) || this.role.length() > 75) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MStructureCatalog] [Attribute role] 0 < tama\u00f1o <= 75.");
        }
    }

    public int compareTo(Object catalog) {
        R01MStructureCatalog otherCatalog = (R01MStructureCatalog)catalog;
        if (this.getStructureOid().equals(otherCatalog.getStructureOid()) && this.getOid().equals(otherCatalog.getOid()) && this.getRole().equals(otherCatalog.getRole())) {
            return 0;
        }
        return -1;
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(76);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== Label ========\r\n");
        sb.append(prefix);
        sb.append("\tStructureOid:");
        sb.append(this.getStructureOid() == null ? "null" : this.getStructureOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tLabelOid:");
        sb.append(this.getOid() == null ? "null" : this.getOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tRole:");
        sb.append(this.getRole() == null ? "null" : this.getRole());
        sb.append("\r\n");
        return sb;
    }
}

