/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects.cataloguing;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MMiscDataLoadException;
import com.ejie.r01m.objects.R01MPrintableInterface;
import com.ejie.r01m.objects.contentmodel.R01MBaseContentModelObject;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.util.StringTokenizer;

public class R01MGeoCatalog
extends R01MBaseContentModelObject
implements R01MPrintableInterface {
    private static final long serialVersionUID = -2390772773887162745L;
    public String oid;
    public Integer country;
    public String countryName = "";
    public Integer territory;
    public String territoryName = "";
    public Integer province;
    public String provinceName = "";
    public Integer municipality;
    public String municipalityName = "";
    public Integer city;
    public String cityName = "";
    public Integer street;
    public String streetName = "";

    public R01MGeoCatalog() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.CONTENTMANAGER_APPCODE, "content");
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.oid = "error-unknown";
        }
    }

    public String composeMemoCode() {
        return this.province + ";" + this.municipality;
    }

    public void loadFromMemoCode(String memoCode) {
        if (memoCode == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(memoCode, ";");
        if (st.countTokens() != 2) {
            return;
        }
        int i = 0;
        while (st.hasMoreTokens()) {
            switch (i) {
                case 0: {
                    this.province = new Integer(Integer.parseInt(st.nextToken()));
                    break;
                }
                case 1: {
                    this.municipality = new Integer(Integer.parseInt(st.nextToken()));
                    break;
                }
            }
            ++i;
        }
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String theOid) {
        this.oid = theOid;
    }

    public Integer getCity() {
        return this.city;
    }

    public void setCity(Integer theCity) {
        this.city = theCity;
    }

    public Integer getCountry() {
        return this.country;
    }

    public void setCountry(Integer theCountry) {
        this.country = theCountry;
    }

    public Integer getProvince() {
        return this.province;
    }

    public void setProvince(Integer theProvince) {
        this.province = theProvince;
    }

    public Integer getStreet() {
        return this.street;
    }

    public void setStreet(Integer theStreet) {
        this.street = theStreet;
    }

    public Integer getTerritory() {
        return this.territory;
    }

    public void setTerritory(Integer theTerritory) {
        this.territory = theTerritory;
    }

    public Integer getMunicipality() {
        return this.municipality;
    }

    public void setMunicipality(Integer theMunicipality) {
        this.municipality = theMunicipality;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String theCityName) {
        this.cityName = theCityName;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String theCountryName) {
        this.countryName = theCountryName;
    }

    public String getMunicipalityName() {
        return this.municipalityName;
    }

    public void setMunicipalityName(String theMunicipalityName) {
        this.municipalityName = theMunicipalityName;
    }

    public String getProvinceName() {
        return this.provinceName;
    }

    public void setProvinceName(String theProvinceName) {
        this.provinceName = theProvinceName;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String theStreetName) {
        this.streetName = theStreetName;
    }

    public String getTerritoryName() {
        return this.territoryName;
    }

    public void setTerritoryName(String theTerritoryName) {
        this.territoryName = theTerritoryName;
    }

    public String getcatalogationGeograficLabels() {
        StringBuffer labeles = new StringBuffer("");
        if (this.streetName != null && !this.streetName.equals("")) {
            labeles.append(this.streetName);
        } else {
            if (this.cityName != null && !this.cityName.equals("")) {
                labeles.append(this.cityName);
                labeles.append(" / ");
            }
            if (this.municipalityName != null && !this.municipalityName.equals("")) {
                labeles.append(this.municipalityName);
                labeles.append(" / ");
            }
            if (this.provinceName != null && !this.provinceName.equals("")) {
                labeles.append(this.provinceName);
            }
        }
        return labeles.toString();
    }

    @Override
    public void validateObject() throws R01MContentModelObjectsValidatorException {
        if (this.province == null || this.municipality == null) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MGeoCatalog] Los atributos (province, municipality) son obligatorios.");
        }
        if (this.province >= 100) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MGeoCatalog] El c\u00f3digo de provincia no existe.");
        }
        if (this.municipality >= 10000) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MGeoCatalog] El c\u00f3digo de municipio no existe.");
        }
        try {
            R01MClientFactory.getMiscellaneousAPI().loadProvinces("es").get(this.province);
        }
        catch (R01MMiscDataLoadException e) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MGeoCatalog] El c\u00f3digo de provincia no existe.");
        }
        try {
            R01MClientFactory.getMiscellaneousAPI().loadMunicipalities("es", this.province.toString()).get(this.municipality);
        }
        catch (R01MMiscDataLoadException e) {
            throw new R01MContentModelObjectsValidatorException("[Object R01MGeoCatalog] El c\u00f3digo de municipio no existe.");
        }
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(126);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== GeoLabel ========\r\n");
        sb.append(prefix);
        sb.append("\tOid:");
        sb.append(this.getOid() == null ? "null" : this.getOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tProvinceOid:");
        sb.append(this.getProvince() == null ? "null" : this.getProvince().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tProvinceName:");
        sb.append(this.getProvinceName() == null ? "null" : this.getProvinceName());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tMunicipalityOid:");
        sb.append(this.getMunicipality() == null ? "null" : this.getMunicipality().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tMunicipalityName:");
        sb.append(this.getMunicipalityName() == null ? "null" : this.getMunicipalityName());
        sb.append("\r\n");
        return sb;
    }
}

