/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.exceptions.R01MModelObjectsValidatorException;
import com.ejie.r01m.objects.portalmodel.R01MBasePortalModelObject;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MURLHelpper;
import com.ejie.r01m.utils.R01MUtils;

public class R01MURLAlias
extends R01MBasePortalModelObject {
    private static final long serialVersionUID = -1620552707887191546L;
    public static final int READY_TO_DELETE = 0;
    public static final int SAVED_IN_DB = 1;
    public static final int FILE_STRUCTURE_CREATED = 2;
    public static final int ALIAS_MAX_SIZE = Integer.parseInt(XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"aliasManagement/globalSizeLimit", (String)"2000"));
    public static final int FOLDER_MAX_SIZE = Integer.parseInt(XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"aliasManagement/folderSizeLimit", (String)"256"));
    public static final String ALL_LANGUAGES = "all";
    private String oid;
    private String alias;
    private String url;
    private String domain;
    private String lang = "all";
    private boolean baseAlias = false;

    public R01MURLAlias() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.API_APPCODE);
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.oid = "error-unknown";
        }
    }

    public R01MURLAlias(String newAlias, String newUrl, String newDomain, String newLang) {
        this();
        this.alias = newAlias != null ? newAlias.trim() : null;
        this.url = newUrl != null ? newUrl.trim() : null;
        this.domain = newDomain != null ? newDomain.trim() : null;
        this.lang = newLang != null ? newLang.trim() : null;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String theOid) {
        this.oid = theOid;
    }

    public void regenOid() {
        try {
            this.oid = R01MUtils.generateNewOid(R01MConstants.API_APPCODE);
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.oid = "error-unknown";
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String newAlias) {
        this.alias = newAlias != null ? newAlias.trim() : null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String newUrl) {
        this.url = newUrl != null ? newUrl.trim() : null;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String newDomain) {
        this.domain = newDomain != null ? newDomain.trim() : null;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String newLang) {
        this.lang = newLang != null ? newLang.trim() : ALL_LANGUAGES;
    }

    public boolean isBaseAlias() {
        return this.baseAlias;
    }

    public void setBaseAlias(boolean newBaseAlias) {
        this.baseAlias = newBaseAlias;
    }

    @Override
    public void validateObject() throws R01MModelObjectsValidatorException {
        if (StringUtils.isEmptyString((String)this.alias) || StringUtils.isEmptyString((String)this.url)) {
            throw new R01MModelObjectsValidatorException("[Object R01MURLAlias] Los atributos (alias,url) son obligatorios.");
        }
        this.alias = R01MURLHelpper.parseUrlAlias(this.alias);
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(118);
        sb.append("\r\n");
        sb.append(prefix).append("======== URL Alias ========\r\n");
        sb.append(prefix).append("\tOid:").append(this.getOid() == null ? "null" : this.getOid()).append("\r\n");
        sb.append(prefix).append("\tAlias:").append(this.getAlias() == null ? "null" : this.getAlias()).append("\r\n");
        sb.append(prefix).append("\tUrl:").append(this.getUrl() == null ? "null" : this.getUrl()).append("\r\n");
        sb.append(prefix).append("\tDomain:").append(this.getDomain() == null ? "null" : this.getDomain()).append("\r\n");
        sb.append(prefix).append("\tLang:").append(this.getLang() == null ? "null" : this.getLang()).append("\r\n");
        return sb;
    }
}

