/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects;

import com.ejie.r01m.exceptions.R01MModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MBaseObject;
import com.ejie.r01m.objects.R01MPrintableInterface;
import java.util.Calendar;
import java.util.Date;

public class R01MBasePublicationTarget
extends R01MBaseObject
implements R01MPrintableInterface {
    private static final long serialVersionUID = 119970521009922458L;
    public static final int STATE_UNPUBLISHED = 0;
    public static final int STATE_PUBLISHED = 1;
    public static final int STATE_FAILED_UNPUBLISHED = 2;
    public static final int STATE_FAILED_PUBLISHED = 3;
    public static final int STATE_PUBLISH_RUNNING = 4;
    public static final int STATE_UNPUBLISH_RUNNING = 5;
    public static final String[] PUBLICATION_STATE_LABELS = new String[]{"Despublicado", "Publicado", "Despublicado con errores", "Publicado con errores", "Publicaci\u00f3n en ejecuci\u00f3n", "Despublicacion en ejecuci\u00f3n"};
    protected String oid;
    protected String publicationOid;
    protected String url;
    protected Date publishDate = Calendar.getInstance().getTime();
    protected int state;
    protected int publisherConfirmation;

    public String getKey() {
        return this.oid + ":" + this.state;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String theOid) {
        this.oid = theOid;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String theUrl) {
        this.url = theUrl;
    }

    public Date getPublishDate() {
        return this.publishDate;
    }

    public void setPublishDate(Date thePublishDate) {
        this.publishDate = thePublishDate;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int theState) {
        this.state = theState;
    }

    public String getPublicationOid() {
        return this.publicationOid;
    }

    public void setPublicationOid(String thePublicationOid) {
        this.publicationOid = thePublicationOid;
    }

    public int getPublisherConfirmation() {
        return this.publisherConfirmation;
    }

    public void setPublisherConfirmation(int thePublisherConfirmation) {
        this.publisherConfirmation = thePublisherConfirmation;
    }

    public static String getPublicationStateLabel(int publicationState) {
        if (publicationState >= 0 && publicationState < 6) {
            return PUBLICATION_STATE_LABELS[publicationState];
        }
        return "Estado desconocido";
    }

    @Override
    public void validateObject() throws R01MModelObjectsValidatorException {
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(120);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== Publication ========\r\n");
        sb.append(prefix);
        sb.append("\tOid:");
        sb.append(this.getOid() == null ? "null" : this.getOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tState:");
        sb.append(this.getState());
        sb.append(" - ");
        if (this.getState() >= 0 && this.getState() < 6) {
            sb.append(PUBLICATION_STATE_LABELS[this.getState()]);
        } else {
            sb.append("Desconocido");
        }
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tUrl:");
        sb.append(this.getUrl() == null ? "null" : this.getUrl());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tPublishDate:");
        sb.append(this.getPublishDate() == null ? "null" : this.getPublishDate().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tPublisherConfirmation:");
        sb.append(this.publisherConfirmation);
        sb.append("\r\n");
        return sb;
    }
}

