/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects;

import com.ejie.r01m.exceptions.R01MModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MBaseObject;
import com.ejie.r01m.objects.R01MPrintableInterface;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class R01MBasePublicationRequested
extends R01MBaseObject
implements R01MPrintableInterface {
    private static final long serialVersionUID = 1430852176106784642L;
    public static final int PUBLICACION_INMEDIATA = 0;
    public static final int PUBLICACION_PROGRAMADA = 1;
    public static final int DESPUBLICACION_INMEDIATA = 2;
    public static final int DESPUBLICACION_PROGRAMADA = 3;
    public static final String[] PUBLICATION_TYPE_LABELS = new String[]{"Publicaci\u00f3n Inmediata", "Publicaci\u00f3n Programada", "Despublicaci\u00f3n Inmediata", "Despublicaci\u00f3n Programada"};
    protected String oid;
    protected String repositoryOid;
    protected Date operationDate = Calendar.getInstance().getTime();
    protected int operationType = 0;
    private String callbackUrl = null;
    private Map<String, String> callbackUrlParameters = null;

    public String getOid() {
        return this.oid;
    }

    public void setOid(String theOid) {
        this.oid = theOid;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public void setOperationType(int theOperationType) {
        this.operationType = theOperationType;
    }

    public Date getOperationDate() {
        return this.operationDate;
    }

    public void setOperationDate(Date theOperationDate) {
        this.operationDate = theOperationDate;
    }

    public String getRepositoryOid() {
        return this.repositoryOid;
    }

    public void setRepositoryOid(String theRepositoryOid) {
        this.repositoryOid = theRepositoryOid;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String theCallbackUrl) {
        this.callbackUrl = theCallbackUrl;
    }

    public Map<String, String> getCallbackUrlParameters() {
        return this.callbackUrlParameters;
    }

    public void setCallbackUrlParameters(Map<String, String> theCallbackUrlParameters) {
        this.callbackUrlParameters = theCallbackUrlParameters;
    }

    public static String getPublicationTypeLabel(int publicationType) {
        if (publicationType >= 0 && publicationType < 4) {
            return PUBLICATION_TYPE_LABELS[publicationType];
        }
        return "Tipo de publicaci\u00f3n desconocida";
    }

    @Override
    public void validateObject() throws R01MModelObjectsValidatorException {
    }

    @Override
    public StringBuffer debugInfo(String prefix) {
        StringBuffer sb = new StringBuffer(120);
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("======== PublicationRequested ========\r\n");
        sb.append(prefix);
        sb.append("\tOid:");
        sb.append(this.getOid() == null ? "null" : this.getOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tRepositoryOid:");
        sb.append(this.getRepositoryOid() == null ? "null" : this.getRepositoryOid());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tOperationDate:");
        sb.append(this.getOperationDate() == null ? "null" : this.getOperationDate().toString());
        sb.append("\r\n");
        sb.append(prefix);
        sb.append("\tOperationType:");
        sb.append(this.getOperationType());
        sb.append(" - ");
        if (this.getOperationType() >= 0 && this.getOperationType() < 4) {
            sb.append(PUBLICATION_TYPE_LABELS[this.getOperationType()]);
        }
        sb.append("\r\n");
        return sb;
    }
}

