/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.objects;

import com.ejie.r01m.exceptions.R01MModelObjectsValidatorException;
import com.ejie.r01m.objects.R01MBaseObject;
import java.util.StringTokenizer;

public abstract class R01MBaseLocationObject
extends R01MBaseObject {
    private static final long serialVersionUID = -6883177435210036091L;
    protected String serverOid;
    protected String dataRepositoryOid;
    protected String areaOid;
    protected String workAreaOid;

    public R01MBaseLocationObject() {
    }

    public R01MBaseLocationObject(String newServerOid, String newDataRepositoryOid, String newAreaOid, String newWorkAreaOid) {
        this();
        this.serverOid = newServerOid;
        this.dataRepositoryOid = newDataRepositoryOid;
        this.areaOid = newAreaOid;
        this.workAreaOid = newWorkAreaOid;
    }

    public StringBuffer composeDebugInfo() {
        StringBuffer sb = new StringBuffer(72);
        sb.append("\r\n\tServer   : ");
        sb.append(this.serverOid);
        sb.append("\r\n\tDataStore: ");
        sb.append(this.dataRepositoryOid);
        sb.append("\r\n\tArea     : ");
        sb.append(this.areaOid);
        sb.append("\r\n\tWorkArea : ");
        sb.append(this.workAreaOid);
        sb.append("\r\n");
        return sb;
    }

    public String composeMemoCode() {
        return this.serverOid + ":" + this.dataRepositoryOid + ":" + this.areaOid + ":" + this.workAreaOid;
    }

    public void loadFromMemoCode(String memoCode) {
        if (memoCode == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(memoCode, ":");
        if (st.countTokens() != 4) {
            return;
        }
        int i = 0;
        while (st.hasMoreTokens()) {
            switch (i) {
                case 0: {
                    this.serverOid = st.nextToken();
                    break;
                }
                case 1: {
                    this.dataRepositoryOid = st.nextToken();
                    break;
                }
                case 2: {
                    this.areaOid = st.nextToken();
                    break;
                }
                case 3: {
                    this.workAreaOid = st.nextToken();
                    break;
                }
            }
            ++i;
        }
    }

    public String getServerOid() {
        return this.serverOid;
    }

    public void setServerOid(String newServerOid) {
        this.serverOid = newServerOid;
    }

    public String getDataRepositoryOid() {
        return this.dataRepositoryOid;
    }

    public void setDataRepositoryOid(String newDataRepositoryOid) {
        this.dataRepositoryOid = newDataRepositoryOid;
    }

    public String getAreaOid() {
        return this.areaOid;
    }

    public void setAreaOid(String newAreaOid) {
        this.areaOid = newAreaOid;
    }

    public String getWorkAreaOid() {
        return this.workAreaOid;
    }

    public void setWorkAreaOid(String newWorkAreaOid) {
        this.workAreaOid = newWorkAreaOid;
    }

    @Override
    public void validateObject() throws R01MModelObjectsValidatorException {
    }
}

