/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.metadatamanager;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01m.config.objects.typology.R01MContentTypeMetaData;
import com.ejie.r01m.exceptions.R01MMetaDataManagerException;
import com.ejie.r01m.metadatamanager.R01MMetaDataManager;
import com.ejie.r01m.services.bzd.R01MMetaDataManagerBzd;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class R01MMetaDataManagerProxy
implements R01MMetaDataManagerBzd {
    private static Map _metaDataManagerInstancesCache;

    @Override
    public String[][] doLoadMetaDataValuesAndDescriptions(String lang, R01MContentTypeMetaData metaDataConfig) throws R01MMetaDataManagerException {
        if (metaDataConfig == null) {
            throw new R01MMetaDataManagerException("No se pueden cargar los valores del metaDato. La configuraci\u00f3n del metaDato suministrada es nula!");
        }
        if (metaDataConfig.getWidget() == null && !metaDataConfig.getWidget().equals("list") && !metaDataConfig.getWidget().equals("multipleList")) {
            throw new R01MMetaDataManagerException("El metaDato " + metaDataConfig.getOid() + " de tipo " + metaDataConfig.getWidget() + " NO es de tipo '" + "list" + "' o '" + "multipleList" + "'. No se pueden cargar los valores posibles!!!");
        }
        String effectiveLang = this._getLang(lang);
        R01FLog.to((String)"r01m.metaDataAPI").info("METADATA SERVER: Cargar los valores del metaDato " + metaDataConfig.getOid() + " en el lenguaje " + effectiveLang);
        R01MMetaDataManager manager = this._obtainManagerInstance(metaDataConfig);
        if (manager == null) {
            throw new R01MMetaDataManagerException("El metaDato " + metaDataConfig.getOid() + " de tipo " + metaDataConfig.getWidget() + " NO es de tipo '" + "list" + "' o '" + "multipleList" + "'. No se pueden cargar los valores posibles!!!");
        }
        Properties mgrProps = this._prepareManagerProperties(lang, metaDataConfig.getOid(), null, null, null);
        if (metaDataConfig.getValuesManager() != null && metaDataConfig.getValuesManager().getProperties() != null) {
            mgrProps.putAll((Map<?, ?>)metaDataConfig.getValuesManager().getProperties());
        }
        manager.setProperties(mgrProps);
        return manager.findAll(effectiveLang);
    }

    @Override
    public String[][] doLoadMetaDataValuesAndDescriptionsByRelatedMetaData(String lang, R01MContentTypeMetaData metaDataConfig, String metaDataValue, String relatedMetaDataOid, String relatedMetaDataValue) throws R01MMetaDataManagerException {
        if (metaDataConfig == null) {
            throw new R01MMetaDataManagerException("No se pueden cargar los valores del metaDato. La configuraci\u00f3n del metaDato suministrada es nula!");
        }
        if (metaDataConfig.getWidget() == null && !metaDataConfig.getWidget().equals("list") && !metaDataConfig.getWidget().equals("multipleList")) {
            throw new R01MMetaDataManagerException("El metaDato " + metaDataConfig.getOid() + " de tipo " + metaDataConfig.getWidget() + " NO es de tipo '" + "list" + "' o '" + "multipleList" + "'. No se pueden cargar los valores posibles!!!");
        }
        String effectiveLang = this._getLang(lang);
        R01FLog.to((String)"r01m.metaDataAPI").info("METADATA SERVER: Cargando los valores del metaDato " + metaDataConfig.getOid() + " en el lenguaje " + effectiveLang + " y filtrando por el valor " + relatedMetaDataValue + " del metaDato relaciondao " + relatedMetaDataOid);
        R01MMetaDataManager manager = this._obtainManagerInstance(metaDataConfig);
        Properties mgrProps = this._prepareManagerProperties(lang, metaDataConfig.getOid(), metaDataValue, relatedMetaDataOid, relatedMetaDataValue);
        if (metaDataConfig.getValuesManager().getProperties() != null) {
            mgrProps.putAll((Map<?, ?>)metaDataConfig.getValuesManager().getProperties());
        }
        manager.setProperties(mgrProps);
        return manager.findByRelatedMetaData(effectiveLang, relatedMetaDataOid, relatedMetaDataValue);
    }

    @Override
    public String doLoadMetaDataValueDescription(String lang, R01MContentTypeMetaData metaDataConfig, String metaDataValue) throws R01MMetaDataManagerException {
        if (metaDataValue == null) {
            throw new R01MMetaDataManagerException("No se puede cargar la descripcion de un valor de metaDatos null!!!");
        }
        if (metaDataConfig == null) {
            throw new R01MMetaDataManagerException("No se pueden cargar los valores del metaDato. La configuraci\u00f3n del metaDato suministrada es nula!");
        }
        if (metaDataConfig.getWidget() == null && !metaDataConfig.getWidget().equals("list") && !metaDataConfig.getWidget().equals("multipleList")) {
            throw new R01MMetaDataManagerException("El metaDato " + metaDataConfig.getOid() + " de tipo " + metaDataConfig.getWidget() + " NO es de tipo '" + "list" + "' o '" + "multipleList" + "'. No se pueden cargar los valores posibles!!!");
        }
        String effectiveLang = this._getLang(lang);
        R01FLog.to((String)"r01m.metaDataAPI").info("METADATA SERVER: Cargando la descripcion del metaDato " + metaDataConfig.getOid() + " con valor " + metaDataValue + " en el lenguaje " + effectiveLang);
        R01MMetaDataManager manager = this._obtainManagerInstance(metaDataConfig);
        if (manager == null) {
            return metaDataValue;
        }
        Properties mgrProps = this._prepareManagerProperties(lang, metaDataConfig.getOid(), metaDataValue, null, null);
        if (metaDataConfig.getValuesManager().getProperties() != null) {
            mgrProps.putAll((Map<?, ?>)metaDataConfig.getValuesManager().getProperties());
        }
        manager.setProperties(mgrProps);
        return manager.findByPrimaryKey(effectiveLang, metaDataValue);
    }

    private R01MMetaDataManager _obtainManagerInstance(R01MContentTypeMetaData metaDataCfg) throws R01MMetaDataManagerException {
        try {
            if (metaDataCfg.getValuesManager() == null) {
                return null;
            }
            R01MMetaDataManager manager = null;
            if (metaDataCfg.getValuesManager().isCacheManagerInstances() && _metaDataManagerInstancesCache != null) {
                R01FLog.to((String)"r01m.metaDataAPI").info("\tmanager del metaDato en cache: " + metaDataCfg.getValuesManager().getImplClassName());
                manager = (R01MMetaDataManager)_metaDataManagerInstancesCache.get(metaDataCfg.getOid());
            }
            if (manager == null) {
                manager = (R01MMetaDataManager)ReflectionUtils.getObjectInstance((String)metaDataCfg.getValuesManager().getImplClassName());
                if (manager == null) {
                    throw new R01MMetaDataManagerException("Se ha instanciado la clase que maneja un metaDato: " + metaDataCfg.getValuesManager().getImplClassName() + ">> Es null");
                }
                if (metaDataCfg.getValuesManager().isCacheManagerInstances()) {
                    if (_metaDataManagerInstancesCache == null) {
                        _metaDataManagerInstancesCache = new HashMap();
                    }
                    _metaDataManagerInstancesCache.put(metaDataCfg.getOid(), manager);
                }
            }
            return manager;
        }
        catch (ReflectionException refEx) {
            throw new R01MMetaDataManagerException("Error al instanciar la clase que maneja un metaDato: " + metaDataCfg.getValuesManager().getImplClassName() + " \u00bfTiene un constructor que acepta un Map como par\u00e1metro?", (Exception)((Object)refEx));
        }
        catch (ClassCastException ccEx) {
            throw new R01MMetaDataManagerException("La clase que maneja un metaDato: " + metaDataCfg.getValuesManager().getImplClassName() + " NO implementa el interfaz " + R01MMetaDataManagerProxy.class.getName());
        }
    }

    private Properties _prepareManagerProperties(String lang, String metaDataOid, String metaDataValue, String relatedMetaDataOid, String relatedMetaDataValue) {
        Properties outProps = new Properties();
        if (lang != null) {
            outProps.setProperty("lang", lang);
        }
        if (metaDataOid != null) {
            outProps.setProperty("metaDataOid", metaDataOid);
        }
        if (metaDataValue != null) {
            outProps.setProperty("metaDataValue", metaDataValue);
        }
        if (relatedMetaDataOid != null) {
            outProps.setProperty("relatedMetaDataOid", relatedMetaDataOid);
        }
        if (relatedMetaDataValue != null) {
            outProps.setProperty("relatedMetaDataValue", relatedMetaDataValue);
        }
        return outProps;
    }

    private String _getLang(String lang) {
        return lang == null ? "es" : lang;
    }
}

