/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.metadatamanager;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.sql.DBManager;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MMetaDataManagerException;
import com.ejie.r01m.metadatamanager.R01MMetaDataManager;
import com.ejie.r01m.utils.R01MConstants;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class R01MMetaDataManagerDefaultImpl
implements R01MMetaDataManager {
    private transient Properties properties = null;
    private static final String FINDER_FINDALL = "findAll";
    private static final String FINDER_FINDBYPRIMARYKEY = "findByPrimaryKey";
    private static final String FINDER_FINDBY = "findBy";
    private static final String COLNAME_OID = "metaDataValueColumnName";
    private static final String COLNAME_DESC = "metaDataValueDescriptionColumnName";
    private static final String DBCONNECTION_NAME = "contentQueryConnection";

    @Override
    public void setProperties(Properties props) {
        this.properties = props;
    }

    @Override
    public String[][] findAll(String lang) throws R01MMetaDataManagerException {
        String[][] outResults;
        block10: {
            List results;
            String valueDescColName;
            String valueColName;
            String findAllSQL;
            String finder;
            block9: {
                finder = "findAll_" + lang;
                findAllSQL = this.properties.getProperty(finder);
                if (findAllSQL == null) {
                    throw new R01MMetaDataManagerException("Error al cargar los valores del metaDato " + this.properties.getProperty("metaDataOid") + ". No se ha definido la propiedad <" + finder + ">[sql]</" + finder + "> en las propiedades del manager. Revisa la configuraci\u00f3n del metaDato!!!");
                }
                findAllSQL = StringUtils.replaceVariableValues((String)findAllSQL, (char)'$', (Map)this.properties);
                R01FLog.to((String)"r01m.metaDataAPI").info("\tMETADATA MANAGER: findAll > " + findAllSQL);
                valueColName = this.properties.getProperty(COLNAME_OID);
                if (valueColName == null) {
                    throw new R01MMetaDataManagerException("Error al cargar los valores del metaDato " + this.properties.getProperty("metaDataOid") + ". No se ha definido la propiedad <" + COLNAME_OID + ">[Nombre Columna OID]</" + COLNAME_OID + "> en las propiedades del manager. Revisa la configuraci\u00f3n del metaDato!!!");
                }
                valueDescColName = this.properties.getProperty("metaDataValueDescriptionColumnName_" + lang);
                if (valueDescColName == null) {
                    throw new R01MMetaDataManagerException("Error al cargar los valores del metaDato " + this.properties.getProperty("metaDataOid") + ". No se ha definido la propiedad <" + COLNAME_DESC + "_" + lang + ">[Nombre Columna con la descripcion]</" + COLNAME_DESC + "_" + lang + "> en las propiedades del manager. Revisa la configuraci\u00f3n del metaDato!!!");
                }
                results = this._executeQuery(lang, findAllSQL);
                outResults = null;
                if (results == null || results.size() <= 0) break block9;
                outResults = new String[results.size()][2];
                int i = 0;
                Map currRow2 = null;
                for (Map currRow2 : results) {
                    outResults[i][0] = (String)currRow2.get(valueColName);
                    outResults[i][1] = (String)currRow2.get(valueDescColName);
                    ++i;
                }
                break block10;
            }
            if (lang.equals(R01MConstants.DEFAULT_LANG)) break block10;
            finder = "findAll_" + R01MConstants.DEFAULT_LANG;
            findAllSQL = this.properties.getProperty(finder);
            if (findAllSQL == null) {
                throw new R01MMetaDataManagerException("Error al cargar los valores del metaDato " + this.properties.getProperty("metaDataOid") + ". No se ha definido la propiedad <" + finder + ">[sql]</" + finder + "> en las propiedades del manager. Revisa la configuraci\u00f3n del metaDato!!!");
            }
            findAllSQL = StringUtils.replaceVariableValues((String)findAllSQL, (char)'$', (Map)this.properties);
            R01FLog.to((String)"r01m.metaDataAPI").info("\tMETADATA MANAGER: findAll > " + findAllSQL);
            valueColName = this.properties.getProperty(COLNAME_OID);
            if (valueColName == null) {
                throw new R01MMetaDataManagerException("Error al cargar los valores del metaDato " + this.properties.getProperty("metaDataOid") + ". No se ha definido la propiedad <" + COLNAME_OID + ">[Nombre Columna OID]</" + COLNAME_OID + "> en las propiedades del manager. Revisa la configuraci\u00f3n del metaDato!!!");
            }
            valueDescColName = this.properties.getProperty("metaDataValueDescriptionColumnName_" + lang);
            if (valueDescColName == null) {
                throw new R01MMetaDataManagerException("Error al cargar los valores del metaDato " + this.properties.getProperty("metaDataOid") + ". No se ha definido la propiedad <" + COLNAME_DESC + "_" + lang + ">[Nombre Columna con la descripcion]</" + COLNAME_DESC + "_" + lang + "> en las propiedades del manager. Revisa la configuraci\u00f3n del metaDato!!!");
            }
            results = this._executeQuery(lang, findAllSQL);
            if (results != null && results.size() > 0) {
                outResults = new String[results.size()][2];
                int i = 0;
                Map currRow3 = null;
                for (Map currRow3 : results) {
                    outResults[i][0] = (String)currRow3.get(valueColName);
                    outResults[i][1] = (String)currRow3.get(valueDescColName);
                    ++i;
                }
            }
        }
        return outResults;
    }

    @Override
    public String findByPrimaryKey(String lang, String metaDataValue) throws R01MMetaDataManagerException {
        String finder = "findByPrimaryKey_" + lang;
        String findByPrimaryKeySQL = this.properties.getProperty(finder);
        if (findByPrimaryKeySQL == null) {
            throw new R01MMetaDataManagerException("Error al cargar los valores del metaDato " + this.properties.getProperty("metaDataOid") + ". No se ha definido la propiedad <" + finder + ">[sql]</" + finder + "> en las propiedades del manager. Revisa la configuraci\u00f3n del metaDato!!!");
        }
        Properties effectiveProps = new Properties();
        effectiveProps.putAll((Map<?, ?>)this.properties);
        effectiveProps.setProperty("metaDataValue", metaDataValue);
        findByPrimaryKeySQL = StringUtils.replaceVariableValues((String)findByPrimaryKeySQL, (char)'$', (Map)this.properties);
        R01FLog.to((String)"r01m.metaDataAPI").info("\tMETADATA MANAGER: findByPrimaryKey > " + findByPrimaryKeySQL);
        String valueDescColName = this.properties.getProperty("metaDataValueDescriptionColumnName_" + lang);
        if (valueDescColName == null) {
            throw new R01MMetaDataManagerException("Error al cargar los valores del metaDato " + this.properties.getProperty("metaDataOid") + ". No se ha definido la propiedad <" + COLNAME_DESC + "_" + lang + ">[Nombre Columna con la descripcion]</" + COLNAME_DESC + "_" + lang + "> en las propiedades del manager. Revisa la configuraci\u00f3n del metaDato!!!");
        }
        List results = this._executeQuery(lang, findByPrimaryKeySQL);
        String outResult = null;
        if (results != null) {
            Map currRow = (Map)results.get(0);
            outResult = (String)currRow.get(valueDescColName);
        }
        return outResult;
    }

    @Override
    public String[][] findByRelatedMetaData(String lang, String relatedMetaDataOid, String relatedMetaDataValue) throws R01MMetaDataManagerException {
        String finder = FINDER_FINDBY + StringUtils.capitalizeFirstLetter((String)relatedMetaDataOid) + "_" + lang;
        String findBySQL = this.properties.getProperty(finder);
        if (findBySQL == null) {
            throw new R01MMetaDataManagerException("Error al cargar los valores del metaDato " + this.properties.getProperty("metaDataOid") + ". No se ha definido la propiedad <" + finder + ">[sql]</" + finder + "> en las propiedades del manager. Revisa la configuraci\u00f3n del metaDato!!!");
        }
        Properties effectiveProps = new Properties();
        effectiveProps.putAll((Map<?, ?>)this.properties);
        effectiveProps.setProperty("relatedMetaDataOid", relatedMetaDataOid);
        effectiveProps.setProperty("relatedMetaDataValue", relatedMetaDataValue);
        findBySQL = StringUtils.replaceVariableValues((String)findBySQL, (char)'$', (Map)this.properties);
        R01FLog.to((String)"r01m.metaDataAPI").info("\tMETADATA MANAGER: " + finder + " > " + findBySQL);
        String valueColName = this.properties.getProperty(COLNAME_OID);
        if (valueColName == null) {
            throw new R01MMetaDataManagerException("Error al cargar los valores del metaDato " + this.properties.getProperty("metaDataOid") + ". No se ha definido la propiedad <" + COLNAME_OID + ">[Nombre Columna OID]</" + COLNAME_OID + "> en las propiedades del manager. Revisa la configuraci\u00f3n del metaDato!!!");
        }
        String valueDescColName = this.properties.getProperty("metaDataValueDescriptionColumnName_" + lang);
        if (valueDescColName == null) {
            throw new R01MMetaDataManagerException("Error al cargar los valores del metaDato " + this.properties.getProperty("metaDataOid") + ". No se ha definido la propiedad <" + COLNAME_DESC + "_" + lang + ">[Nombre Columna con la descripcion]</" + COLNAME_DESC + "_" + lang + "> en las propiedades del manager. Revisa la configuraci\u00f3n del metaDato!!!");
        }
        List results = this._executeQuery(lang, findBySQL);
        String[][] outResults = null;
        if (results != null) {
            outResults = new String[results.size()][2];
            int i = 0;
            Map currRow2 = null;
            for (Map currRow2 : results) {
                outResults[i][0] = (String)currRow2.get(valueColName);
                outResults[i][1] = (String)currRow2.get(valueDescColName);
                ++i;
            }
        }
        return outResults;
    }

    private List _executeQuery(String lang, String sql) throws R01MMetaDataManagerException {
        List results = null;
        try {
            DBManager dbMan = new DBManager(R01MConstants.SYSTEMADMINISTRATION_APPCODE, DBCONNECTION_NAME);
            results = dbMan.executeQuery(sql, null);
        }
        catch (SQLException sqlEx) {
            throw new R01MMetaDataManagerException("Error al ejecutar la query de obtenci\u00f3n de valores y descripciones de un metaDato: " + sqlEx.getMessage(), (Exception)sqlEx);
        }
        return results;
    }
}

