/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.datastore;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MDataStoreAuthenticationException;
import com.ejie.r01m.utils.R01MConstants;
import java.io.Serializable;

public class R01MDataStoreAuthObject
implements Serializable {
    private static final long serialVersionUID = -1537075250647596639L;
    private String appCode;
    private R01MUserContext userCtx;
    private String protocol;
    private String serviceDomainName;
    private String servicePortNumber;
    private String csFactoryClassName;
    private String csFactoryName;
    private String userOid = "";
    private String userRole = "";
    private String userPassword = "";

    public R01MDataStoreAuthObject() {
    }

    public R01MDataStoreAuthObject(String newAppCode) {
        this();
        this.appCode = newAppCode;
    }

    public R01MDataStoreAuthObject(R01MUserContext newUserCtx) {
        this();
        this.userCtx = newUserCtx;
    }

    public R01MDataStoreAuthObject(String newAppCode, R01MUserContext newUserCtx) {
        this(newAppCode);
        this.userCtx = newUserCtx;
    }

    public void fillAuthInfo(String theAppCode, R01MUserContext theUserCtx) throws R01MDataStoreAuthenticationException {
        this.appCode = theAppCode;
        this.userCtx = theUserCtx;
        R01MDataStoreAuthObject.readDataFromProperties(theAppCode, this);
    }

    public void readAuthorizationObject() throws R01MDataStoreAuthenticationException {
        R01MDataStoreAuthObject.readDataFromProperties(this.appCode, this);
    }

    private static void readDataFromProperties(String theAppCode, R01MDataStoreAuthObject authObj) throws R01MDataStoreAuthenticationException {
        String effectiveAppCode = theAppCode == null || StringUtils.isEmptyString((String)theAppCode) ? R01MConstants.API_APPCODE : theAppCode;
        String protocolo = XMLProperties.get((String)effectiveAppCode, (String)"contentServices/serviceBaseURL/protocol");
        if (protocolo == null) {
            throw new R01MDataStoreAuthenticationException("El protocolo de conexi\u00f3n a contentServices es nulo. Revisa el fichero " + effectiveAppCode + ".properties.xml");
        }
        authObj.setProtocol(protocolo);
        authObj.setServiceDomainName(XMLProperties.get((String)effectiveAppCode, (String)"contentServices/serviceBaseURL/hostName"));
        authObj.setServicePortNumber(XMLProperties.get((String)effectiveAppCode, (String)"contentServices/serviceBaseURL/port"));
        authObj.setCsFactoryClassName(XMLProperties.get((String)effectiveAppCode, (String)"contentServices/serviceFactory"));
        authObj.setCsFactoryName(effectiveAppCode + "AccessFactory");
        authObj.setUserOid(XMLProperties.get((String)effectiveAppCode, (String)"contentServices/clientAuthentication/userName"));
        authObj.setUserPassword(XMLProperties.get((String)effectiveAppCode, (String)"contentServices/clientAuthentication/userPassword"));
        authObj.setUserRole(XMLProperties.get((String)effectiveAppCode, (String)"contentServices/clientAuthentication/userRole"));
    }

    public String getAppCode() {
        return this.appCode;
    }

    public void setAppCode(String newAppCode) {
        this.appCode = newAppCode;
        this.setCsFactoryName(newAppCode + "AccessFactory");
    }

    public void setUserContext(R01MUserContext theUserCtx) {
        this.userCtx = theUserCtx;
    }

    public R01MUserContext getUserContext() {
        return this.userCtx;
    }

    public String getUserOid() {
        return this.userOid;
    }

    public void setUserOid(String newUserOid) {
        this.userOid = newUserOid;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String newUserPassword) {
        this.userPassword = newUserPassword;
    }

    public String getUserRole() {
        return this.userRole;
    }

    public void setUserRole(String newUserRole) {
        this.userRole = newUserRole;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String newProtocol) {
        this.protocol = newProtocol;
    }

    public String getServiceDomainName() {
        return this.serviceDomainName;
    }

    public void setServiceDomainName(String newServiceDomainName) {
        this.serviceDomainName = newServiceDomainName;
    }

    public String getServicePortNumber() {
        return this.servicePortNumber;
    }

    public void setServicePortNumber(String newServicePortNumber) {
        this.servicePortNumber = newServicePortNumber;
    }

    public String getServiceBaseURL() {
        if (this.getProtocol() != null && this.getServiceDomainName() != null && this.getServicePortNumber() != null) {
            return this.getProtocol() + "://" + this.getServiceDomainName() + ":" + this.getServicePortNumber();
        }
        return "Usage: protocol://serviceDomainName:servicePortNumber";
    }

    public String getCsFactoryClassName() {
        return this.csFactoryClassName;
    }

    public void setCsFactoryClassName(String newCsFactoryClassName) {
        this.csFactoryClassName = newCsFactoryClassName;
    }

    public String getCsFactoryName() {
        return this.csFactoryName;
    }

    private void setCsFactoryName(String newCsFactoryName) {
        this.csFactoryName = newCsFactoryName;
    }

    public R01MUserContext getUserCtx() {
        return this.userCtx;
    }

    public void setUserCtx(R01MUserContext theUserCtx) {
        this.userCtx = theUserCtx;
    }
}

