/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.context;

import com.ejie.r01m.utils.R01MConstants;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class R01MUserContext
implements Serializable {
    private static final long serialVersionUID = -3465373813153294670L;
    public static final String MASTER_USER_PROFILE = "masterSystem";
    private String userLang = R01MConstants.DEFAULT_LANG;
    private String userName;
    private String displayUserName;
    private String userProfile = "userSystem";
    private String userMail = "userMail";
    private Map userWorkAreas;
    private List userContentWorkAreasOids;
    private List userPortalWorkAreasOids;
    private List userBags;
    private Map userPortals;
    private String userPortalOid;
    private String userBagOid;

    public String composeDebugInfo() {
        StringBuffer sb = new StringBuffer(115);
        sb.append("\r\n\tUserName: ");
        sb.append(this.userName);
        sb.append("\r\n\tLanguage: ");
        sb.append(this.userLang);
        sb.append("\r\n\tRoles por WorkArea:");
        if (this.userWorkAreas != null) {
            Map.Entry me2 = null;
            for (Map.Entry me2 : this.userWorkAreas.entrySet()) {
                sb.append("\r\n\t");
                sb.append(me2.getKey());
                sb.append(" > ");
                sb.append(me2.getValue());
            }
        } else {
            sb.append("\r\n\t[No hay workAreas a las que el usuario tenga acceso]");
        }
        return sb.toString();
    }

    public String getUserLang() {
        return this.userLang;
    }

    public void setUserLang(String theUserLang) {
        this.userLang = theUserLang;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String theUserName) {
        this.userName = theUserName;
    }

    public String getDisplayUserName() {
        return this.displayUserName;
    }

    public void setDisplayUserName(String theUserName) {
        this.displayUserName = theUserName;
    }

    public String getUserMail() {
        return this.userMail;
    }

    public void setUserMail(String theUserMail) {
        this.userMail = theUserMail;
    }

    public Map getUserWorkAreas() {
        return this.userWorkAreas;
    }

    public void setUserWorkAreas(Map theWorkAreas) {
        this.userWorkAreas = theWorkAreas;
    }

    public List getUserContentWorkAreasOids() {
        return this.userContentWorkAreasOids;
    }

    public void setUserContentWorkAreasOids(List theUserContentWorkAreasOids) {
        this.userContentWorkAreasOids = theUserContentWorkAreasOids;
    }

    public Map getUserContentWorkAreas() {
        HashMap workareasAux = null;
        if (this.getUserContentWorkAreasOids() != null) {
            workareasAux = new HashMap();
            for (String currWorkareaOid : this.getUserWorkAreas().keySet()) {
                if (!this.getUserContentWorkAreasOids().contains(currWorkareaOid)) continue;
                workareasAux.put(currWorkareaOid, this.getUserWorkAreas().get(currWorkareaOid));
            }
        }
        return workareasAux;
    }

    public List getUserPortalWorkAreasOids() {
        return this.userPortalWorkAreasOids;
    }

    public void setUserPortalWorkAreasOids(List theUserPortalWorkAreasOids) {
        this.userPortalWorkAreasOids = theUserPortalWorkAreasOids;
    }

    public Map getUserPortalWorkAreas() {
        HashMap workareasAux = null;
        if (this.getUserPortalWorkAreasOids() != null) {
            workareasAux = new HashMap();
            for (String currWorkareaOid : this.getUserWorkAreas().keySet()) {
                if (!this.getUserPortalWorkAreasOids().contains(currWorkareaOid)) continue;
                workareasAux.put(currWorkareaOid, this.getUserWorkAreas().get(currWorkareaOid));
            }
        }
        return workareasAux;
    }

    public String getUserProfile() {
        return this.userProfile;
    }

    public boolean isMasterSystem() {
        return this.getUserProfile().equals(MASTER_USER_PROFILE);
    }

    public void setUserProfile(String theUserProfile) {
        this.userProfile = theUserProfile;
    }

    public List getUserBags() {
        return this.userBags;
    }

    public void setUserBags(List theUserBags) {
        this.userBags = theUserBags;
    }

    public Map getUserPortals() {
        return this.userPortals;
    }

    public void setUserPortals(Map theUserPortals) {
        this.userPortals = theUserPortals;
    }

    public String getUserPortalOid() {
        return this.userPortalOid;
    }

    public void setUserPortalOid(String theUserPortalOid) {
        this.userPortalOid = theUserPortalOid;
    }

    public String getUserBagOid() {
        return this.userBagOid;
    }

    public void setUserBagOid(String theUserBagOid) {
        this.userBagOid = theUserBagOid;
    }
}

