/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.context;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.servlet.filter.authorization.R01FAuthCfg;
import com.ejie.r01f.servlet.filter.authorization.R01FAuthCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FAuthFilterUtils;
import com.ejie.r01f.servlet.filter.authorization.R01FBaseAuthProvider;
import com.ejie.r01f.servlet.filter.authorization.R01FProfileCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FResourceAuthorization;
import com.ejie.r01f.servlet.filter.authorization.R01FResourceCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FTargetCfg;
import com.ejie.r01f.servlet.filter.authorization.R01FTargetCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FUserCtx;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.R01FProperties;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.storage.R01MArea;
import com.ejie.r01m.config.objects.storage.R01MDataRepository;
import com.ejie.r01m.config.objects.storage.R01MServer;
import com.ejie.r01m.config.objects.storage.R01MWorkArea;
import com.ejie.r01m.context.R01MRoleRights;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.cataloguing.structures.R01MBag;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.portalmodel.R01MPortal;
import com.ejie.r01m.services.R01MCatalogManagerAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MPortalConfigAPI;
import com.ejie.r01m.services.R01MStorageConfigAPI;
import com.ejie.r01m.utils.R01MConstants;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public abstract class R01MAuthManager
implements Serializable {
    private static final long serialVersionUID = 7498543592884327002L;
    private static final long TIMESTAMP_CHECKED_PERIOD = Long.parseLong(XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"checkTSperiod", (String)"600000"));
    private static long _lastCheckTS = 0L;
    private static final String SEARCHENGINE_CONTEXT = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"searchEngine/defaultSearchEngineContext", (String)"intranet");
    public static final String ROLE_MASTER = "AD";
    public static final String ROLE_EDITOR = "ED";
    public static final String ROLE_AUTHOR = "AU";
    public static final String ROLE_CATALG = "CA";
    public static final String ROLE_VISITR = "IN";
    public static final String AUTH_ACCESO = "AC";
    public static final String USER_CTX_SESSION = "userContextSession";
    public static String MASTER_PROFILE = R01FProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"security/masterProfile");
    private static Map<String, Integer> roleLevel;
    public static final int ACTION_SEE = 0;
    public static final int ACTION_CREATE = 1;
    public static final int ACTION_MODIFY = 2;
    public static final int ACTION_DELETE = 3;
    public static final int ACTION_CATALOG = 4;
    public static final int ACTION_REVISION_REQ = 5;
    public static final int ACTION_APROVE = 6;
    public static final int ACTION_TRANSLATE = 7;
    public static final int ACTION_MOVE = 8;
    private static R01MStorageConfigAPI _storageCfgApi;
    private static Map<String, R01FAuthCfg> _appSecurityCfgs;
    private static Map<String, R01MUserContext> _adminCtx;
    private static long _loadTS;

    private static synchronized void _reloadAdminCtx() {
        if (_lastCheckTS == 0L || _lastCheckTS + TIMESTAMP_CHECKED_PERIOD < System.currentTimeMillis()) {
            long loadTS = R01MClientFactory.getConfigLoadersTimingAPI().getLoadTimeStamp();
            _lastCheckTS = System.currentTimeMillis();
            if (loadTS > 0L && loadTS > _loadTS) {
                R01FLog.to((String)"r01m.loadConfigOnStartup").info("\r\n\r\n");
                R01FLog.to((String)"r01m.loadConfigOnStartup").info("//////////////////////////////////////////////////////////////////////////////////////////////////////\r\n");
                R01FLog.to((String)"r01m.loadConfigOnStartup").info("Se han actualizado los objetos de configuraci\u00f3n en el servidor y la cache del cliente ya NO es valida\r\n");
                R01FLog.to((String)"r01m.loadConfigOnStartup").info("//////////////////////////////////////////////////////////////////////////////////////////////////////\r\n");
                _adminCtx = new HashMap<String, R01MUserContext>();
                _loadTS = loadTS;
            }
        }
    }

    public static R01MUserContext createMasterSystemUserContext() throws R01MSecurityException {
        return R01MAuthManager.createMasterSystemUserContext("Administrator");
    }

    public static R01MUserContext createMasterSystemUserContext(String userName) throws R01MSecurityException {
        R01MAuthManager._reloadAdminCtx();
        if (!_adminCtx.containsKey(userName)) {
            _adminCtx.put(userName, R01MAuthManager._createNewMasterSystemUserContext(userName));
        }
        return _adminCtx.get(userName);
    }

    public static R01MUserContext createUserContextAppLogin(String appCode) throws R01MSecurityException {
        R01FLog.to((String)"r01m.security").info("LOGIN DE APLICACION: INICIO createUserContextAppLogin(" + appCode + ")");
        R01FAuthCfg authCfg = new R01FAuthCfg();
        if (_appSecurityCfgs.isEmpty() || _appSecurityCfgs.get(R01MConstants.API_APPCODE) == null) {
            authCfg.loadConfig(R01MConstants.API_APPCODE);
            _appSecurityCfgs.put(R01MConstants.API_APPCODE, authCfg);
        }
        if ((authCfg = _appSecurityCfgs.get(R01MConstants.API_APPCODE)) == null) {
            throw new R01MSecurityException("No se ha podido cargar la configuraci\u00f3n de autorizaci\u00f3n para la aplicaci\u00f3n '" + appCode + "'. Revisa la seccion <authorization> del fichero '" + appCode + ".properties.xml'");
        }
        if (authCfg.getProvider("appProvider") == null || authCfg.getProvider("appProvider").getClassName() == null) {
            throw new R01MSecurityException("No se ha configurado el provider de autorizacion. Revisa el fichero de configuracion de la aplicacion");
        }
        R01FBaseAuthProvider authProvider = null;
        try {
            if (authCfg.getProvider("appProvider").getInitParams() == null) {
                authCfg.getProvider("appProvider").setInitParams(new Properties());
            }
            authCfg.getProvider("appProvider").getInitParams().put("appCode", appCode);
        }
        catch (Exception ex) {
            throw new R01MSecurityException("Error al establecer el c\u00f3digo de aplicaci\u00f3n en el provider de autenticaci\u00f3n " + ex.getMessage());
        }
        try {
            authProvider = R01FAuthFilterUtils.obtainAuthProviderInstance((R01FAuthCfg)authCfg, null, (String)"appProvider");
        }
        catch (ReflectionException refEx) {
            throw new R01MSecurityException((Exception)((Object)refEx));
        }
        R01FTargetCfg targetCfg = R01FAuthFilterUtils.getResourceThatFirstMatches((R01FAuthCfg)authCfg, null);
        if (targetCfg == null) {
            throw new R01MSecurityException("NO se encuentra el target con uriPattern * (el utilizado por el API).\nRevisa la seccion <authCfg> del fichero " + appCode + ".properties.xml");
        }
        R01FAuthCtx authCtx = null;
        authCtx = !authCfg.isOverride() ? authProvider.getContext(authCfg) : new R01FAuthCtx(true, new R01FUserCtx("no-security", "no-security", null, null), null, new Date(), null);
        R01FTargetCtx targetCtx = authProvider.authorize(authCtx, targetCfg);
        if (targetCtx == null || targetCtx.authorizedResources == null || targetCtx.authorizedResources.size() == 0) {
            R01FLog.to((String)"r01m.security").severe("NO se ha podido cargar la info de autorizacion del recurso:\n1.- No hay acceso\n2.- El provider de autorizacion no ha funcionado");
            throw new R01MSecurityException("No se ha permitido el acceso al recurso!");
        }
        R01FLog.to((String)"r01m.security").info("Meter la infor de autorizacion del contexto en el contexto de autorizacion global en sesion");
        if (authCtx != null) {
            if (authCtx.authorizedTargets == null) {
                authCtx.authorizedTargets = new HashMap(1);
            }
            authCtx.authorizedTargets.put(targetCtx.targetCfg.uriPattern, targetCtx);
        }
        if (authCtx == null) {
            throw new R01MSecurityException("NO se ha podido obtener el contexto de seguridad!!!!");
        }
        R01MUserContext appContext = R01MAuthManager.createUserContext(authCtx);
        R01FLog.to((String)"r01m.security").info("LOGIN DE APLICACION: FIN createUserContextAppLogin(" + appCode + ")");
        return appContext;
    }

    public static R01MUserContext createUserContext(ServletRequest request) throws R01MSecurityException {
        return R01MAuthManager.createUserContext(R01MConstants.API_APPCODE, request);
    }

    public static R01MUserContext createUserContext(String appCode, ServletRequest request) throws R01MSecurityException {
        System.out.println("R01MUserContext createUserContext:" + request.getAttribute("R01FAuthCtx") + " Path:" + ((HttpServletRequest)request).getContextPath() + "\n Cookies-->>" + ((HttpServletRequest)request).getHeader("Cookie"));
        if (request.getAttribute("R01FAuthCtx") != null) {
            return R01MAuthManager.createUserContext(request.getAttribute("R01FAuthCtx"));
        }
        R01FAuthCfg authCfg = new R01FAuthCfg();
        if (_appSecurityCfgs.isEmpty() || _appSecurityCfgs.get(appCode) == null) {
            authCfg.loadConfig(appCode);
            _appSecurityCfgs.put(appCode, authCfg);
        }
        if ((authCfg = _appSecurityCfgs.get(appCode)) == null) {
            throw new R01MSecurityException("No se ha podido cargar la configuracion de autorizacion para la aplicacion '" + appCode + "'. Revisa la seccion <authorization> del fichero '" + appCode + ".properties.xml'");
        }
        if (authCfg.getProvider("userProvider") == null || authCfg.getProvider("userProvider").getClassName() == null) {
            throw new R01MSecurityException("No se ha configurado el provider de autorizacion. Revisa el fichero de configuracion de la aplicacion");
        }
        R01FBaseAuthProvider authProvider = null;
        R01FTargetCfg targetCfg = null;
        R01FTargetCtx targetCtx = null;
        try {
            authProvider = R01FAuthFilterUtils.obtainAuthProviderInstance((R01FAuthCfg)authCfg, (ServletRequest)request, (String)"userProvider");
        }
        catch (ReflectionException refEx) {
            throw new R01MSecurityException((Exception)((Object)refEx));
        }
        targetCfg = R01FAuthFilterUtils.getResourceThatFirstMatches((R01FAuthCfg)authCfg, null);
        if (targetCfg == null) {
            throw new R01MSecurityException("NO se encuentra el target con uriPattern * (el utilizado por el API).\nRevisa la seccion <authCfg> del fichero " + appCode + ".properties.xml");
        }
        R01FAuthCtx authCtx = null;
        if (!authCfg.isOverride()) {
            try {
                authCtx = authProvider.getContext(authCfg);
            }
            catch (Exception e) {
                throw new R01MSecurityException(">>>>>>>>> AUTH ERROR >>>>>>>>>>>> No se puede obtener un contexto de autorizaci\u00f3n. Error:" + e.getMessage() + "\n\tCookies:" + ((HttpServletRequest)request).getHeader("Cookie"));
            }
        } else {
            authCtx = new R01FAuthCtx(true, new R01FUserCtx("no-security", "no-security", null, null), null, new Date(), null);
        }
        if (authCtx == null) {
            throw new R01MSecurityException(">>>>>>>>> AUTH ERROR >>>>>>>>>>>> No se puede obtener un contexto de autorizaci\u00f3n. NULL!!!!!\n\tCookies:" + ((HttpServletRequest)request).getHeader("Cookie"));
        }
        targetCtx = authProvider.authorize(authCtx, targetCfg);
        if (targetCtx == null || targetCtx.authorizedResources == null || targetCtx.authorizedResources.size() == 0) {
            R01FLog.to((String)"r01m.security").severe("NO se ha podido cargar la info de autorizacion del recurso:\n1.- No hay acceso\n2.- El provider de autorizacion no ha funcionado");
            throw new R01MSecurityException("No se ha permitido el acceso al recurso!");
        }
        R01FLog.to((String)"r01m.security").info("Meter la infor de autorizacion del contexto en el contexto de autorizacion global en sesion");
        if (authCtx != null) {
            if (authCtx.authorizedTargets == null) {
                authCtx.authorizedTargets = new HashMap(1);
            }
            authCtx.authorizedTargets.put(targetCtx.targetCfg.uriPattern, targetCtx);
        }
        if (authCtx == null) {
            throw new R01MSecurityException("NO se ha podido obtener el contexto de seguridad!!!!");
        }
        return R01MAuthManager.createUserContext(authCtx);
    }

    public static R01MUserContext createGuestUserContext() {
        R01MUserContext userCtx = new R01MUserContext();
        userCtx.setUserName("Guest");
        userCtx.setUserProfile("guestSystem");
        return userCtx;
    }

    public static R01MUserContext createUserContext(Object securityCtx) throws R01MSecurityException {
        if (securityCtx == null) {
            throw new R01MSecurityException("\u00a1\u00a1\u00a1 El objeto de seguridad est\u00e1 VAC\u00cdO !!!");
        }
        R01MUserContext usrCtx = new R01MUserContext();
        HashMap<String, String> accesibleWorkAreas = new HashMap<String, String>();
        ArrayList<String> accesibleLabelBags = new ArrayList<String>();
        Map<String, R01MPortal> accesiblePortals = null;
        ArrayList<String> contentWorkAreaOids = new ArrayList<String>();
        ArrayList<String> portalWorkAreaOids = new ArrayList<String>();
        R01FAuthCtx authCtx = (R01FAuthCtx)securityCtx;
        if (authCtx.override) {
            usrCtx.setUserProfile("masterSystem");
        } else if (authCtx.getProfilesIterator() != null) {
            Iterator iter = authCtx.getProfilesIterator();
            while (iter.hasNext()) {
                R01FProfileCtx profile = (R01FProfileCtx)iter.next();
                if (!profile.getOID().equals(MASTER_PROFILE)) continue;
                usrCtx.setUserProfile("masterSystem");
                break;
            }
        } else {
            throw new R01MSecurityException("El usuario NO tiene perfiles de acceso!!!");
        }
        if (usrCtx.getUserProfile().equals("masterSystem")) {
            Map<String, R01MServer> servers = null;
            try {
                servers = R01MClientFactory.getStorageConfigAPI().getAllServerConfig();
            }
            catch (R01MConfigLoadException cfgLoadEx) {
                R01FLog.to((String)"r01m.security").severe("R01MAuthManager: No se han podido cargar los servidores para el usuario administrador: Comprueba que estan desplegadas las aplicaciones R01N y R01D: " + cfgLoadEx.getMessage());
            }
            catch (Throwable thExc) {
                R01FLog.to((String)"r01m.security").severe("R01MAuthManager: No se han podido cargar los servidores para el usuario administrador: Comprueba que estan desplegadas las aplicaciones R01N y R01D: " + thExc.getMessage());
            }
            if (servers != null) {
                StringBuffer traceStatus = new StringBuffer(76);
                for (R01MServer server : servers.values()) {
                    if (server.getDataRepositories() == null || server.getDataRepositories().isEmpty()) continue;
                    for (R01MDataRepository dataRepository : server.getDataRepositories().values()) {
                        if (dataRepository.getAreas() == null || dataRepository.getAreas().isEmpty()) continue;
                        for (R01MArea area : dataRepository.getAreas().values()) {
                            if (area.getWorkAreas() == null || area.getWorkAreas().isEmpty()) continue;
                            for (R01MWorkArea workArea : area.getWorkAreas().values()) {
                                traceStatus.append("La workarea ");
                                traceStatus.append(workArea.getInternalName());
                                if (workArea.isContentWorkArea()) {
                                    traceStatus.append(" esta ACCESIBLE para el Gestor de Contenidos.");
                                    accesibleWorkAreas.put(workArea.getOid(), ROLE_MASTER);
                                    contentWorkAreaOids.add(workArea.getOid());
                                }
                                if (workArea.isPortalWorkArea()) {
                                    traceStatus.append(" esta ACCESIBLE para el Gestor de Portales.");
                                    accesibleWorkAreas.put(workArea.getOid(), ROLE_MASTER);
                                    portalWorkAreaOids.add(workArea.getOid());
                                }
                                traceStatus.append("\n");
                            }
                        }
                    }
                }
                R01FLog.to((String)"r01m.security").info(traceStatus.toString());
            }
            try {
                List<String> allBagOids = R01MClientFactory.getCatalogAPI(new R01MUserContext()).getAllBagXLNetsUids();
                if (allBagOids != null && !allBagOids.isEmpty()) {
                    accesibleLabelBags = new ArrayList();
                    Iterator<String> bagsIt = allBagOids.iterator();
                    while (bagsIt.hasNext()) {
                        accesibleLabelBags.add(bagsIt.next());
                    }
                }
            }
            catch (R01MCatalogException catEx) {
                R01FLog.to((String)"r01m.security").severe("R01MAuthManager: No se han podido cargar las bolsas para el usuario administrador: Comprueba que esta desplegado R01E: " + catEx.getMessage());
            }
            catch (Throwable thExc) {
                R01FLog.to((String)"r01m.security").severe("R01MAuthManager: No se han podido cargar las bolsas para el usuario administrador: Comprueba que esta desplegado R01E: " + thExc.getMessage());
            }
            if (!SEARCHENGINE_CONTEXT.equalsIgnoreCase("internet")) {
                try {
                    accesiblePortals = R01MClientFactory.getPortalConfigAPI().getAllPortalConfig(portalWorkAreaOids);
                }
                catch (R01MConfigLoadException cfgLoadEx) {
                    R01FLog.to((String)"r01m.security").severe("R01MAuthManager: No se han podido cargar los portales para el usuario administrador: Comprueba que esta desplegado R01G: " + cfgLoadEx.getMessage());
                }
                catch (Throwable thExc) {
                    R01FLog.to((String)"r01m.security").severe("R01MAuthManager: No se han podido cargar los portales para el usuario administrador: Comprueba que esta desplegado R01G: " + thExc.getMessage());
                }
            }
        } else {
            HashMap<String, R01FResourceCtx> wkResCtxs = new HashMap<String, R01FResourceCtx>();
            HashMap<String, R01FResourceCtx> areaResCtxs = new HashMap<String, R01FResourceCtx>();
            HashMap<String, R01FResourceCtx> bagResCtxs = new HashMap<String, R01FResourceCtx>();
            HashMap<String, R01FResourceCtx> portalResCtxs = new HashMap<String, R01FResourceCtx>();
            R01FLog.to((String)"r01m.security").info(".................................................");
            R01FLog.to((String)"r01m.security").info("Inicio de identificaci\u00f3n de recursos autorizados.");
            if (authCtx.authorizedTargets != null && authCtx.authorizedTargets.size() > 0) {
                for (Map.Entry me1 : authCtx.authorizedTargets.entrySet()) {
                    R01FTargetCtx targetCtx = (R01FTargetCtx)me1.getValue();
                    for (Map.Entry me2 : targetCtx.authorizedResources.entrySet()) {
                        R01FResourceCtx resourceCtx = (R01FResourceCtx)me2.getValue();
                        if (resourceCtx.getParentOID().equals(R01FProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"security/objects/area"))) {
                            R01FLog.to((String)"r01m.security").info("Objeto Seguridad Area:" + resourceCtx.getName().getEs().trim());
                            areaResCtxs.put(resourceCtx.getName().getEs().trim(), resourceCtx);
                            continue;
                        }
                        if (resourceCtx.getParentOID().equals(R01FProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"security/objects/workarea"))) {
                            try {
                                R01MWorkArea waCfg = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(resourceCtx.getName().getEs().trim());
                                if (waCfg == null) continue;
                                if (waCfg.isContentWorkArea()) {
                                    R01FLog.to((String)"r01m.security").info("Objeto Seguridad WorkArea:" + resourceCtx.getName().getEs().trim());
                                    wkResCtxs.put(resourceCtx.getName().getEs().trim(), resourceCtx);
                                    contentWorkAreaOids.add(resourceCtx.getName().getEs().trim());
                                }
                                if (!waCfg.isPortalWorkArea()) continue;
                                R01FLog.to((String)"r01m.security").info("Objeto Seguridad WorkArea de Portal:" + resourceCtx.getName().getEs().trim());
                                portalResCtxs.put(resourceCtx.getName().getEs().trim(), resourceCtx);
                                portalWorkAreaOids.add(resourceCtx.getName().getEs().trim());
                            }
                            catch (R01MConfigLoadException cfgLoadEx) {
                                cfgLoadEx.printStackTrace(System.out);
                                R01FLog.to((String)"r01m.security").severe("ERROR al obtener la configuraci\u00f3n de la workArea " + resourceCtx.getName().getEs().trim() + " > " + cfgLoadEx.getMessage());
                            }
                            catch (Throwable thExc) {
                                thExc.printStackTrace(System.out);
                                R01FLog.to((String)"r01m.security").severe("!!!!! No se han podido cargar los servidores para el usuario !!!!!!");
                            }
                            continue;
                        }
                        if (!resourceCtx.getParentOID().equals(R01FProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"security/objects/catalogationBag").trim())) continue;
                        R01FLog.to((String)"r01m.security").info("Objeto Seguridad Bolsa de catalogacion:" + resourceCtx.getName().getEs().trim());
                        bagResCtxs.put(resourceCtx.getName().getEs().trim(), resourceCtx);
                    }
                }
            } else {
                R01FLog.to((String)"r01m.security").info("No hay objetos de seguridad...");
            }
            R01FLog.to((String)"r01m.security").info("Fin de identificaci\u00f3n de recursos autorizados.");
            R01FLog.to((String)"r01m.security").info("..............................................");
            R01FLog.to((String)"r01m.security").info("................................................................");
            R01FLog.to((String)"r01m.security").info("Inicio de identificaci\u00f3n de perfiles en cada recurso autorizado.");
            HashMap<String, R01FResourceCtx> globalResCtxs = new HashMap<String, R01FResourceCtx>(wkResCtxs.size() + portalResCtxs.size());
            if (wkResCtxs != null && !wkResCtxs.isEmpty()) {
                globalResCtxs.putAll(wkResCtxs);
            }
            if (portalResCtxs != null && !portalResCtxs.isEmpty()) {
                globalResCtxs.putAll(portalResCtxs);
            }
            if (areaResCtxs != null && !areaResCtxs.isEmpty()) {
                for (Map.Entry areaEntry : areaResCtxs.entrySet()) {
                    R01FResourceCtx aaResCtx = (R01FResourceCtx)areaEntry.getValue();
                    try {
                        R01MArea area = R01MClientFactory.getStorageConfigAPI().getAreaConfig(aaResCtx.getName().getEs().trim());
                        if (area.getWorkAreas() == null || area.getWorkAreas().isEmpty()) continue;
                        boolean bExistsConfiguredWA = false;
                        for (Map.Entry<String, R01MWorkArea> entry : area.getWorkAreas().entrySet()) {
                            if (!globalResCtxs.containsKey(entry.getKey())) continue;
                            bExistsConfiguredWA = true;
                            break;
                        }
                        if (bExistsConfiguredWA) continue;
                        for (R01MWorkArea r01MWorkArea : area.getWorkAreas().values()) {
                            R01FResourceAuthorization fakeAuth = new R01FResourceAuthorization("fakeAuth", r01MWorkArea.getOid() + "-" + AUTH_ACCESO, null, null, null);
                            HashMap<String, R01FResourceAuthorization> auths = new HashMap<String, R01FResourceAuthorization>(1);
                            auths.put(fakeAuth.getOID(), fakeAuth);
                            R01FResourceCtx fakeWAResCtx = new R01FResourceCtx(r01MWorkArea.getOid(), r01MWorkArea.getName("es"), r01MWorkArea.getName("eu"), r01MWorkArea.getOid(), aaResCtx.getName().getEs().trim(), auths);
                            if (r01MWorkArea.isContentWorkArea()) {
                                globalResCtxs.put(r01MWorkArea.getOid(), fakeWAResCtx);
                                contentWorkAreaOids.add(r01MWorkArea.getOid());
                            }
                            if (!r01MWorkArea.isPortalWorkArea()) continue;
                            globalResCtxs.put(r01MWorkArea.getOid(), fakeWAResCtx);
                            portalWorkAreaOids.add(r01MWorkArea.getOid());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.out);
                    }
                }
            }
            if (!globalResCtxs.isEmpty()) {
                R01FLog.to((String)"r01m.security").info("Tratar los objetos workarea identificados...");
                block28: for (Map.Entry me1 : globalResCtxs.entrySet()) {
                    R01FResourceCtx wkCtx = (R01FResourceCtx)me1.getValue();
                    R01FLog.to((String)"r01m.security").info("WORKAREA: " + wkCtx.getName().getEs());
                    if (wkCtx.authorizations != null && wkCtx.authorizations.size() > 0) {
                        R01FLog.to((String)"r01m.security").info("Tratar autorizaciones...");
                        boolean accesoWK = false;
                        for (Map.Entry me2 : wkCtx.authorizations.entrySet()) {
                            R01FResourceAuthorization r01FResourceAuthorization = (R01FResourceAuthorization)me2.getValue();
                            R01FLog.to((String)"r01m.security").info("Buscando autorizacion en la cadena " + r01FResourceAuthorization.getName().getEs());
                            if (r01FResourceAuthorization.getName().getEs().indexOf(AUTH_ACCESO) != -1) {
                                R01FLog.to((String)"r01m.security").info("Autorizacion de acceso.");
                                accesoWK = true;
                                continue;
                            }
                            if (r01FResourceAuthorization.getName().getEs().indexOf(ROLE_MASTER) != -1 || r01FResourceAuthorization.getName().getEs().indexOf(ROLE_EDITOR) != -1 || r01FResourceAuthorization.getName().getEs().indexOf(ROLE_AUTHOR) != -1 || r01FResourceAuthorization.getName().getEs().indexOf(ROLE_CATALG) != -1 || r01FResourceAuthorization.getName().getEs().indexOf(ROLE_VISITR) != -1) {
                                int readRoleLevel;
                                R01FLog.to((String)"r01m.security").info("Autorizacion de rol.");
                                accesoWK = true;
                                R01MAuthManager._setWorkareaRole(accesibleWorkAreas, wkCtx.getName().getEs().trim(), r01FResourceAuthorization);
                                String readRole = (String)accesibleWorkAreas.get(wkCtx.getName().getEs().trim());
                                if (readRole == null || (readRoleLevel = R01MAuthManager.getRoleLevel(readRole)) != R01MAuthManager.getRoleLevel(ROLE_MASTER)) continue;
                                break;
                            }
                            R01FLog.to((String)"r01m.security").info("Autorizaci\u00f3n no reconocida");
                        }
                        if (!accesoWK || accesibleWorkAreas.get(wkCtx.getName().getEs().trim()) != null) continue;
                        R01FLog.to((String)"r01m.security").info("Localizar el area a la que pertenece, para establecer el rol ..." + wkCtx.getSubType().trim());
                        R01FResourceCtx arCtx = (R01FResourceCtx)areaResCtxs.get(wkCtx.getSubType().trim());
                        if (arCtx != null) {
                            if (arCtx.authorizations == null || arCtx.authorizations.size() <= 0) continue;
                            for (Map.Entry entry : arCtx.authorizations.entrySet()) {
                                int readRoleLevel;
                                R01FResourceAuthorization auth = (R01FResourceAuthorization)entry.getValue();
                                R01MAuthManager._setWorkareaRole(accesibleWorkAreas, wkCtx.getName().getEs().trim(), auth);
                                String readRole = (String)accesibleWorkAreas.get(wkCtx.getName().getEs().trim());
                                if (readRole == null || (readRoleLevel = R01MAuthManager.getRoleLevel(readRole)) != R01MAuthManager.getRoleLevel(ROLE_MASTER)) continue;
                                continue block28;
                            }
                            continue;
                        }
                        R01FLog.to((String)"r01m.security").info("El objeto leido del Map de areas es nulo: No se puede establecer el rol en la workarea");
                        continue;
                    }
                    R01FLog.to((String)"r01m.security").info("No hay autorizaciones para la workarea.");
                }
            } else {
                R01FLog.to((String)"r01m.security").info("No se ha identificado ningun objeto workarea.");
            }
            if (bagResCtxs != null && !bagResCtxs.isEmpty()) {
                for (Map.Entry me1 : bagResCtxs.entrySet()) {
                    R01FResourceCtx bagCtx = (R01FResourceCtx)me1.getValue();
                    String bagXlNetsOid = bagCtx.getOID();
                    accesibleLabelBags.add(bagXlNetsOid);
                }
            } else {
                R01FLog.to((String)"r01m.security").info("No se ha identificado ningun objeto Bolsa de catalogacion.");
            }
            if (portalResCtxs != null && !portalResCtxs.isEmpty()) {
                R01FLog.to((String)"r01m.security").info("EXISTEN workareas de portal");
                ArrayList<String> portalWorkareaOids = new ArrayList<String>();
                for (Map.Entry me1 : portalResCtxs.entrySet()) {
                    R01FResourceCtx portalCtx = (R01FResourceCtx)me1.getValue();
                    portalWorkareaOids.add(portalCtx.getName().getEs().trim());
                    R01FLog.to((String)"r01m.security").info("Almacenando como WA de portal:" + portalCtx.getName().getEs().trim());
                }
                if (!SEARCHENGINE_CONTEXT.equalsIgnoreCase("internet")) {
                    try {
                        accesiblePortals = R01MClientFactory.getPortalConfigAPI().getAllPortalConfig(portalWorkareaOids);
                    }
                    catch (R01MConfigLoadException ex) {
                        R01FLog.to((String)"r01m.security").severe("!!!!! No se han podido cargar los portales para el usuario !!!!!!");
                    }
                    catch (Throwable thExc) {
                        thExc.printStackTrace(System.out);
                        R01FLog.to((String)"r01m.security").severe("!!!!! No se han podido cargar los portales para el usuario !!!!!!");
                    }
                }
            } else {
                R01FLog.to((String)"r01m.security").info("No se ha identificado ningun objeto Portal.");
            }
            R01FLog.to((String)"r01m.security").info("Fin de identificaci\u00f3n de perfiles en cada recurso autorizado.");
            R01FLog.to((String)"r01m.security").info(".............................................................");
        }
        R01MAuthManager._extractUserInfo(authCtx, usrCtx);
        usrCtx.setUserWorkAreas(accesibleWorkAreas);
        usrCtx.setUserContentWorkAreasOids(contentWorkAreaOids);
        usrCtx.setUserPortalWorkAreasOids(portalWorkAreaOids);
        usrCtx.setUserBags(accesibleLabelBags);
        usrCtx.setUserPortals(accesiblePortals);
        return usrCtx;
    }

    public static R01MUserContext createUserContext(String appCode, String[] workAreaOids, String[] labelBagOids, String[] portalOids) {
        int i;
        R01FAuthCtx authCtx = new R01FAuthCtx(false, new R01FUserCtx(appCode + "-security", appCode + "-security", null, null), null, new Date(), null);
        R01MUserContext usrCtx = new R01MUserContext();
        HashMap<String, String> accesibleWorkAreas = new HashMap<String, String>();
        ArrayList<String> accesibleLabelBags = new ArrayList<String>();
        HashMap<String, R01MPortal> accesiblePortals = new HashMap<String, R01MPortal>();
        ArrayList<String> contentWorkAreaOids = new ArrayList<String>();
        if (workAreaOids != null) {
            R01MStorageConfigAPI stgCfgAPI = R01MClientFactory.getStorageConfigAPI();
            String currWAOid = null;
            for (i = 0; i < workAreaOids.length; ++i) {
                currWAOid = workAreaOids[i];
                try {
                    R01MWorkArea wa = stgCfgAPI.getWorkAreaConfig(currWAOid);
                    if (wa == null) {
                        R01FLog.to((String)"r01m.security").severe("R01MAuthManager.createUserContext: La workArea " + currWAOid + " no existe. Se ignora");
                        continue;
                    }
                    if (!wa.isContentWorkArea()) continue;
                    accesibleWorkAreas.put(currWAOid, ROLE_EDITOR);
                    contentWorkAreaOids.add(currWAOid);
                    continue;
                }
                catch (R01MConfigLoadException ex) {
                    ex.printStackTrace(System.out);
                    R01FLog.to((String)"r01m.security").severe("R01MAuthManager.createUserContext: La workArea " + currWAOid + " no existe. Se ignora");
                }
            }
        }
        if (labelBagOids != null) {
            R01MCatalogManagerAPI catAPI = R01MClientFactory.getCatalogAPI(new R01MUserContext());
            String currBagOid = null;
            for (i = 0; i < labelBagOids.length; ++i) {
                currBagOid = labelBagOids[i];
                try {
                    R01MBag bag = catAPI.loadBag(currBagOid);
                    if (bag == null) {
                        R01FLog.to((String)"r01m.security").severe("R01MAuthManager.createUserContext: La bolsa de etiquetas " + currBagOid + " no existe. Se ignora");
                        continue;
                    }
                    accesibleLabelBags.add(bag.getBagXlnetsUID());
                    continue;
                }
                catch (R01MCatalogElementNotFoundException catNotFExc) {
                    catNotFExc.printStackTrace(System.out);
                    R01FLog.to((String)"r01m.security").severe("R01MAuthManager.createUserContext: La bolsa de etiquetas " + currBagOid + " no existe. Se ignora");
                    continue;
                }
                catch (R01MCatalogException ex) {
                    ex.printStackTrace(System.out);
                    R01FLog.to((String)"r01m.security").severe("R01MAuthManager.createUserContext: La bolsa de etiquetas " + currBagOid + " no se puede cargar. Se ignora");
                }
            }
        }
        if (!SEARCHENGINE_CONTEXT.equalsIgnoreCase("internet") && portalOids != null) {
            R01MPortalConfigAPI portalAPI = R01MClientFactory.getPortalConfigAPI();
            String currPortalOid = null;
            for (i = 0; i < portalOids.length; ++i) {
                currPortalOid = portalOids[i];
                try {
                    R01MPortal portal = portalAPI.loadPortal(currPortalOid);
                    if (portal == null) {
                        R01FLog.to((String)"r01m.security").severe("R01MAuthManager.createUserContext: El portal " + currPortalOid + " no existe. Se ignora");
                        continue;
                    }
                    accesiblePortals.put(currPortalOid, portal);
                    continue;
                }
                catch (R01MConfigLoadException cfgLoadEx) {
                    R01FLog.to((String)"r01m.security").severe("R01MAuthManager.createUserContext: El portal " + currPortalOid + " no existe. Se ignora");
                }
            }
        }
        R01MAuthManager._extractUserInfo(authCtx, usrCtx);
        usrCtx.setUserWorkAreas(accesibleWorkAreas);
        usrCtx.setUserContentWorkAreasOids(contentWorkAreaOids);
        usrCtx.setUserBags(accesibleLabelBags);
        usrCtx.setUserPortals(accesiblePortals);
        return usrCtx;
    }

    private static R01MUserContext _createNewMasterSystemUserContext(String userName) throws R01MSecurityException {
        R01FLog.to((String)"r01m.util").info("...autenticando con el usuario MASTER_SYSTEM!!!");
        R01FProfileCtx masterProfile = new R01FProfileCtx(MASTER_PROFILE, userName, userName);
        HashMap<String, R01FProfileCtx> profiles = new HashMap<String, R01FProfileCtx>(1);
        profiles.put(masterProfile.getOID(), masterProfile);
        R01FAuthCtx authCtx = new R01FAuthCtx(false, new R01FUserCtx("masterSystem", userName, null, null), null, new Date(), profiles);
        return R01MAuthManager.createUserContext(authCtx);
    }

    private static void _setWorkareaRole(Map<String, String> workareas, String wkName, R01FResourceAuthorization auth) {
        String readRole = null;
        if (auth.getName().getEs().indexOf(ROLE_MASTER) != -1) {
            readRole = ROLE_MASTER;
        } else if (auth.getName().getEs().indexOf(ROLE_EDITOR) != -1) {
            readRole = ROLE_EDITOR;
        } else if (auth.getName().getEs().indexOf(ROLE_AUTHOR) != -1) {
            readRole = ROLE_AUTHOR;
        } else if (auth.getName().getEs().indexOf(ROLE_CATALG) != -1) {
            readRole = ROLE_CATALG;
        } else if (auth.getName().getEs().indexOf(ROLE_VISITR) != -1) {
            readRole = ROLE_VISITR;
        }
        if (readRole != null) {
            int readRoleLevel = R01MAuthManager.getRoleLevel(readRole);
            if (workareas.get(wkName) == null) {
                workareas.put(wkName, readRole);
                R01FLog.to((String)"r01m.security").info("XLNETS: Estableciendo a la workarea " + wkName + " el rol " + readRole);
            } else {
                String writeRole = workareas.get(wkName);
                int writeRoleLevel = R01MAuthManager.getRoleLevel(writeRole);
                if (readRoleLevel > writeRoleLevel) {
                    workareas.put(wkName, readRole);
                    R01FLog.to((String)"r01m.security").info("XLNETS: Estableciendo a la workarea " + wkName + " el rol " + readRole);
                }
            }
        }
    }

    private static void _extractUserInfo(R01FAuthCtx authCtx, R01MUserContext usrCtx) {
        if (authCtx.getUser() != null) {
            if (StringUtils.isEmptyString((String)authCtx.getUser().getName())) {
                usrCtx.setUserName("authmng-unknown");
            } else {
                usrCtx.setUserName(authCtx.getUser().getName().trim());
            }
            if (null == authCtx.getUser().getAttribute("displayName") || "unknown".equalsIgnoreCase(authCtx.getUser().getAttribute("displayName"))) {
                usrCtx.setDisplayUserName(usrCtx.getUserName());
            } else {
                usrCtx.setDisplayUserName(authCtx.getUser().getAttribute("displayName"));
            }
            if (!StringUtils.isEmptyString((String)authCtx.getUser().getAttribute("login"))) {
                usrCtx.setUserMail(authCtx.getUser().getAttribute("login"));
            } else if (!StringUtils.isEmptyString((String)authCtx.getUser().getOID())) {
                usrCtx.setUserMail(authCtx.getUser().getOID());
            }
            if (authCtx.getUser().getAttribute("idioma") == null || authCtx.getUser().getAttribute("idioma") != null && authCtx.getUser().getAttribute("idioma").equals("1")) {
                usrCtx.setUserLang("es");
            } else {
                usrCtx.setUserLang("eu");
            }
        } else {
            usrCtx.setUserName("authmng-unknown");
            usrCtx.setUserLang(R01MConstants.DEFAULT_LANG);
        }
    }

    public static int getRoleLevel(String role) {
        if (role == null) {
            return -1;
        }
        if (roleLevel.get(role) != null) {
            return roleLevel.get(role);
        }
        return -1;
    }

    public static boolean canDo(R01MContentLocation loc, int action, R01MUserContext userContext) throws R01MSecurityException {
        R01MRoleRights roleRights = R01MAuthManager.getRoleRights(loc, userContext);
        return roleRights.canDo(action);
    }

    public static R01MRoleRights getRoleRights(R01MBaseLocationObject loc, R01MUserContext userContext) throws R01MSecurityException {
        R01MRoleRights noRights = new R01MRoleRights(null);
        if (loc == null || loc.getWorkAreaOid() == null) {
            throw new R01MSecurityException("No se puede comprobar la seguridad ya que el objeto de localizacion en el almacenamiento NO es valido!");
        }
        R01MRoleRights outRights = noRights;
        if (userContext.getUserProfile().equals("masterSystem")) {
            R01FLog.to((String)"r01m.security").info("El usuario que accede es administrador de sistema");
            outRights = new R01MRoleRights("111111111");
        } else if (userContext.getUserProfile().equals("guestSystem")) {
            R01FLog.to((String)"r01m.security").info("El usuario que accede es invitado de Sistema");
            outRights = new R01MRoleRights("100000000");
        } else {
            if (loc == null || loc.getWorkAreaOid() == null) {
                throw new R01MSecurityException("NO se puede obtener el rol del usuario ya que la localizacion del contenido es nula!!!");
            }
            String userRole = (String)userContext.getUserWorkAreas().get(loc.getWorkAreaOid());
            if (userRole == null) {
                outRights = noRights;
            } else {
                try {
                    R01MWorkArea waCfg = _storageCfgApi.getWorkAreaConfig(loc.getServerOid(), loc.getDataRepositoryOid(), loc.getAreaOid(), loc.getWorkAreaOid());
                    String roleRightsBitMapStr = null;
                    if (waCfg.getRoleRights() != null) {
                        roleRightsBitMapStr = waCfg.getRoleRights().get(userRole);
                    }
                    if (roleRightsBitMapStr == null) {
                        R01FLog.to((String)"r01m.security").warning("No se define informacion de derechos para el rol [" + userRole + "] en la localizaci\u00f3n server:dataStore:area:workArea > " + loc.getServerOid() + ":" + loc.getDataRepositoryOid() + ":" + loc.getAreaOid() + ":" + loc.getWorkAreaOid() + " >>>> Se deniega el permiso!!!");
                        outRights = noRights;
                    } else {
                        R01MRoleRights roleRights;
                        outRights = roleRights = new R01MRoleRights(roleRightsBitMapStr);
                    }
                }
                catch (R01MConfigLoadException cfgLoadEx) {
                    throw new R01MSecurityException("Error al obtener la configuracion de la workArea " + loc.getWorkAreaOid() + ": " + cfgLoadEx.getMessage(), (Exception)((Object)cfgLoadEx));
                }
                catch (NumberFormatException numFormatEx) {
                    throw new R01MSecurityException("Error en la configuracion de los derechos por rol: El bitMap no es correcto. Revisa los XML de configuracion de almacenamiento!!!");
                }
            }
        }
        R01FLog.to((String)"r01m.security").info(R01MAuthManager.composeDebugInfo(loc, userContext, outRights));
        return outRights;
    }

    public static String composeDebugInfo(R01MBaseLocationObject loc, R01MUserContext userContext, R01MRoleRights roleRights) {
        StringBuffer sb = new StringBuffer(76);
        sb.append("====> Derechos efectivos:");
        if (loc == null) {
            sb.append("Location: [No hay informacion]\r\n");
        } else {
            sb.append("Location:\r\n");
            sb.append(loc.composeDebugInfo());
        }
        if (userContext == null) {
            sb.append("Contexto de Usuario: [No hay informacion]");
        } else {
            sb.append("Contexto de Usuario:\r\n");
            sb.append(userContext.composeDebugInfo());
        }
        if (roleRights == null) {
            sb.append("RoleRights: [No hay informacion]");
        } else {
            sb.append("RoleRights\r\n");
            sb.append(roleRights.composeDebugInfo());
        }
        return sb.toString();
    }

    static {
        if (MASTER_PROFILE == null) {
            MASTER_PROFILE = "R01D-PF-AAAA";
        }
        roleLevel = new HashMap<String, Integer>();
        roleLevel.put(ROLE_MASTER, Integer.valueOf("5"));
        roleLevel.put(ROLE_EDITOR, Integer.valueOf("4"));
        roleLevel.put(ROLE_AUTHOR, Integer.valueOf("3"));
        roleLevel.put(ROLE_CATALG, Integer.valueOf("2"));
        roleLevel.put(ROLE_VISITR, Integer.valueOf("1"));
        _storageCfgApi = R01MClientFactory.getStorageConfigAPI();
        _appSecurityCfgs = new LinkedHashMap<String, R01FAuthCfg>();
        _adminCtx = new HashMap<String, R01MUserContext>();
        _loadTS = DateUtils.getDateFromMillis((long)0L).getTime();
    }
}

