/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.config.objects.typologymanagement;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.config.objects.typologymanagement.R01MPresentationTemplateConfig;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public class R01MContentTypeTemplateConfig
implements Serializable {
    private static final long serialVersionUID = 58329632581477945L;
    public static final String URL_TEMPLATE_GENERATE = "generate";
    public static final String URL_TEMPLATE_EDIT = "edit";
    private String oid;
    private String internalName;
    private String category;
    private Map name;
    private Map description;
    private Map urls;
    private boolean isDefaultTemplate = false;
    private boolean metaDataContainer = true;
    private String type = "default";
    private Map<String, R01MPresentationTemplateConfig> presentationTemplates;
    private Map properties;

    public R01MPresentationTemplateConfig getDefaultPresentationTemplate() {
        R01MPresentationTemplateConfig tplCfg = null;
        if (this.getPresentationTemplates() != null) {
            Iterator<R01MPresentationTemplateConfig> it = this.getPresentationTemplates().values().iterator();
            while (it.hasNext() && !(tplCfg = it.next()).getIsDefaultPresentationTemplate()) {
                if (it.hasNext()) continue;
                R01FLog.to((String)"r01m.config").warning("La configuracion de la plantilla " + this.getOid() + " NO DEFINE UNA PLANTILLA DE PRESENTACI\u00d3N POR DEFECTO: Se previsualizar\u00e1 una de ellas al azar!!!");
            }
        } else {
            R01FLog.to((String)"r01m.config").warning("No existen PLANTILLAS DE PRESENTACI\u00d3N configuradas para esta tipolog\u00eda.");
        }
        return tplCfg;
    }

    public String getMainGeneratedFileName() throws R01MConfigLoadException {
        String mainGeneratedFileName = null;
        String errMsg = null;
        R01MPresentationTemplateConfig tplCfg = this.getDefaultPresentationTemplate();
        if (tplCfg == null) {
            errMsg = "NO se ha definido una plantilla de presentaci\u00f3n por defecto en la plantilla " + this.oid;
        } else {
            mainGeneratedFileName = tplCfg.getMainGeneratedFile();
            if (mainGeneratedFileName == null) {
                errMsg = "NO se ha definido un fichero generado PRINCIPAL en la configuracion de la plantilla de presentacion por defecto " + tplCfg.getOid() + " correspondiente a la plantilla " + this.oid;
            }
        }
        if (errMsg != null) {
            throw new R01MConfigLoadException(errMsg);
        }
        return mainGeneratedFileName;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String theOid) {
        this.oid = theOid;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String theCategory) {
        this.category = theCategory;
    }

    public boolean getIsDefaultTemplate() {
        return this.isDefaultTemplate;
    }

    public boolean isDefaultTemplate() {
        return this.isDefaultTemplate;
    }

    public void setIsDefaultTemplate(boolean theIsDefaultTemplate) {
        this.isDefaultTemplate = theIsDefaultTemplate;
    }

    public boolean isMetaDataContainer() {
        return this.metaDataContainer;
    }

    public boolean getMetaDataContainer() {
        return this.isMetaDataContainer();
    }

    public void setMetaDataContainer(boolean theMetaDataContainer) {
        this.metaDataContainer = theMetaDataContainer;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String theType) {
        this.type = theType;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String theInternalName) {
        this.internalName = theInternalName;
    }

    public Map getName() {
        return this.name;
    }

    public void setName(Map theName) {
        this.name = theName;
    }

    public Map getDescription() {
        return this.description;
    }

    public void setDescription(Map theDescription) {
        this.description = theDescription;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map theProperties) {
        this.properties = theProperties;
    }

    public Map getUrls() {
        return this.urls;
    }

    public void setUrls(Map theUrls) {
        this.urls = theUrls;
    }

    public String getUrl(String urlIdx) {
        if (this.urls != null) {
            return (String)this.urls.get(urlIdx);
        }
        return null;
    }

    public Map<String, R01MPresentationTemplateConfig> getPresentationTemplates() {
        return this.presentationTemplates;
    }

    public R01MPresentationTemplateConfig getPresentationTemplate(String templateOid) {
        return this.presentationTemplates != null ? this.presentationTemplates.get(templateOid) : null;
    }

    public void setPresentationTemplates(Map<String, R01MPresentationTemplateConfig> thePresentationTemplates) {
        this.presentationTemplates = thePresentationTemplates;
    }
}

