/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.config.objects.searchmetadatastorage;

import com.ejie.r01m.config.objects.searchmetadatastorage.R01MClusterStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MClusterStorageIndependentConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MFamilyStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MMetaDataStorageConfig;
import com.ejie.r01m.config.objects.searchmetadatastorage.R01MTypeStorageConfig;
import com.ejie.r01m.config.objects.typology.R01MContentFamily;
import com.ejie.r01m.config.objects.typology.R01MContentType;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.services.R01MClientFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class R01MSearchMetaDataStorageConfig
implements Serializable {
    private static final long serialVersionUID = -7633939428500930179L;
    private static Map<String, R01MFamilyStorageConfig> _allFamiliesStorageConfigsCache = null;
    private static Map<String, R01MTypeStorageConfig> _allTypesStorageConfigsCache = null;
    private String id = "default";
    private Map<String, String> properties = null;
    private String fullTextSearchMetaData = "fullText";
    private R01MClusterStorageIndependentConfig clusterStorageIndependentConfig;
    private Map<String, R01MClusterStorageConfig> clustersStorageConfig;

    public R01MClusterStorageConfig getClusterStorageCfg(String clusterOid) {
        if (this.clustersStorageConfig == null) {
            return null;
        }
        return this.clustersStorageConfig.get(clusterOid);
    }

    public Map<String, R01MClusterStorageConfig> getAllClusterStorageConfig() {
        return this.clustersStorageConfig;
    }

    public R01MFamilyStorageConfig getFamilyStorageConfig(String clusterOid, String familyOid) {
        R01MFamilyStorageConfig outFamilyStorageCfg;
        R01MClusterStorageConfig cltrStgCfg;
        if (clusterOid != null && (cltrStgCfg = this.getClusterStorageCfg(clusterOid)) != null && (outFamilyStorageCfg = cltrStgCfg.getFamilyStorageConfig(familyOid)) != null) {
            return outFamilyStorageCfg;
        }
        return this.getFamilyStorageConfig(familyOid);
    }

    public R01MFamilyStorageConfig getFamilyStorageConfig(String familyOid) {
        Map<String, R01MFamilyStorageConfig> families = _allFamiliesStorageConfigsCache != null ? _allFamiliesStorageConfigsCache : this.getAllFamiliesStorageConfigIgnoringCluster();
        return families != null ? families.get(familyOid) : null;
    }

    public R01MFamilyStorageConfig getFamilyStorageConfigFromNumericId(int familyNumericId) {
        Map<String, R01MFamilyStorageConfig> families;
        Map<String, R01MFamilyStorageConfig> map = families = _allFamiliesStorageConfigsCache != null ? _allFamiliesStorageConfigsCache : this.getAllFamiliesStorageConfigIgnoringCluster();
        if (families != null) {
            try {
                R01MContentFamily familyCfg = R01MClientFactory.getTypologyConfigAPI().getFamilyConfigFromNumericId(familyNumericId);
                if (familyCfg != null) {
                    for (R01MFamilyStorageConfig currFamily : families.values()) {
                        if (!currFamily.getOid().equals(familyCfg.getOid())) continue;
                        return currFamily;
                    }
                }
            }
            catch (R01MConfigLoadException cfgLoadEx) {
                cfgLoadEx.printStackTrace(System.out);
            }
        }
        return null;
    }

    public Map<String, R01MFamilyStorageConfig> getAllFamiliesStorageConfigIgnoringCluster() {
        if (_allFamiliesStorageConfigsCache != null) {
            return _allFamiliesStorageConfigsCache;
        }
        HashMap<String, R01MFamilyStorageConfig> outFamilies = new HashMap<String, R01MFamilyStorageConfig>();
        Map<String, R01MClusterStorageConfig> clusterCfgs = this.getAllClusterStorageConfig();
        if (clusterCfgs != null) {
            for (R01MClusterStorageConfig currCluster : clusterCfgs.values()) {
                if (currCluster.getFamiliesStorageConfigs() == null) continue;
                for (R01MFamilyStorageConfig currFamily : currCluster.getFamiliesStorageConfigs().values()) {
                    if (outFamilies.containsKey(currFamily.getOid())) continue;
                    outFamilies.put(currFamily.getOid(), currFamily);
                }
            }
        }
        if (outFamilies.size() > 0) {
            _allFamiliesStorageConfigsCache = outFamilies;
            return outFamilies;
        }
        return null;
    }

    public R01MTypeStorageConfig getTypeStorageConfig(String clusterOid, String familyOid, String typeOid) {
        R01MTypeStorageConfig outTypeStorageConfig = null;
        R01MFamilyStorageConfig familyStorageCfg = null;
        if (clusterOid != null && familyOid != null) {
            familyStorageCfg = this.getFamilyStorageConfig(clusterOid, familyOid);
        } else if (familyOid != null) {
            familyStorageCfg = this.getFamilyStorageConfig(familyOid);
        }
        if (familyStorageCfg != null && (outTypeStorageConfig = familyStorageCfg.getTypeStorageConfig(typeOid)) != null) {
            return outTypeStorageConfig;
        }
        outTypeStorageConfig = this.getTypeStorageConfig(typeOid);
        return outTypeStorageConfig;
    }

    public R01MTypeStorageConfig getTypeStorageConfig(String familyOid, String typeOid) {
        return this.getTypeStorageConfig(null, familyOid, typeOid);
    }

    public R01MTypeStorageConfig getTypeStorageConfig(String typeOid) {
        Map<String, R01MTypeStorageConfig> types = _allTypesStorageConfigsCache != null ? _allTypesStorageConfigsCache : this.getAllTypesStorageConfigIgnoringFamilyAndCluster();
        return types != null ? types.get(typeOid) : null;
    }

    public R01MTypeStorageConfig getTypeStorageConfigFromNumericId(int typeNumericId) {
        Map<String, R01MTypeStorageConfig> types;
        Map<String, R01MTypeStorageConfig> map = types = _allTypesStorageConfigsCache != null ? _allTypesStorageConfigsCache : this.getAllTypesStorageConfigIgnoringFamilyAndCluster();
        if (types != null) {
            try {
                R01MContentType typeCfg = R01MClientFactory.getTypologyConfigAPI().getTypeConfigFromNumericId(typeNumericId);
                if (typeCfg != null) {
                    for (R01MTypeStorageConfig currType : types.values()) {
                        if (!currType.getOid().equals(typeCfg.getOid())) continue;
                        return currType;
                    }
                }
            }
            catch (R01MConfigLoadException cfgLoadEx) {
                cfgLoadEx.printStackTrace(System.out);
            }
        }
        return null;
    }

    public Map<String, R01MTypeStorageConfig> getAllTypesStorageConfigIgnoringFamilyAndCluster() {
        if (_allTypesStorageConfigsCache != null) {
            return _allTypesStorageConfigsCache;
        }
        HashMap<String, R01MTypeStorageConfig> outTypes = new HashMap<String, R01MTypeStorageConfig>();
        Map<String, R01MFamilyStorageConfig> families = this.getAllFamiliesStorageConfigIgnoringCluster();
        if (families != null) {
            for (R01MFamilyStorageConfig currFamily : families.values()) {
                if (currFamily.getTypesStorageConfigs() == null) continue;
                for (R01MTypeStorageConfig currType : currFamily.getTypesStorageConfigs().values()) {
                    if (outTypes.containsKey(currType.getOid())) continue;
                    outTypes.put(currType.getOid(), currType);
                }
            }
        }
        if (outTypes.size() > 0) {
            _allTypesStorageConfigsCache = outTypes;
            return outTypes;
        }
        return null;
    }

    public Map<String, R01MMetaDataStorageConfig> getTypeSearchMetaDataStorageCfgs(String clusterOid, String familyOid, String typeOid) {
        R01MTypeStorageConfig typeStorageConfig = null;
        if (clusterOid != null && familyOid != null && typeOid != null) {
            typeStorageConfig = this.getTypeStorageConfig(clusterOid, familyOid, typeOid);
        } else if (familyOid != null && typeOid != null) {
            typeStorageConfig = this.getTypeStorageConfig(familyOid, typeOid);
        } else if (typeOid != null) {
            typeStorageConfig = this.getTypeStorageConfig(typeOid);
        } else {
            return this.getClusterStorageIndependentConfig().getMetaDataStorageConfigs();
        }
        if (typeStorageConfig == null) {
            return null;
        }
        return typeStorageConfig.getMetaDataStorageConfigs();
    }

    public R01MMetaDataStorageConfig getTypeSearchMetaDataStorageCfg(String clusterOid, String familyOid, String typeOid, String metaDataOid) {
        Map<String, R01MMetaDataStorageConfig> md = this.getTypeSearchMetaDataStorageCfgs(clusterOid, familyOid, typeOid);
        if (md == null) {
            return null;
        }
        return md.get(metaDataOid);
    }

    public Map<String, R01MMetaDataStorageConfig> getTypeSearchMetaDataStorageCfgs(String familyOid, String typeOid) {
        return this.getTypeSearchMetaDataStorageCfgs(null, familyOid, typeOid);
    }

    public R01MMetaDataStorageConfig getTypeSearchMetaDataStorageCfg(String familyOid, String typeOid, String metaDataOid) {
        return this.getTypeSearchMetaDataStorageCfg(null, familyOid, typeOid, metaDataOid);
    }

    public Map<String, R01MMetaDataStorageConfig> getTypeSearchMetaDataStorageCfgs(String typeOid) {
        return this.getTypeSearchMetaDataStorageCfgs(null, null, typeOid);
    }

    public R01MMetaDataStorageConfig getTypeSearchMetaDataStorageCfg(String typeOid, String metaDataOid) {
        return this.getTypeSearchMetaDataStorageCfg(null, null, typeOid, metaDataOid);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String theId) {
        this.id = theId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> theProperties) {
        this.properties = theProperties;
    }

    public String getFullTextSearchMetaData() {
        return this.fullTextSearchMetaData;
    }

    public void setFullTextSearchMetaData(String theFullTextSearchMetaData) {
        this.fullTextSearchMetaData = theFullTextSearchMetaData;
    }

    public Map<String, R01MClusterStorageConfig> getClustersStorageConfig() {
        return this.clustersStorageConfig;
    }

    public void setClustersStorageConfig(Map<String, R01MClusterStorageConfig> theClusters) {
        this.clustersStorageConfig = theClusters;
    }

    public R01MClusterStorageIndependentConfig getClusterStorageIndependentConfig() {
        return this.clusterStorageIndependentConfig;
    }

    public void setClusterStorageIndependentConfig(R01MClusterStorageIndependentConfig theClusterStorageIndependentConfig) {
        this.clusterStorageIndependentConfig = theClusterStorageIndependentConfig;
    }

    public R01MClusterStorageConfig getClusterStorageConfigs(String theClusterOid) {
        if (this.clustersStorageConfig == null) {
            return null;
        }
        return this.clustersStorageConfig.get(theClusterOid);
    }
}

