/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.config.objects.searchengine.guide;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01m.config.objects.searchengine.guide.R01MSearchGuideDefBranch;
import com.ejie.r01m.utils.R01MConstants;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class R01MSearchGuideDef
implements Serializable {
    private static final long serialVersionUID = 4161205013496070238L;
    public static final String BRANCH_TYPE_TYPO = "typo";
    public static final String BRANCH_TYPE_STRUCTURE = "structure";
    public static final String BRANCH_TYPE_GEOSTRUCTURE = "geoStructure";
    private String oid;
    private Map name;
    private Map description;
    private R01MSearchGuideDefBranch startingBranch;

    public String getOid() {
        return this.oid;
    }

    public void setOid(String theOid) {
        this.oid = theOid;
    }

    public Map getName() {
        return this.name;
    }

    public void setName(Map theName) {
        this.name = theName;
    }

    public Map getDescription() {
        return this.description;
    }

    public void setDescription(Map theDescription) {
        this.description = theDescription;
    }

    public R01MSearchGuideDefBranch getStartingBranch() {
        return this.startingBranch;
    }

    public void setStartingBranch(R01MSearchGuideDefBranch theStartingBranch) {
        this.startingBranch = theStartingBranch;
    }

    public R01MSearchGuideDefBranch getBranchDef(String branchPath) {
        if (this.startingBranch == null) {
            return null;
        }
        StringBuffer currBranchPath = new StringBuffer(50);
        currBranchPath.append(this.getOid());
        R01MSearchGuideDefBranch currBranch = this.startingBranch;
        boolean branchFound = false;
        do {
            currBranchPath.append('/');
            currBranchPath.append(currBranch.getName());
            if (currBranchPath.toString().equals(branchPath)) {
                branchFound = true;
            }
            if (branchFound) continue;
            currBranch = currBranch.getNextLevelBranch();
        } while (!branchFound && currBranch != null);
        return branchFound ? currBranch : null;
    }

    public Map getBranchDefs() {
        if (this.startingBranch == null) {
            return null;
        }
        HashMap<String, R01MSearchGuideDefBranch> outMap = new HashMap<String, R01MSearchGuideDefBranch>();
        R01MSearchGuideDefBranch currBranch = this.startingBranch;
        do {
            outMap.put(currBranch.getPathInGuide(), currBranch);
        } while ((currBranch = currBranch.getNextLevelBranch()) != null);
        return outMap;
    }

    public void computeBranchPaths() {
        if (this.startingBranch == null) {
            return;
        }
        this._computeBranchPath(this.getOid(), this.getStartingBranch());
    }

    private void _computeBranchPath(String currPath, R01MSearchGuideDefBranch branch) {
        if (branch == null) {
            return;
        }
        branch.setPathInGuide(currPath + "/" + branch.getName());
        this._computeBranchPath(branch.getPathInGuide(), branch.getNextLevelBranch());
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            for (int times = 0; times < testTimes; ++times) {
                System.getProperties().list(System.out);
                String xml = StringUtils.loadFromFile((String)"d:/test.xml");
                R01MSearchGuideDef guideDef = (R01MSearchGuideDef)XOManager.getObject((String)R01MConstants.CONFIGCONTENTMODEL_MAPFILE, (String)xml);
                guideDef.computeBranchPaths();
                R01FLog.to((String)"r01m.searchEngine").info(">>>>>Obj OK");
                R01FLog.to((String)"r01m.searchEngine").info(XOManager.getXML((String)R01MConstants.CONFIGCONTENTMODEL_MAPFILE, (Object)guideDef));
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to((String)"r01m.searchEngine").info("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

