/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.config.objects.portalmodel;

import com.ejie.r01m.config.objects.portalmodel.R01MRenderer;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.objects.portalmodel.R01MVisualArea;
import com.ejie.r01m.services.R01MClientFactory;
import java.io.Serializable;
import java.util.Map;

public class R01MVisualAreasConfig
implements Serializable {
    private static final long serialVersionUID = 3333064662187595159L;
    private Map widgets;
    private Map commonParams;
    private Map visualAreas;
    private Map visualAreasRegeneration;

    public Map getCommonParams() {
        return this.commonParams;
    }

    public void setCommonParams(Map newCommonParams) {
        this.commonParams = newCommonParams;
    }

    public Map getVisualAreas() {
        return this.visualAreas;
    }

    public void setVisualAreas(Map newVisualAreas) {
        this.visualAreas = newVisualAreas;
    }

    public Map getWidgets() {
        return this.widgets;
    }

    public void setWidgets(Map newWidgets) {
        this.widgets = newWidgets;
    }

    public void addVisualArea(R01MVisualArea visualArea) {
        this.visualAreas.put(visualArea.getOid(), visualArea);
    }

    public Map getVisualAreasRegeneration() {
        return this.visualAreasRegeneration;
    }

    public void setVisualAreasRegeneration(Map newVisualAreasRegeneration) {
        this.visualAreasRegeneration = newVisualAreasRegeneration;
    }

    public static Map getRenderersFromVisualarea(String vaType) throws R01MPortalModelException {
        R01MVisualAreasConfig vaConfig = null;
        try {
            vaConfig = R01MClientFactory.getPortalVisualAreasConfigAPI().getVisualAreasConfig();
        }
        catch (R01MConfigLoadException clEx) {
            throw new R01MPortalModelException((Exception)((Object)clEx));
        }
        Map renderers = ((R01MVisualArea)vaConfig.getVisualAreas().get(vaType)).getRenderers();
        if (renderers == null) {
            throw new R01MPortalModelException("No se han definido correctamente los renderers en la configuraci\u00f3n del VA " + vaType);
        }
        return renderers;
    }

    public static String getGeneratedFileExtensionForVisualArea(String vaType, String resourceType) {
        try {
            return ((R01MRenderer)R01MVisualAreasConfig.getRenderersFromVisualarea(vaType).get(resourceType)).getProperties().get("fileExt").toString();
        }
        catch (R01MPortalModelException ex) {
            return resourceType;
        }
    }
}

