/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.config.objects.cataloguing;

import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDateUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class R01MPacketInfo
implements Serializable,
Comparable {
    private static final long serialVersionUID = -1010204271034344728L;
    private String packetOid;
    private String name;
    private int type = 1;
    private Date commitDate = null;
    private Date endDate = null;
    private int lastOperationsRequired = 0;
    private Map operationsCount = null;

    public String getPacketOid() {
        return this.packetOid;
    }

    public void setPacketOid(String thePacketOid) {
        this.packetOid = thePacketOid;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int theType) {
        this.type = theType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public Date getCommitDate() {
        return this.commitDate;
    }

    public void setCommitDate(Date theCommitDate) {
        this.commitDate = theCommitDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date theEndDate) {
        this.endDate = theEndDate;
    }

    public int getLastOperationsRequired() {
        return this.lastOperationsRequired;
    }

    public void setLastOperationsRequired(int theLastOperationsRequired) {
        this.lastOperationsRequired = theLastOperationsRequired;
    }

    public Map getOperationsCount() {
        return this.operationsCount;
    }

    public void setOperationsCount(Map theOperationsCount) {
        this.operationsCount = theOperationsCount;
    }

    public StringBuffer composeDebugInfo() {
        return this.composeDebugInfo("");
    }

    public StringBuffer composeDebugInfo(String prefix) {
        String tabPrefix = prefix + "\t";
        StringBuffer sb = new StringBuffer(500);
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("======== R01MChangesLabelsPacket  ========\r\n");
        sb.append(tabPrefix);
        sb.append("\tPacketOid:");
        sb.append(this.getPacketOid() == null ? "null" : this.getPacketOid());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tName:");
        sb.append(this.getName() == null ? "null" : this.getName());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tTipo:");
        sb.append(this.getType());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tCommitDate:");
        sb.append(this.getCommitDate() == null ? "null" : R01MDateUtils.dateToStr(this.getCommitDate(), R01MConstants.DEFAULT_LANG));
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tEndDate:");
        sb.append(this.getEndDate() == null ? "null" : R01MDateUtils.dateToStr(this.getEndDate(), R01MConstants.DEFAULT_LANG));
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tLastOperationsRequired:");
        sb.append(this.getLastOperationsRequired());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tOperationsCount:\r\n");
        if (this.getOperationsCount() != null && !this.getOperationsCount().isEmpty()) {
            for (Map.Entry me : this.getOperationsCount().entrySet()) {
                sb.append(tabPrefix);
                sb.append("\tOperationCount:" + me.getKey().toString() + "=" + me.getValue().toString());
                sb.append("\r\n");
            }
        }
        return sb;
    }

    public int compareTo(Object obj) {
        R01MPacketInfo packetInfo = (R01MPacketInfo)obj;
        return this.getCommitDate().compareTo(packetInfo.getCommitDate());
    }
}

