/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.config.objects.cataloguing;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelOperation;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDateUtils;
import com.ejie.r01m.utils.R01MUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class R01MChangesLabelsPacket
implements Serializable {
    private static final long serialVersionUID = 9066447593418609318L;
    public static final int PACKET_TYPE_CATALOG = 1;
    public static final int PACKET_TYPE_CONTENT = 2;
    public static final int PACKET_TYPE_PORTAL = 3;
    public static final int PACKET_ENABLED = 1;
    public static final int PACKET_DISABLED = 0;
    public static final int PACKET_TYPE_PROCESS_CONTINUE = 0;
    public static final int PACKET_TYPE_PROCESS_RESTART = 1;
    public static final int PACKET_TYPE_PROCESS_RESTART_ERROR = 2;
    public static final int PACKET_TYPE_PROCESS_RESTART_ALL = 3;
    private String packetOid;
    private String name;
    private int type = 1;
    private Date commitDate;
    private String userId;
    private List<R01MChangesLabelOperation> operations;
    private boolean packetEnabled = true;

    public R01MChangesLabelsPacket() {
        try {
            this.packetOid = R01MUtils.generateNewOid(R01MConstants.STRUCTURES_APPCODE, "structures");
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.packetOid = "error-unknown";
        }
    }

    public String getPacketOid() {
        return this.packetOid;
    }

    public void setPacketOid(String thePacketOid) {
        this.packetOid = thePacketOid;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int theType) {
        this.type = theType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public Date getCommitDate() {
        return this.commitDate;
    }

    public void setCommitDate(Date theCommitDate) {
        this.commitDate = theCommitDate;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String theUserId) {
        this.userId = theUserId;
    }

    public List<R01MChangesLabelOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<R01MChangesLabelOperation> theOperations) {
        this.operations = theOperations;
    }

    public boolean isPacketEnabled() {
        return this.packetEnabled;
    }

    public void setPacketEnabled(boolean thePacketEnabled) {
        this.packetEnabled = thePacketEnabled;
    }

    public int getPacketEnabledIntValue() {
        if (this.packetEnabled) {
            return 1;
        }
        return 0;
    }

    public StringBuffer composeDebugInfo() {
        return this.composeDebugInfo("");
    }

    public StringBuffer composeDebugInfo(String prefix) {
        String tabPrefix = prefix + "\t";
        StringBuffer sb = new StringBuffer(500);
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("======== R01MChangesLabelsPacket  ========\r\n");
        sb.append(tabPrefix);
        sb.append("\tPacketOid:");
        sb.append(this.getPacketOid() == null ? "null" : this.getPacketOid());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tName:");
        sb.append(this.getName() == null ? "null" : this.getName());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tTipo:");
        sb.append(this.getType());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tCommitDate:");
        sb.append(this.getCommitDate() == null ? "null" : R01MDateUtils.dateToStr(this.getCommitDate(), R01MConstants.DEFAULT_LANG));
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tUserId:");
        sb.append(this.getUserId() == null ? "null" : this.getUserId());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tOperations:\r\n");
        if (this.getOperations() != null && !this.getOperations().isEmpty()) {
            Iterator<R01MChangesLabelOperation> itOperations = this.getOperations().iterator();
            while (itOperations.hasNext()) {
                sb.append(itOperations.next().composeDebugInfo(tabPrefix));
                sb.append("\r\n");
            }
        } else {
            sb.append(tabPrefix);
            sb.append("\tNo existen operaciones.\r\n");
        }
        return sb;
    }
}

