/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.config.objects.cataloguing;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
import java.io.Serializable;

public class R01MChangesLabelOperation
implements Serializable,
Comparable<Object> {
    private static final long serialVersionUID = -8059455048026237903L;
    public static final int OPERATION_UNKNOWN = -1;
    public static final int OPERATION_CHANGE_TERM = 1;
    public static final int OPERATION_MOVE = 2;
    public static final int OPERATION_REMOVE_FROM_STRUCTURE = 3;
    public static final int OPERATION_DELETE = 4;
    public static final int OPERATION_ADD_LABEL = 5;
    public static final int OPERATION_REMOVE_LABEL = 6;
    public static final int MAX_ID_OPERATIONS = 6;
    public static final int OBJECT_TYPE_CONTENT = 0;
    public static final int OBJECT_TYPE_PAGE = 1;
    private String operationOid;
    private int order;
    private int operationType = -1;
    private int objectType;
    private String objectOid = null;
    private String objectParentOid = null;
    private String objectInternalName = null;
    private String objectName = null;
    private String labelOid;
    private String sourceStructureOid = null;
    private int sourceRole = 0;
    private String targetStructureOid = null;
    private String description = null;
    private int targetRole = 0;

    public R01MChangesLabelOperation() {
        try {
            this.operationOid = R01MUtils.generateNewOid(R01MConstants.STRUCTURES_APPCODE, "structures");
        }
        catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.operationOid = "error-unknown";
        }
    }

    public String getOperationOid() {
        return this.operationOid;
    }

    public void setOperationOid(String theOperationOid) {
        this.operationOid = theOperationOid;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int theOrder) {
        this.order = theOrder;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public void setOperationType(int theOperationType) {
        this.operationType = theOperationType;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public void setObjectType(int newObjectType) {
        this.objectType = newObjectType;
    }

    public String getObjectOid() {
        return this.objectOid;
    }

    public void setObjectOid(String theObjectOid) {
        this.objectOid = theObjectOid;
    }

    public String getLabelOid() {
        return this.labelOid;
    }

    public void setLabelOid(String theLabelOid) {
        this.labelOid = theLabelOid;
    }

    public String getSourceStructureOid() {
        return this.sourceStructureOid;
    }

    public void setSourceStructureOid(String theSourceStructureOid) {
        this.sourceStructureOid = theSourceStructureOid;
    }

    public int getSourceRole() {
        return this.sourceRole;
    }

    public void setSourceRole(int theSourceRole) {
        this.sourceRole = theSourceRole;
    }

    public void setSourceRole(String theSourceRole) {
        if (NumberUtils.isInteger((String)theSourceRole)) {
            this.sourceRole = Integer.parseInt(theSourceRole);
        }
    }

    public String getTargetStructureOid() {
        return this.targetStructureOid;
    }

    public void setTargetStructureOid(String theTargetStructureOid) {
        this.targetStructureOid = theTargetStructureOid;
    }

    public int getTargetRole() {
        return this.targetRole;
    }

    public void setTargetRole(int theTargetRole) {
        this.targetRole = theTargetRole;
    }

    public void setTargetRole(String theTargetRole) {
        if (NumberUtils.isInteger((String)theTargetRole)) {
            this.targetRole = Integer.parseInt(theTargetRole);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String theObjectName) {
        this.objectName = theObjectName;
    }

    public String getObjectParentOid() {
        return this.objectParentOid;
    }

    public void setObjectParentOid(String theObjectParentOid) {
        this.objectParentOid = theObjectParentOid;
    }

    public String getObjectInternalName() {
        return this.objectInternalName;
    }

    public void setObjectInternalName(String theObjectInternalName) {
        this.objectInternalName = theObjectInternalName;
    }

    public StringBuffer composeDebugInfo() {
        return this.composeDebugInfo("");
    }

    public StringBuffer composeDebugInfo(String prefix) {
        String tabPrefix = prefix + "\t";
        StringBuffer sb = new StringBuffer(500);
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("======== R01MChangesLabelOperation  ========\r\n");
        sb.append(tabPrefix);
        sb.append("\tOperationOid:");
        sb.append(this.getOperationOid() == null ? "null" : this.getOperationOid());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tOrder:");
        sb.append(this.getOrder());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tOperationType:");
        sb.append(this.getOperationType());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tObjectOid:");
        sb.append(this.getObjectOid() == null ? "null" : this.getObjectOid());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tObjectName:");
        sb.append(this.getObjectName() == null ? "null" : this.getObjectName());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tObjectInternalName:");
        sb.append(this.getObjectInternalName() == null ? "null" : this.getObjectInternalName());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tObjectParentName:");
        sb.append(this.getObjectParentOid() == null ? "null" : this.getObjectParentOid());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tLabelOid:");
        sb.append(this.getLabelOid() == null ? "null" : this.getLabelOid());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tSourceStructureOid:");
        sb.append(this.getSourceStructureOid() == null ? "null" : this.getSourceStructureOid());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tSourceRole:");
        sb.append(this.getSourceRole());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tTargetStructureOid:");
        sb.append(this.getTargetStructureOid() == null ? "null" : this.getTargetStructureOid());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tTargetRole:");
        sb.append(this.getTargetRole());
        sb.append("\r\n");
        sb.append(tabPrefix);
        sb.append("\tDescription:");
        sb.append(this.getObjectName() == null ? "null" : this.getObjectName());
        sb.append("\r\n");
        return sb;
    }

    @Override
    public int compareTo(Object obj) {
        R01MChangesLabelOperation operation = (R01MChangesLabelOperation)obj;
        return this.getOrder() - operation.getOrder();
    }
}

