/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01m.commoninterface.tags.util;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.exceptions.R01MMiscDataLoadException;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeoMunicipality;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeoTerritory;
import com.ejie.r01m.objects.cataloguing.geo.R01MGeocode;
import com.ejie.r01m.services.R01MClientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class R01MGeographicCatalogLoad {
    public Map getProvinces(String lang) throws Exception {
        Map provincesMap = null;
        try {
            provincesMap = R01MClientFactory.getMiscellaneousAPI().loadProvinces(lang);
        }
        catch (R01MMiscDataLoadException misc) {
            R01FLog.to((String)"r01m.selectiontool").severe("R01LGeographicCatalogLoad_getProvinces(): " + misc.getMessage());
        }
        return provincesMap;
    }

    public Map getMunicipalities(String lang, String provinceOid) {
        Map municipalitiesMap = null;
        try {
            municipalitiesMap = R01MClientFactory.getMiscellaneousAPI().loadMunicipalities(lang, provinceOid);
        }
        catch (R01MMiscDataLoadException miscExc) {
            R01FLog.to((String)"r01m.selectiontool").severe("R01LGeographicCatalogLoad_getMunicipalities: " + miscExc.getMessage());
        }
        return municipalitiesMap;
    }

    public List getGeograohicCatalogProvince(List provinceOidList, String lang) {
        ArrayList<R01MGeocode> outGeoLabels = new ArrayList<R01MGeocode>();
        if (provinceOidList.size() > 0) {
            Map provincesMap = null;
            try {
                provincesMap = R01MClientFactory.getMiscellaneousAPI().loadProvinces(lang);
            }
            catch (R01MMiscDataLoadException misc) {
                R01FLog.to((String)"r01m.selectiontool").severe("R01LGeographicCatalogLoad_getProvinces(): " + misc.getMessage());
            }
            for (int i = 0; i < provinceOidList.size(); ++i) {
                String provinceOid = (String)provinceOidList.get(i);
                if (!provincesMap.containsKey(provinceOid)) continue;
                R01MGeocode geoCatalog = new R01MGeocode();
                geoCatalog.setTerritory(new R01MGeoTerritory(provinceOid, (String)provincesMap.get(provinceOid)));
                outGeoLabels.add(geoCatalog);
            }
        }
        return outGeoLabels;
    }

    public List getGeograohicCatalogProvinceMunicipal(List provinceMunicipalitiesOidList, String lang) {
        ArrayList<R01MGeocode> geoCatalogList = new ArrayList<R01MGeocode>();
        try {
            for (int i = 0; i < provinceMunicipalitiesOidList.size(); ++i) {
                String provinceOid = (String)((ArrayList)provinceMunicipalitiesOidList.get(i)).get(0);
                Map provincesMap = R01MClientFactory.getMiscellaneousAPI().loadProvinces(lang);
                String municipalitiOid = (String)((ArrayList)provinceMunicipalitiesOidList.get(i)).get(1);
                Map municipalitiesMap = R01MClientFactory.getMiscellaneousAPI().loadMunicipalities(lang, provinceOid);
                if (!municipalitiesMap.containsKey(municipalitiOid)) continue;
                R01MGeocode geoCatalog = new R01MGeocode();
                geoCatalog.setTerritory(new R01MGeoTerritory(provinceOid, (String)provincesMap.get(provinceOid)));
                geoCatalog.setMunicipality(new R01MGeoMunicipality(municipalitiOid, (String)municipalitiesMap.get(municipalitiOid)));
                geoCatalogList.add(geoCatalog);
            }
        }
        catch (R01MMiscDataLoadException miscExc) {
            R01FLog.to((String)"r01m.selectiontool").severe("R01LGeographicCatalogLoad_getMunicipalities: " + miscExc.getMessage());
        }
        return geoCatalogList;
    }
}

